/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientId", "secretKey", "tokenEndpoint"})
public class CustomOIDCSSOClientConfig {
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Custom OIDC Client ID.")
    @NotNull
    private String clientId;
    @JsonProperty(value="secretKey")
    @JsonPropertyDescription(value="Custom OIDC Client Secret Key.")
    @PasswordField
    @NotNull
    private String secretKey;
    @JsonProperty(value="tokenEndpoint")
    @JsonPropertyDescription(value="Custom OIDC token endpoint.")
    @NotNull
    private String tokenEndpoint;

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CustomOIDCSSOClientConfig withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="secretKey")
    @PasswordField
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @PasswordField
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public CustomOIDCSSOClientConfig withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @JsonProperty(value="tokenEndpoint")
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @JsonProperty(value="tokenEndpoint")
    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public CustomOIDCSSOClientConfig withTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomOIDCSSOClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("secretKey");
        sb.append('=');
        sb.append(this.secretKey == null ? "<null>" : this.secretKey);
        sb.append(',');
        sb.append("tokenEndpoint");
        sb.append('=');
        sb.append(this.tokenEndpoint == null ? "<null>" : this.tokenEndpoint);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tokenEndpoint == null ? 0 : this.tokenEndpoint.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomOIDCSSOClientConfig)) {
            return false;
        }
        CustomOIDCSSOClientConfig rhs = (CustomOIDCSSOClientConfig)other;
        return (this.tokenEndpoint == rhs.tokenEndpoint || this.tokenEndpoint != null && this.tokenEndpoint.equals(rhs.tokenEndpoint)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.secretKey == rhs.secretKey || this.secretKey != null && this.secretKey.equals(rhs.secretKey));
    }
}

