/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"jwtToken"})
public class OpenMetadataJWTClientConfig {
    @JsonProperty(value="jwtToken")
    @JsonPropertyDescription(value="OpenMetadata generated JWT token.")
    @PasswordField
    @NotNull
    private String jwtToken;

    @JsonProperty(value="jwtToken")
    @PasswordField
    public String getJwtToken() {
        return this.jwtToken;
    }

    @JsonProperty(value="jwtToken")
    @PasswordField
    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public OpenMetadataJWTClientConfig withJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenMetadataJWTClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jwtToken");
        sb.append('=');
        sb.append(this.jwtToken == null ? "<null>" : this.jwtToken);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.jwtToken == null ? 0 : this.jwtToken.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenMetadataJWTClientConfig)) {
            return false;
        }
        OpenMetadataJWTClientConfig rhs = (OpenMetadataJWTClientConfig)other;
        return this.jwtToken == rhs.jwtToken || this.jwtToken != null && this.jwtToken.equals(rhs.jwtToken);
    }
}

