/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.service.configuration.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.IndexMappingLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"host", "port", "scheme", "username", "password", "truststorePath", "truststorePassword", "connectionTimeoutSecs", "socketTimeoutSecs", "batchSize", "searchIndexMappingLanguage"})
public class ElasticSearchConfiguration {
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Elastic Search Host")
    @NotNull
    private String host;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="Elastic Search port")
    @NotNull
    private Integer port;
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="Http/Https connection scheme")
    @NotNull
    private String scheme;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Elastic Search Username for Login")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Elastic Search Password for Login")
    private String password;
    @JsonProperty(value="truststorePath")
    @JsonPropertyDescription(value="Truststore Path")
    private String truststorePath;
    @JsonProperty(value="truststorePassword")
    @JsonPropertyDescription(value="Truststore Password")
    private String truststorePassword;
    @JsonProperty(value="connectionTimeoutSecs")
    @JsonPropertyDescription(value="Connection Timeout in Seconds")
    @NotNull
    private Integer connectionTimeoutSecs = 5;
    @JsonProperty(value="socketTimeoutSecs")
    @JsonPropertyDescription(value="Socket Timeout in Seconds")
    @NotNull
    private Integer socketTimeoutSecs = 60;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Batch Size for Requests")
    @NotNull
    private Integer batchSize = 10;
    @JsonProperty(value="searchIndexMappingLanguage")
    @JsonPropertyDescription(value="This schema defines the language options available for search index mappings.")
    @NotNull
    private IndexMappingLanguage searchIndexMappingLanguage = IndexMappingLanguage.fromValue("EN");

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public ElasticSearchConfiguration withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public ElasticSearchConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="scheme")
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ElasticSearchConfiguration withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public ElasticSearchConfiguration withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public ElasticSearchConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="truststorePath")
    public String getTruststorePath() {
        return this.truststorePath;
    }

    @JsonProperty(value="truststorePath")
    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public ElasticSearchConfiguration withTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    @JsonProperty(value="truststorePassword")
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @JsonProperty(value="truststorePassword")
    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public ElasticSearchConfiguration withTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public Integer getConnectionTimeoutSecs() {
        return this.connectionTimeoutSecs;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public void setConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
    }

    public ElasticSearchConfiguration withConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        return this;
    }

    @JsonProperty(value="socketTimeoutSecs")
    public Integer getSocketTimeoutSecs() {
        return this.socketTimeoutSecs;
    }

    @JsonProperty(value="socketTimeoutSecs")
    public void setSocketTimeoutSecs(Integer socketTimeoutSecs) {
        this.socketTimeoutSecs = socketTimeoutSecs;
    }

    public ElasticSearchConfiguration withSocketTimeoutSecs(Integer socketTimeoutSecs) {
        this.socketTimeoutSecs = socketTimeoutSecs;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public ElasticSearchConfiguration withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public IndexMappingLanguage getSearchIndexMappingLanguage() {
        return this.searchIndexMappingLanguage;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public void setSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
    }

    public ElasticSearchConfiguration withSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ElasticSearchConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("truststorePath");
        sb.append('=');
        sb.append(this.truststorePath == null ? "<null>" : this.truststorePath);
        sb.append(',');
        sb.append("truststorePassword");
        sb.append('=');
        sb.append(this.truststorePassword == null ? "<null>" : this.truststorePassword);
        sb.append(',');
        sb.append("connectionTimeoutSecs");
        sb.append('=');
        sb.append(this.connectionTimeoutSecs == null ? "<null>" : this.connectionTimeoutSecs);
        sb.append(',');
        sb.append("socketTimeoutSecs");
        sb.append('=');
        sb.append(this.socketTimeoutSecs == null ? "<null>" : this.socketTimeoutSecs);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("searchIndexMappingLanguage");
        sb.append('=');
        sb.append(this.searchIndexMappingLanguage == null ? "<null>" : this.searchIndexMappingLanguage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.truststorePassword == null ? 0 : this.truststorePassword.hashCode());
        result = result * 31 + (this.connectionTimeoutSecs == null ? 0 : this.connectionTimeoutSecs.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.socketTimeoutSecs == null ? 0 : this.socketTimeoutSecs.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.searchIndexMappingLanguage == null ? 0 : this.searchIndexMappingLanguage.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.truststorePath == null ? 0 : this.truststorePath.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ElasticSearchConfiguration)) {
            return false;
        }
        ElasticSearchConfiguration rhs = (ElasticSearchConfiguration)other;
        return (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.truststorePassword == rhs.truststorePassword || this.truststorePassword != null && this.truststorePassword.equals(rhs.truststorePassword)) && (this.connectionTimeoutSecs == rhs.connectionTimeoutSecs || this.connectionTimeoutSecs != null && this.connectionTimeoutSecs.equals(rhs.connectionTimeoutSecs)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals(rhs.scheme)) && (this.socketTimeoutSecs == rhs.socketTimeoutSecs || this.socketTimeoutSecs != null && this.socketTimeoutSecs.equals(rhs.socketTimeoutSecs)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.searchIndexMappingLanguage == rhs.searchIndexMappingLanguage || this.searchIndexMappingLanguage != null && this.searchIndexMappingLanguage.equals((Object)rhs.searchIndexMappingLanguage)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.truststorePath == rhs.truststorePath || this.truststorePath != null && this.truststorePath.equals(rhs.truststorePath)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }
}

