/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "accessToken", "accessTokenPassword", "workspaceName", "supportsMetadataExtraction"})
public class ModeConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Mode service type")
    private ModeType type = ModeType.fromValue("Mode");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="URL for the mode instance.")
    @ExposedField
    private URI hostPort = URI.create("https://app.mode.com");
    @JsonProperty(value="accessToken")
    @JsonPropertyDescription(value="Access Token for Mode Dashboard")
    @NotNull
    private String accessToken;
    @JsonProperty(value="accessTokenPassword")
    @JsonPropertyDescription(value="Access Token Password for Mode Dashboard")
    @PasswordField
    @NotNull
    private String accessTokenPassword;
    @JsonProperty(value="workspaceName")
    @JsonPropertyDescription(value="Mode Workspace Name")
    @NotNull
    private String workspaceName;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public ModeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ModeType type) {
        this.type = type;
    }

    public ModeConnection withType(ModeType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public ModeConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="accessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public ModeConnection withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @JsonProperty(value="accessTokenPassword")
    @PasswordField
    public String getAccessTokenPassword() {
        return this.accessTokenPassword;
    }

    @JsonProperty(value="accessTokenPassword")
    @PasswordField
    public void setAccessTokenPassword(String accessTokenPassword) {
        this.accessTokenPassword = accessTokenPassword;
    }

    public ModeConnection withAccessTokenPassword(String accessTokenPassword) {
        this.accessTokenPassword = accessTokenPassword;
        return this;
    }

    @JsonProperty(value="workspaceName")
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @JsonProperty(value="workspaceName")
    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public ModeConnection withWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public ModeConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ModeConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("accessToken");
        sb.append('=');
        sb.append(this.accessToken == null ? "<null>" : this.accessToken);
        sb.append(',');
        sb.append("accessTokenPassword");
        sb.append('=');
        sb.append(this.accessTokenPassword == null ? "<null>" : this.accessTokenPassword);
        sb.append(',');
        sb.append("workspaceName");
        sb.append('=');
        sb.append(this.workspaceName == null ? "<null>" : this.workspaceName);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.accessTokenPassword == null ? 0 : this.accessTokenPassword.hashCode());
        result = result * 31 + (this.workspaceName == null ? 0 : this.workspaceName.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ModeConnection)) {
            return false;
        }
        ModeConnection rhs = (ModeConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.accessTokenPassword == rhs.accessTokenPassword || this.accessTokenPassword != null && this.accessTokenPassword.equals(rhs.accessTokenPassword)) && (this.workspaceName == rhs.workspaceName || this.workspaceName != null && this.workspaceName.equals(rhs.workspaceName)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.accessToken == rhs.accessToken || this.accessToken != null && this.accessToken.equals(rhs.accessToken));
    }

    public static enum ModeType {
        MODE("Mode");

        private final String value;
        private static final Map<String, ModeType> CONSTANTS;

        private ModeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ModeType fromValue(String value) {
            ModeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ModeType>();
            for (ModeType c : ModeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

