/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.security.ssl.VerifySSL;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "username", "password", "apiVersion", "siteName", "siteUrl", "personalAccessTokenName", "personalAccessTokenSecret", "env", "verifySSL", "sslConfig", "supportsMetadataExtraction"})
public class TableauConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Tableau service type")
    private TableauType type = TableauType.fromValue("Tableau");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Tableau Server.")
    @ExposedField
    private URI hostPort;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username for Tableau.")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password for Tableau.")
    @PasswordField
    private String password;
    @JsonProperty(value="apiVersion")
    @JsonPropertyDescription(value="Tableau API version.")
    @NotNull
    private String apiVersion;
    @JsonProperty(value="siteName")
    @JsonPropertyDescription(value="Tableau Site Name.")
    private String siteName;
    @JsonProperty(value="siteUrl")
    @JsonPropertyDescription(value="Tableau Site Url.")
    private String siteUrl;
    @JsonProperty(value="personalAccessTokenName")
    @JsonPropertyDescription(value="Personal Access Token Name.")
    private String personalAccessTokenName;
    @JsonProperty(value="personalAccessTokenSecret")
    @JsonPropertyDescription(value="Personal Access Token Secret.")
    @PasswordField
    private String personalAccessTokenSecret;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="Tableau Environment Name.")
    @NotNull
    private String env = "tableau_prod";
    @JsonProperty(value="verifySSL")
    @JsonPropertyDescription(value="Client SSL verification. Make sure to configure the SSLConfig if enabled.")
    private VerifySSL verifySSL = VerifySSL.fromValue("no-ssl");
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    private Object sslConfig;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public TableauType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TableauType type) {
        this.type = type;
    }

    public TableauConnection withType(TableauType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public TableauConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public TableauConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public TableauConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public TableauConnection withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @JsonProperty(value="siteName")
    public String getSiteName() {
        return this.siteName;
    }

    @JsonProperty(value="siteName")
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public TableauConnection withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    @JsonProperty(value="siteUrl")
    public String getSiteUrl() {
        return this.siteUrl;
    }

    @JsonProperty(value="siteUrl")
    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public TableauConnection withSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    @JsonProperty(value="personalAccessTokenName")
    public String getPersonalAccessTokenName() {
        return this.personalAccessTokenName;
    }

    @JsonProperty(value="personalAccessTokenName")
    public void setPersonalAccessTokenName(String personalAccessTokenName) {
        this.personalAccessTokenName = personalAccessTokenName;
    }

    public TableauConnection withPersonalAccessTokenName(String personalAccessTokenName) {
        this.personalAccessTokenName = personalAccessTokenName;
        return this;
    }

    @JsonProperty(value="personalAccessTokenSecret")
    @PasswordField
    public String getPersonalAccessTokenSecret() {
        return this.personalAccessTokenSecret;
    }

    @JsonProperty(value="personalAccessTokenSecret")
    @PasswordField
    public void setPersonalAccessTokenSecret(String personalAccessTokenSecret) {
        this.personalAccessTokenSecret = personalAccessTokenSecret;
    }

    public TableauConnection withPersonalAccessTokenSecret(String personalAccessTokenSecret) {
        this.personalAccessTokenSecret = personalAccessTokenSecret;
        return this;
    }

    @JsonProperty(value="env")
    public String getEnv() {
        return this.env;
    }

    @JsonProperty(value="env")
    public void setEnv(String env) {
        this.env = env;
    }

    public TableauConnection withEnv(String env) {
        this.env = env;
        return this;
    }

    @JsonProperty(value="verifySSL")
    public VerifySSL getVerifySSL() {
        return this.verifySSL;
    }

    @JsonProperty(value="verifySSL")
    public void setVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
    }

    public TableauConnection withVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
        return this;
    }

    @JsonProperty(value="sslConfig")
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public TableauConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public TableauConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableauConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("apiVersion");
        sb.append('=');
        sb.append(this.apiVersion == null ? "<null>" : this.apiVersion);
        sb.append(',');
        sb.append("siteName");
        sb.append('=');
        sb.append(this.siteName == null ? "<null>" : this.siteName);
        sb.append(',');
        sb.append("siteUrl");
        sb.append('=');
        sb.append(this.siteUrl == null ? "<null>" : this.siteUrl);
        sb.append(',');
        sb.append("personalAccessTokenName");
        sb.append('=');
        sb.append(this.personalAccessTokenName == null ? "<null>" : this.personalAccessTokenName);
        sb.append(',');
        sb.append("personalAccessTokenSecret");
        sb.append('=');
        sb.append(this.personalAccessTokenSecret == null ? "<null>" : this.personalAccessTokenSecret);
        sb.append(',');
        sb.append("env");
        sb.append('=');
        sb.append(this.env == null ? "<null>" : this.env);
        sb.append(',');
        sb.append("verifySSL");
        sb.append('=');
        sb.append(this.verifySSL == null ? "<null>" : this.verifySSL);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.siteUrl == null ? 0 : this.siteUrl.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.siteName == null ? 0 : this.siteName.hashCode());
        result = result * 31 + (this.personalAccessTokenSecret == null ? 0 : this.personalAccessTokenSecret.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.env == null ? 0 : this.env.hashCode());
        result = result * 31 + (this.personalAccessTokenName == null ? 0 : this.personalAccessTokenName.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = result * 31 + (this.verifySSL == null ? 0 : this.verifySSL.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableauConnection)) {
            return false;
        }
        TableauConnection rhs = (TableauConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.siteUrl == rhs.siteUrl || this.siteUrl != null && this.siteUrl.equals(rhs.siteUrl)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.siteName == rhs.siteName || this.siteName != null && this.siteName.equals(rhs.siteName)) && (this.personalAccessTokenSecret == rhs.personalAccessTokenSecret || this.personalAccessTokenSecret != null && this.personalAccessTokenSecret.equals(rhs.personalAccessTokenSecret)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.env == rhs.env || this.env != null && this.env.equals(rhs.env)) && (this.personalAccessTokenName == rhs.personalAccessTokenName || this.personalAccessTokenName != null && this.personalAccessTokenName.equals(rhs.personalAccessTokenName)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.apiVersion == rhs.apiVersion || this.apiVersion != null && this.apiVersion.equals(rhs.apiVersion)) && (this.verifySSL == rhs.verifySSL || this.verifySSL != null && this.verifySSL.equals((Object)rhs.verifySSL)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum TableauType {
        TABLEAU("Tableau");

        private final String value;
        private static final Map<String, TableauType> CONSTANTS;

        private TableauType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TableauType fromValue(String value) {
            TableauType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TableauType>();
            for (TableauType c : TableauType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

