/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "secretToken", "accessToken", "apiHost", "sandboxDomain", "databaseName", "supportsMetadataExtraction"})
public class DomoDatabaseConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value=" service type")
    private DomoDatabaseType type = DomoDatabaseType.fromValue("DomoDatabase");
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Client ID for DOMO")
    @NotNull
    private String clientId;
    @JsonProperty(value="secretToken")
    @JsonPropertyDescription(value="Secret Token to connect DOMO")
    @PasswordField
    @NotNull
    private String secretToken;
    @JsonProperty(value="accessToken")
    @JsonPropertyDescription(value="Access token to connect to DOMO")
    private String accessToken;
    @JsonProperty(value="apiHost")
    @JsonPropertyDescription(value="API Host to connect to DOMO instance")
    @ExposedField
    private String apiHost = "api.domo.com";
    @JsonProperty(value="sandboxDomain")
    @JsonPropertyDescription(value="Connect to Sandbox Domain")
    @NotNull
    private URI sandboxDomain;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public DomoDatabaseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DomoDatabaseType type) {
        this.type = type;
    }

    public DomoDatabaseConnection withType(DomoDatabaseType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DomoDatabaseConnection withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="secretToken")
    @PasswordField
    public String getSecretToken() {
        return this.secretToken;
    }

    @JsonProperty(value="secretToken")
    @PasswordField
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public DomoDatabaseConnection withSecretToken(String secretToken) {
        this.secretToken = secretToken;
        return this;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="accessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DomoDatabaseConnection withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @JsonProperty(value="apiHost")
    @ExposedField
    public String getApiHost() {
        return this.apiHost;
    }

    @JsonProperty(value="apiHost")
    @ExposedField
    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public DomoDatabaseConnection withApiHost(String apiHost) {
        this.apiHost = apiHost;
        return this;
    }

    @JsonProperty(value="sandboxDomain")
    public URI getSandboxDomain() {
        return this.sandboxDomain;
    }

    @JsonProperty(value="sandboxDomain")
    public void setSandboxDomain(URI sandboxDomain) {
        this.sandboxDomain = sandboxDomain;
    }

    public DomoDatabaseConnection withSandboxDomain(URI sandboxDomain) {
        this.sandboxDomain = sandboxDomain;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public DomoDatabaseConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DomoDatabaseConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DomoDatabaseConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("secretToken");
        sb.append('=');
        sb.append(this.secretToken == null ? "<null>" : this.secretToken);
        sb.append(',');
        sb.append("accessToken");
        sb.append('=');
        sb.append(this.accessToken == null ? "<null>" : this.accessToken);
        sb.append(',');
        sb.append("apiHost");
        sb.append('=');
        sb.append(this.apiHost == null ? "<null>" : this.apiHost);
        sb.append(',');
        sb.append("sandboxDomain");
        sb.append('=');
        sb.append(this.sandboxDomain == null ? "<null>" : this.sandboxDomain);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sandboxDomain == null ? 0 : this.sandboxDomain.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.secretToken == null ? 0 : this.secretToken.hashCode());
        result = result * 31 + (this.apiHost == null ? 0 : this.apiHost.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DomoDatabaseConnection)) {
            return false;
        }
        DomoDatabaseConnection rhs = (DomoDatabaseConnection)other;
        return (this.sandboxDomain == rhs.sandboxDomain || this.sandboxDomain != null && this.sandboxDomain.equals(rhs.sandboxDomain)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.secretToken == rhs.secretToken || this.secretToken != null && this.secretToken.equals(rhs.secretToken)) && (this.apiHost == rhs.apiHost || this.apiHost != null && this.apiHost.equals(rhs.apiHost)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.accessToken == rhs.accessToken || this.accessToken != null && this.accessToken.equals(rhs.accessToken));
    }

    public static enum DomoDatabaseType {
        DOMO_DATABASE("DomoDatabase");

        private final String value;
        private static final Map<String, DomoDatabaseType> CONSTANTS;

        private DomoDatabaseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DomoDatabaseType fromValue(String value) {
            DomoDatabaseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DomoDatabaseType>();
            for (DomoDatabaseType c : DomoDatabaseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

