/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.OracleConnectionType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "hostPort", "oracleConnectionType", "instantClientDirectory", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsQueryComment"})
public class OracleConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private OracleType type = OracleType.fromValue("Oracle");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private OracleScheme scheme = OracleScheme.fromValue("oracle+cx_oracle");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Oracle. This user should have privileges to read all the metadata in Oracle.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Oracle.")
    @PasswordField
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Oracle service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="oracleConnectionType")
    @JsonPropertyDescription(value="Connect with oracle by either passing service name or database schema name.")
    @Valid
    @NotNull
    private OracleConnectionType oracleConnectionType;
    @JsonProperty(value="instantClientDirectory")
    @JsonPropertyDescription(value="This directory will be used to set the LD_LIBRARY_PATH env variable. It is required if you need to enable thick connection mode. By default, we bring instant client 19 and point to /instantclient.")
    private String instantClientDirectory = "/instantclient";
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;

    @JsonProperty(value="type")
    public OracleType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(OracleType type) {
        this.type = type;
    }

    public OracleConnection withType(OracleType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public OracleScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(OracleScheme scheme) {
        this.scheme = scheme;
    }

    public OracleConnection withScheme(OracleScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public OracleConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public OracleConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public OracleConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="oracleConnectionType")
    public OracleConnectionType getOracleConnectionType() {
        return this.oracleConnectionType;
    }

    @JsonProperty(value="oracleConnectionType")
    public void setOracleConnectionType(OracleConnectionType oracleConnectionType) {
        this.oracleConnectionType = oracleConnectionType;
    }

    public OracleConnection withOracleConnectionType(OracleConnectionType oracleConnectionType) {
        this.oracleConnectionType = oracleConnectionType;
        return this;
    }

    @JsonProperty(value="instantClientDirectory")
    public String getInstantClientDirectory() {
        return this.instantClientDirectory;
    }

    @JsonProperty(value="instantClientDirectory")
    public void setInstantClientDirectory(String instantClientDirectory) {
        this.instantClientDirectory = instantClientDirectory;
    }

    public OracleConnection withInstantClientDirectory(String instantClientDirectory) {
        this.instantClientDirectory = instantClientDirectory;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public OracleConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public OracleConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public OracleConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public OracleConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public OracleConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public OracleConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OracleConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("oracleConnectionType");
        sb.append('=');
        sb.append(this.oracleConnectionType == null ? "<null>" : this.oracleConnectionType);
        sb.append(',');
        sb.append("instantClientDirectory");
        sb.append('=');
        sb.append(this.instantClientDirectory == null ? "<null>" : this.instantClientDirectory);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.instantClientDirectory == null ? 0 : this.instantClientDirectory.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.oracleConnectionType == null ? 0 : this.oracleConnectionType.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OracleConnection)) {
            return false;
        }
        OracleConnection rhs = (OracleConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.instantClientDirectory == rhs.instantClientDirectory || this.instantClientDirectory != null && this.instantClientDirectory.equals(rhs.instantClientDirectory)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.oracleConnectionType == rhs.oracleConnectionType || this.oracleConnectionType != null && this.oracleConnectionType.equals(rhs.oracleConnectionType)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum OracleType {
        ORACLE("Oracle");

        private final String value;
        private static final Map<String, OracleType> CONSTANTS;

        private OracleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OracleType fromValue(String value) {
            OracleType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OracleType>();
            for (OracleType c : OracleType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum OracleScheme {
        ORACLE_CX_ORACLE("oracle+cx_oracle");

        private final String value;
        private static final Map<String, OracleScheme> CONSTANTS;

        private OracleScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OracleScheme fromValue(String value) {
            OracleScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OracleScheme>();
            for (OracleScheme c : OracleScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

