/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "password", "hostPort", "databaseServiceName", "messagingServiceName", "entity_type", "connectionOptions", "connectionArguments", "supportsMetadataExtraction"})
public class AtlasConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private AtlasType type = AtlasType.fromValue("Atlas");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="username to connect  to the Atlas. This user should have privileges to read all the metadata in Atlas.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="password to connect  to the Atlas.")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Atlas service.")
    @ExposedField
    private URI hostPort;
    @JsonProperty(value="databaseServiceName")
    @JsonPropertyDescription(value="service type of the data source.")
    @Valid
    private List<String> databaseServiceName = new ArrayList<String>();
    @JsonProperty(value="messagingServiceName")
    @JsonPropertyDescription(value="service type of the messaging source")
    @Valid
    private List<String> messagingServiceName = new ArrayList<String>();
    @JsonProperty(value="entity_type")
    @JsonPropertyDescription(value="Name of the Entity Type available in Atlas.")
    @NotNull
    private String entityType;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public AtlasType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AtlasType type) {
        this.type = type;
    }

    public AtlasConnection withType(AtlasType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public AtlasConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public AtlasConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public AtlasConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="databaseServiceName")
    public List<String> getDatabaseServiceName() {
        return this.databaseServiceName;
    }

    @JsonProperty(value="databaseServiceName")
    public void setDatabaseServiceName(List<String> databaseServiceName) {
        this.databaseServiceName = databaseServiceName;
    }

    public AtlasConnection withDatabaseServiceName(List<String> databaseServiceName) {
        this.databaseServiceName = databaseServiceName;
        return this;
    }

    @JsonProperty(value="messagingServiceName")
    public List<String> getMessagingServiceName() {
        return this.messagingServiceName;
    }

    @JsonProperty(value="messagingServiceName")
    public void setMessagingServiceName(List<String> messagingServiceName) {
        this.messagingServiceName = messagingServiceName;
    }

    public AtlasConnection withMessagingServiceName(List<String> messagingServiceName) {
        this.messagingServiceName = messagingServiceName;
        return this;
    }

    @JsonProperty(value="entity_type")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entity_type")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public AtlasConnection withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public AtlasConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public AtlasConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AtlasConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AtlasConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("databaseServiceName");
        sb.append('=');
        sb.append(this.databaseServiceName == null ? "<null>" : this.databaseServiceName);
        sb.append(',');
        sb.append("messagingServiceName");
        sb.append('=');
        sb.append(this.messagingServiceName == null ? "<null>" : this.messagingServiceName);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.messagingServiceName == null ? 0 : this.messagingServiceName.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.databaseServiceName == null ? 0 : this.databaseServiceName.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AtlasConnection)) {
            return false;
        }
        AtlasConnection rhs = (AtlasConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.messagingServiceName == rhs.messagingServiceName || this.messagingServiceName != null && this.messagingServiceName.equals(rhs.messagingServiceName)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.databaseServiceName == rhs.databaseServiceName || this.databaseServiceName != null && this.databaseServiceName.equals(rhs.databaseServiceName)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments));
    }

    public static enum AtlasType {
        ATLAS("Atlas");

        private final String value;
        private static final Map<String, AtlasType> CONSTANTS;

        private AtlasType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AtlasType fromValue(String value) {
            AtlasType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AtlasType>();
            for (AtlasType c : AtlasType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

