/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.schema.security.ssl.VerifySSL;
import org.openmetadata.schema.services.connections.metadata.ElasticsSearch;
import org.openmetadata.schema.services.connections.metadata.ExtraHeaders;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clusterName", "type", "hostPort", "authProvider", "verifySSL", "sslConfig", "securityConfig", "secretsManagerProvider", "secretsManagerCredentials", "apiVersion", "includeTopics", "includeTables", "includeDashboards", "includePipelines", "includeMlModels", "includeUsers", "includeTeams", "includeGlossaryTerms", "includeTags", "includePolicy", "includeMessagingServices", "enableVersionValidation", "includeDatabaseServices", "includePipelineServices", "limitRecords", "forceEntityOverwriting", "elasticsSearch", "supportsDataInsightExtraction", "supportsElasticSearchReindexingExtraction", "extraHeaders"})
public class OpenMetadataConnection {
    @JsonProperty(value="clusterName")
    @JsonPropertyDescription(value="Cluster name to differentiate OpenMetadata Server instance")
    private String clusterName = "openmetadata";
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="OpenMetadata service type")
    private OpenmetadataType type = OpenmetadataType.fromValue("OpenMetadata");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api")
    @NotNull
    private String hostPort = "http://localhost:8585/api";
    @JsonProperty(value="authProvider")
    @JsonPropertyDescription(value="OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadata server.")
    private AuthProvider authProvider = AuthProvider.fromValue("no-auth");
    @JsonProperty(value="verifySSL")
    @JsonPropertyDescription(value="Client SSL verification. Make sure to configure the SSLConfig if enabled.")
    private VerifySSL verifySSL = VerifySSL.fromValue("no-ssl");
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    private Object sslConfig;
    @JsonProperty(value="securityConfig")
    @JsonPropertyDescription(value="OpenMetadata Client security configuration.")
    @MaskedField
    private Object securityConfig;
    @JsonProperty(value="secretsManagerProvider")
    @JsonPropertyDescription(value="OpenMetadata Secrets Manager Provider. Make sure to configure the same secrets manager providers as the ones configured on the OpenMetadata server.")
    private SecretsManagerProvider secretsManagerProvider = SecretsManagerProvider.fromValue("noop");
    @JsonProperty(value="secretsManagerCredentials")
    @JsonPropertyDescription(value="OpenMetadata Secrets Manager Client credentials")
    private Object secretsManagerCredentials;
    @JsonProperty(value="apiVersion")
    @JsonPropertyDescription(value="OpenMetadata server API version to use.")
    private String apiVersion = "v1";
    @JsonProperty(value="includeTopics")
    @JsonPropertyDescription(value="Include Topics for Indexing")
    private Boolean includeTopics = true;
    @JsonProperty(value="includeTables")
    @JsonPropertyDescription(value="Include Tables for Indexing")
    private Boolean includeTables = true;
    @JsonProperty(value="includeDashboards")
    @JsonPropertyDescription(value="Include Dashboards for Indexing")
    private Boolean includeDashboards = true;
    @JsonProperty(value="includePipelines")
    @JsonPropertyDescription(value="Include Pipelines for Indexing")
    private Boolean includePipelines = true;
    @JsonProperty(value="includeMlModels")
    @JsonPropertyDescription(value="Include MlModels for Indexing")
    private Boolean includeMlModels = true;
    @JsonProperty(value="includeUsers")
    @JsonPropertyDescription(value="Include Users for Indexing")
    private Boolean includeUsers = true;
    @JsonProperty(value="includeTeams")
    @JsonPropertyDescription(value="Include Teams for Indexing")
    private Boolean includeTeams = true;
    @JsonProperty(value="includeGlossaryTerms")
    @JsonPropertyDescription(value="Include Glossary Terms for Indexing")
    private Boolean includeGlossaryTerms = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Include Tags for Indexing")
    private Boolean includeTags = true;
    @JsonProperty(value="includePolicy")
    @JsonPropertyDescription(value="Include Tags for Policy")
    private Boolean includePolicy = true;
    @JsonProperty(value="includeMessagingServices")
    @JsonPropertyDescription(value="Include Messaging Services for Indexing")
    private Boolean includeMessagingServices = true;
    @JsonProperty(value="enableVersionValidation")
    @JsonPropertyDescription(value="Validate Openmetadata Server & Client Version.")
    private Boolean enableVersionValidation = true;
    @JsonProperty(value="includeDatabaseServices")
    @JsonPropertyDescription(value="Include Database Services for Indexing")
    private Boolean includeDatabaseServices = true;
    @JsonProperty(value="includePipelineServices")
    @JsonPropertyDescription(value="Include Pipeline Services for Indexing")
    private Boolean includePipelineServices = true;
    @JsonProperty(value="limitRecords")
    @JsonPropertyDescription(value="Limit the number of records for Indexing.")
    private Integer limitRecords = 1000;
    @JsonProperty(value="forceEntityOverwriting")
    @JsonPropertyDescription(value="Force the overwriting of any entity during the ingestion.")
    private Boolean forceEntityOverwriting = false;
    @JsonProperty(value="elasticsSearch")
    @JsonPropertyDescription(value="Configuration for Sink Component in the OpenMetadata Ingestion Framework.")
    @Valid
    private ElasticsSearch elasticsSearch;
    @JsonProperty(value="supportsDataInsightExtraction")
    @JsonPropertyDescription(value="Support Metadata To Elastic Search")
    private Boolean supportsDataInsightExtraction = true;
    @JsonProperty(value="supportsElasticSearchReindexingExtraction")
    @JsonPropertyDescription(value="Support Elastic Search Reindexing")
    private Boolean supportsElasticSearchReindexingExtraction = true;
    @JsonProperty(value="extraHeaders")
    @JsonPropertyDescription(value="Additional headers to be sent to the API endpoint.")
    @Valid
    private ExtraHeaders extraHeaders;

    @JsonProperty(value="clusterName")
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public OpenMetadataConnection withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @JsonProperty(value="type")
    public OpenmetadataType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(OpenmetadataType type) {
        this.type = type;
    }

    public OpenMetadataConnection withType(OpenmetadataType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public OpenMetadataConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="authProvider")
    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @JsonProperty(value="authProvider")
    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public OpenMetadataConnection withAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
        return this;
    }

    @JsonProperty(value="verifySSL")
    public VerifySSL getVerifySSL() {
        return this.verifySSL;
    }

    @JsonProperty(value="verifySSL")
    public void setVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
    }

    public OpenMetadataConnection withVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
        return this;
    }

    @JsonProperty(value="sslConfig")
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public OpenMetadataConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="securityConfig")
    @MaskedField
    public Object getSecurityConfig() {
        return this.securityConfig;
    }

    @JsonProperty(value="securityConfig")
    @MaskedField
    public void setSecurityConfig(Object securityConfig) {
        this.securityConfig = securityConfig;
    }

    public OpenMetadataConnection withSecurityConfig(Object securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    @JsonProperty(value="secretsManagerProvider")
    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }

    @JsonProperty(value="secretsManagerProvider")
    public void setSecretsManagerProvider(SecretsManagerProvider secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
    }

    public OpenMetadataConnection withSecretsManagerProvider(SecretsManagerProvider secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
        return this;
    }

    @JsonProperty(value="secretsManagerCredentials")
    public Object getSecretsManagerCredentials() {
        return this.secretsManagerCredentials;
    }

    @JsonProperty(value="secretsManagerCredentials")
    public void setSecretsManagerCredentials(Object secretsManagerCredentials) {
        this.secretsManagerCredentials = secretsManagerCredentials;
    }

    public OpenMetadataConnection withSecretsManagerCredentials(Object secretsManagerCredentials) {
        this.secretsManagerCredentials = secretsManagerCredentials;
        return this;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public OpenMetadataConnection withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @JsonProperty(value="includeTopics")
    public Boolean getIncludeTopics() {
        return this.includeTopics;
    }

    @JsonProperty(value="includeTopics")
    public void setIncludeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
    }

    public OpenMetadataConnection withIncludeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
        return this;
    }

    @JsonProperty(value="includeTables")
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public OpenMetadataConnection withIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @JsonProperty(value="includeDashboards")
    public Boolean getIncludeDashboards() {
        return this.includeDashboards;
    }

    @JsonProperty(value="includeDashboards")
    public void setIncludeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
    }

    public OpenMetadataConnection withIncludeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
        return this;
    }

    @JsonProperty(value="includePipelines")
    public Boolean getIncludePipelines() {
        return this.includePipelines;
    }

    @JsonProperty(value="includePipelines")
    public void setIncludePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
    }

    public OpenMetadataConnection withIncludePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
        return this;
    }

    @JsonProperty(value="includeMlModels")
    public Boolean getIncludeMlModels() {
        return this.includeMlModels;
    }

    @JsonProperty(value="includeMlModels")
    public void setIncludeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
    }

    public OpenMetadataConnection withIncludeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
        return this;
    }

    @JsonProperty(value="includeUsers")
    public Boolean getIncludeUsers() {
        return this.includeUsers;
    }

    @JsonProperty(value="includeUsers")
    public void setIncludeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
    }

    public OpenMetadataConnection withIncludeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
        return this;
    }

    @JsonProperty(value="includeTeams")
    public Boolean getIncludeTeams() {
        return this.includeTeams;
    }

    @JsonProperty(value="includeTeams")
    public void setIncludeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
    }

    public OpenMetadataConnection withIncludeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
        return this;
    }

    @JsonProperty(value="includeGlossaryTerms")
    public Boolean getIncludeGlossaryTerms() {
        return this.includeGlossaryTerms;
    }

    @JsonProperty(value="includeGlossaryTerms")
    public void setIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
    }

    public OpenMetadataConnection withIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public OpenMetadataConnection withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="includePolicy")
    public Boolean getIncludePolicy() {
        return this.includePolicy;
    }

    @JsonProperty(value="includePolicy")
    public void setIncludePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
    }

    public OpenMetadataConnection withIncludePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
        return this;
    }

    @JsonProperty(value="includeMessagingServices")
    public Boolean getIncludeMessagingServices() {
        return this.includeMessagingServices;
    }

    @JsonProperty(value="includeMessagingServices")
    public void setIncludeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
    }

    public OpenMetadataConnection withIncludeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
        return this;
    }

    @JsonProperty(value="enableVersionValidation")
    public Boolean getEnableVersionValidation() {
        return this.enableVersionValidation;
    }

    @JsonProperty(value="enableVersionValidation")
    public void setEnableVersionValidation(Boolean enableVersionValidation) {
        this.enableVersionValidation = enableVersionValidation;
    }

    public OpenMetadataConnection withEnableVersionValidation(Boolean enableVersionValidation) {
        this.enableVersionValidation = enableVersionValidation;
        return this;
    }

    @JsonProperty(value="includeDatabaseServices")
    public Boolean getIncludeDatabaseServices() {
        return this.includeDatabaseServices;
    }

    @JsonProperty(value="includeDatabaseServices")
    public void setIncludeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
    }

    public OpenMetadataConnection withIncludeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
        return this;
    }

    @JsonProperty(value="includePipelineServices")
    public Boolean getIncludePipelineServices() {
        return this.includePipelineServices;
    }

    @JsonProperty(value="includePipelineServices")
    public void setIncludePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
    }

    public OpenMetadataConnection withIncludePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
        return this;
    }

    @JsonProperty(value="limitRecords")
    public Integer getLimitRecords() {
        return this.limitRecords;
    }

    @JsonProperty(value="limitRecords")
    public void setLimitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
    }

    public OpenMetadataConnection withLimitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
        return this;
    }

    @JsonProperty(value="forceEntityOverwriting")
    public Boolean getForceEntityOverwriting() {
        return this.forceEntityOverwriting;
    }

    @JsonProperty(value="forceEntityOverwriting")
    public void setForceEntityOverwriting(Boolean forceEntityOverwriting) {
        this.forceEntityOverwriting = forceEntityOverwriting;
    }

    public OpenMetadataConnection withForceEntityOverwriting(Boolean forceEntityOverwriting) {
        this.forceEntityOverwriting = forceEntityOverwriting;
        return this;
    }

    @JsonProperty(value="elasticsSearch")
    public ElasticsSearch getElasticsSearch() {
        return this.elasticsSearch;
    }

    @JsonProperty(value="elasticsSearch")
    public void setElasticsSearch(ElasticsSearch elasticsSearch) {
        this.elasticsSearch = elasticsSearch;
    }

    public OpenMetadataConnection withElasticsSearch(ElasticsSearch elasticsSearch) {
        this.elasticsSearch = elasticsSearch;
        return this;
    }

    @JsonProperty(value="supportsDataInsightExtraction")
    public Boolean getSupportsDataInsightExtraction() {
        return this.supportsDataInsightExtraction;
    }

    @JsonProperty(value="supportsDataInsightExtraction")
    public void setSupportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
        this.supportsDataInsightExtraction = supportsDataInsightExtraction;
    }

    public OpenMetadataConnection withSupportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
        this.supportsDataInsightExtraction = supportsDataInsightExtraction;
        return this;
    }

    @JsonProperty(value="supportsElasticSearchReindexingExtraction")
    public Boolean getSupportsElasticSearchReindexingExtraction() {
        return this.supportsElasticSearchReindexingExtraction;
    }

    @JsonProperty(value="supportsElasticSearchReindexingExtraction")
    public void setSupportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
        this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
    }

    public OpenMetadataConnection withSupportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
        this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
        return this;
    }

    @JsonProperty(value="extraHeaders")
    public ExtraHeaders getExtraHeaders() {
        return this.extraHeaders;
    }

    @JsonProperty(value="extraHeaders")
    public void setExtraHeaders(ExtraHeaders extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public OpenMetadataConnection withExtraHeaders(ExtraHeaders extraHeaders) {
        this.extraHeaders = extraHeaders;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenMetadataConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clusterName");
        sb.append('=');
        sb.append(this.clusterName == null ? "<null>" : this.clusterName);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("authProvider");
        sb.append('=');
        sb.append(this.authProvider == null ? "<null>" : this.authProvider);
        sb.append(',');
        sb.append("verifySSL");
        sb.append('=');
        sb.append(this.verifySSL == null ? "<null>" : this.verifySSL);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("securityConfig");
        sb.append('=');
        sb.append(this.securityConfig == null ? "<null>" : this.securityConfig);
        sb.append(',');
        sb.append("secretsManagerProvider");
        sb.append('=');
        sb.append(this.secretsManagerProvider == null ? "<null>" : this.secretsManagerProvider);
        sb.append(',');
        sb.append("secretsManagerCredentials");
        sb.append('=');
        sb.append(this.secretsManagerCredentials == null ? "<null>" : this.secretsManagerCredentials);
        sb.append(',');
        sb.append("apiVersion");
        sb.append('=');
        sb.append(this.apiVersion == null ? "<null>" : this.apiVersion);
        sb.append(',');
        sb.append("includeTopics");
        sb.append('=');
        sb.append(this.includeTopics == null ? "<null>" : this.includeTopics);
        sb.append(',');
        sb.append("includeTables");
        sb.append('=');
        sb.append(this.includeTables == null ? "<null>" : this.includeTables);
        sb.append(',');
        sb.append("includeDashboards");
        sb.append('=');
        sb.append(this.includeDashboards == null ? "<null>" : this.includeDashboards);
        sb.append(',');
        sb.append("includePipelines");
        sb.append('=');
        sb.append(this.includePipelines == null ? "<null>" : this.includePipelines);
        sb.append(',');
        sb.append("includeMlModels");
        sb.append('=');
        sb.append(this.includeMlModels == null ? "<null>" : this.includeMlModels);
        sb.append(',');
        sb.append("includeUsers");
        sb.append('=');
        sb.append(this.includeUsers == null ? "<null>" : this.includeUsers);
        sb.append(',');
        sb.append("includeTeams");
        sb.append('=');
        sb.append(this.includeTeams == null ? "<null>" : this.includeTeams);
        sb.append(',');
        sb.append("includeGlossaryTerms");
        sb.append('=');
        sb.append(this.includeGlossaryTerms == null ? "<null>" : this.includeGlossaryTerms);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("includePolicy");
        sb.append('=');
        sb.append(this.includePolicy == null ? "<null>" : this.includePolicy);
        sb.append(',');
        sb.append("includeMessagingServices");
        sb.append('=');
        sb.append(this.includeMessagingServices == null ? "<null>" : this.includeMessagingServices);
        sb.append(',');
        sb.append("enableVersionValidation");
        sb.append('=');
        sb.append(this.enableVersionValidation == null ? "<null>" : this.enableVersionValidation);
        sb.append(',');
        sb.append("includeDatabaseServices");
        sb.append('=');
        sb.append(this.includeDatabaseServices == null ? "<null>" : this.includeDatabaseServices);
        sb.append(',');
        sb.append("includePipelineServices");
        sb.append('=');
        sb.append(this.includePipelineServices == null ? "<null>" : this.includePipelineServices);
        sb.append(',');
        sb.append("limitRecords");
        sb.append('=');
        sb.append(this.limitRecords == null ? "<null>" : this.limitRecords);
        sb.append(',');
        sb.append("forceEntityOverwriting");
        sb.append('=');
        sb.append(this.forceEntityOverwriting == null ? "<null>" : this.forceEntityOverwriting);
        sb.append(',');
        sb.append("elasticsSearch");
        sb.append('=');
        sb.append(this.elasticsSearch == null ? "<null>" : this.elasticsSearch);
        sb.append(',');
        sb.append("supportsDataInsightExtraction");
        sb.append('=');
        sb.append(this.supportsDataInsightExtraction == null ? "<null>" : this.supportsDataInsightExtraction);
        sb.append(',');
        sb.append("supportsElasticSearchReindexingExtraction");
        sb.append('=');
        sb.append(this.supportsElasticSearchReindexingExtraction == null ? "<null>" : this.supportsElasticSearchReindexingExtraction);
        sb.append(',');
        sb.append("extraHeaders");
        sb.append('=');
        sb.append(this.extraHeaders == null ? "<null>" : this.extraHeaders);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeTables == null ? 0 : this.includeTables.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.includeTeams == null ? 0 : this.includeTeams.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.elasticsSearch == null ? 0 : this.elasticsSearch.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.secretsManagerCredentials == null ? 0 : this.secretsManagerCredentials.hashCode());
        result = result * 31 + (this.includeDashboards == null ? 0 : this.includeDashboards.hashCode());
        result = result * 31 + (this.authProvider == null ? 0 : this.authProvider.hashCode());
        result = result * 31 + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = result * 31 + (this.includeTopics == null ? 0 : this.includeTopics.hashCode());
        result = result * 31 + (this.includePipelines == null ? 0 : this.includePipelines.hashCode());
        result = result * 31 + (this.includeMessagingServices == null ? 0 : this.includeMessagingServices.hashCode());
        result = result * 31 + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = result * 31 + (this.includePolicy == null ? 0 : this.includePolicy.hashCode());
        result = result * 31 + (this.includeDatabaseServices == null ? 0 : this.includeDatabaseServices.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.includeGlossaryTerms == null ? 0 : this.includeGlossaryTerms.hashCode());
        result = result * 31 + (this.limitRecords == null ? 0 : this.limitRecords.hashCode());
        result = result * 31 + (this.includeMlModels == null ? 0 : this.includeMlModels.hashCode());
        result = result * 31 + (this.extraHeaders == null ? 0 : this.extraHeaders.hashCode());
        result = result * 31 + (this.supportsDataInsightExtraction == null ? 0 : this.supportsDataInsightExtraction.hashCode());
        result = result * 31 + (this.includePipelineServices == null ? 0 : this.includePipelineServices.hashCode());
        result = result * 31 + (this.supportsElasticSearchReindexingExtraction == null ? 0 : this.supportsElasticSearchReindexingExtraction.hashCode());
        result = result * 31 + (this.securityConfig == null ? 0 : this.securityConfig.hashCode());
        result = result * 31 + (this.secretsManagerProvider == null ? 0 : this.secretsManagerProvider.hashCode());
        result = result * 31 + (this.forceEntityOverwriting == null ? 0 : this.forceEntityOverwriting.hashCode());
        result = result * 31 + (this.enableVersionValidation == null ? 0 : this.enableVersionValidation.hashCode());
        result = result * 31 + (this.verifySSL == null ? 0 : this.verifySSL.hashCode());
        result = result * 31 + (this.includeUsers == null ? 0 : this.includeUsers.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenMetadataConnection)) {
            return false;
        }
        OpenMetadataConnection rhs = (OpenMetadataConnection)other;
        return (this.includeTables == rhs.includeTables || this.includeTables != null && this.includeTables.equals(rhs.includeTables)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.includeTeams == rhs.includeTeams || this.includeTeams != null && this.includeTeams.equals(rhs.includeTeams)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.elasticsSearch == rhs.elasticsSearch || this.elasticsSearch != null && this.elasticsSearch.equals(rhs.elasticsSearch)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.secretsManagerCredentials == rhs.secretsManagerCredentials || this.secretsManagerCredentials != null && this.secretsManagerCredentials.equals(rhs.secretsManagerCredentials)) && (this.includeDashboards == rhs.includeDashboards || this.includeDashboards != null && this.includeDashboards.equals(rhs.includeDashboards)) && (this.authProvider == rhs.authProvider || this.authProvider != null && this.authProvider.equals((Object)rhs.authProvider)) && (this.apiVersion == rhs.apiVersion || this.apiVersion != null && this.apiVersion.equals(rhs.apiVersion)) && (this.includeTopics == rhs.includeTopics || this.includeTopics != null && this.includeTopics.equals(rhs.includeTopics)) && (this.includePipelines == rhs.includePipelines || this.includePipelines != null && this.includePipelines.equals(rhs.includePipelines)) && (this.includeMessagingServices == rhs.includeMessagingServices || this.includeMessagingServices != null && this.includeMessagingServices.equals(rhs.includeMessagingServices)) && (this.clusterName == rhs.clusterName || this.clusterName != null && this.clusterName.equals(rhs.clusterName)) && (this.includePolicy == rhs.includePolicy || this.includePolicy != null && this.includePolicy.equals(rhs.includePolicy)) && (this.includeDatabaseServices == rhs.includeDatabaseServices || this.includeDatabaseServices != null && this.includeDatabaseServices.equals(rhs.includeDatabaseServices)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.includeGlossaryTerms == rhs.includeGlossaryTerms || this.includeGlossaryTerms != null && this.includeGlossaryTerms.equals(rhs.includeGlossaryTerms)) && (this.limitRecords == rhs.limitRecords || this.limitRecords != null && this.limitRecords.equals(rhs.limitRecords)) && (this.includeMlModels == rhs.includeMlModels || this.includeMlModels != null && this.includeMlModels.equals(rhs.includeMlModels)) && (this.extraHeaders == rhs.extraHeaders || this.extraHeaders != null && this.extraHeaders.equals(rhs.extraHeaders)) && (this.supportsDataInsightExtraction == rhs.supportsDataInsightExtraction || this.supportsDataInsightExtraction != null && this.supportsDataInsightExtraction.equals(rhs.supportsDataInsightExtraction)) && (this.includePipelineServices == rhs.includePipelineServices || this.includePipelineServices != null && this.includePipelineServices.equals(rhs.includePipelineServices)) && (this.supportsElasticSearchReindexingExtraction == rhs.supportsElasticSearchReindexingExtraction || this.supportsElasticSearchReindexingExtraction != null && this.supportsElasticSearchReindexingExtraction.equals(rhs.supportsElasticSearchReindexingExtraction)) && (this.securityConfig == rhs.securityConfig || this.securityConfig != null && this.securityConfig.equals(rhs.securityConfig)) && (this.secretsManagerProvider == rhs.secretsManagerProvider || this.secretsManagerProvider != null && this.secretsManagerProvider.equals((Object)rhs.secretsManagerProvider)) && (this.forceEntityOverwriting == rhs.forceEntityOverwriting || this.forceEntityOverwriting != null && this.forceEntityOverwriting.equals(rhs.forceEntityOverwriting)) && (this.enableVersionValidation == rhs.enableVersionValidation || this.enableVersionValidation != null && this.enableVersionValidation.equals(rhs.enableVersionValidation)) && (this.verifySSL == rhs.verifySSL || this.verifySSL != null && this.verifySSL.equals((Object)rhs.verifySSL)) && (this.includeUsers == rhs.includeUsers || this.includeUsers != null && this.includeUsers.equals(rhs.includeUsers));
    }

    public static enum OpenmetadataType {
        OPEN_METADATA("OpenMetadata");

        private final String value;
        private static final Map<String, OpenmetadataType> CONSTANTS;

        private OpenmetadataType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OpenmetadataType fromValue(String value) {
            OpenmetadataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OpenmetadataType>();
            for (OpenmetadataType c : OpenmetadataType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AuthProvider {
        NO_AUTH("no-auth"),
        AZURE("azure"),
        GOOGLE("google"),
        OKTA("okta"),
        AUTH_0("auth0"),
        CUSTOM_OIDC("custom-oidc"),
        OPENMETADATA("openmetadata");

        private final String value;
        private static final Map<String, AuthProvider> CONSTANTS;

        private AuthProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AuthProvider fromValue(String value) {
            AuthProvider constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AuthProvider>();
            for (AuthProvider c : AuthProvider.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

