/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "apiKey", "hostPort", "apiSecret", "limit", "supportsMetadataExtraction"})
public class FivetranConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private FivetranType type = FivetranType.fromValue("Fivetran");
    @JsonProperty(value="apiKey")
    @JsonPropertyDescription(value="Fivetran API Secret.")
    @NotNull
    private String apiKey;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Pipeline Service Management/UI URI.")
    @ExposedField
    private URI hostPort = URI.create("https://api.fivetran.com");
    @JsonProperty(value="apiSecret")
    @JsonPropertyDescription(value="Fivetran API Secret.")
    @PasswordField
    @NotNull
    private String apiSecret;
    @JsonProperty(value="limit")
    @JsonPropertyDescription(value="Fivetran API Limit For Pagination.")
    private Integer limit = 1000;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public FivetranType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(FivetranType type) {
        this.type = type;
    }

    public FivetranConnection withType(FivetranType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="apiKey")
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public FivetranConnection withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public FivetranConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="apiSecret")
    @PasswordField
    public String getApiSecret() {
        return this.apiSecret;
    }

    @JsonProperty(value="apiSecret")
    @PasswordField
    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public FivetranConnection withApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public FivetranConnection withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public FivetranConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FivetranConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("apiKey");
        sb.append('=');
        sb.append(this.apiKey == null ? "<null>" : this.apiKey);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("apiSecret");
        sb.append('=');
        sb.append(this.apiSecret == null ? "<null>" : this.apiSecret);
        sb.append(',');
        sb.append("limit");
        sb.append('=');
        sb.append(this.limit == null ? "<null>" : this.limit);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.apiKey == null ? 0 : this.apiKey.hashCode());
        result = result * 31 + (this.limit == null ? 0 : this.limit.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.apiSecret == null ? 0 : this.apiSecret.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FivetranConnection)) {
            return false;
        }
        FivetranConnection rhs = (FivetranConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.apiKey == rhs.apiKey || this.apiKey != null && this.apiKey.equals(rhs.apiKey)) && (this.limit == rhs.limit || this.limit != null && this.limit.equals(rhs.limit)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.apiSecret == rhs.apiSecret || this.apiSecret != null && this.apiSecret.equals(rhs.apiSecret)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum FivetranType {
        FIVETRAN("Fivetran");

        private final String value;
        private static final Map<String, FivetranType> CONSTANTS;

        private FivetranType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FivetranType fromValue(String value) {
            FivetranType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FivetranType>();
            for (FivetranType c : FivetranType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

