/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ChartType {
    Line("Line"),
    Table("Table"),
    Bar("Bar"),
    Area("Area"),
    Pie("Pie"),
    Histogram("Histogram"),
    Scatter("Scatter"),
    Text("Text"),
    BoxPlot("BoxPlot"),
    Other("Other");

    private final String value;
    private static final Map<String, ChartType> CONSTANTS;

    private ChartType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ChartType fromValue(String value) {
        ChartType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ChartType>();
        for (ChartType c : ChartType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

