/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ColumnDataType {
    NUMBER("NUMBER"),
    TINYINT("TINYINT"),
    SMALLINT("SMALLINT"),
    INT("INT"),
    BIGINT("BIGINT"),
    BYTEINT("BYTEINT"),
    BYTES("BYTES"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    NUMERIC("NUMERIC"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPZ("TIMESTAMPZ"),
    TIME("TIME"),
    DATE("DATE"),
    DATETIME("DATETIME"),
    INTERVAL("INTERVAL"),
    STRING("STRING"),
    MEDIUMTEXT("MEDIUMTEXT"),
    TEXT("TEXT"),
    CHAR("CHAR"),
    LONG("LONG"),
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    BINARY("BINARY"),
    VARBINARY("VARBINARY"),
    ARRAY("ARRAY"),
    BLOB("BLOB"),
    LONGBLOB("LONGBLOB"),
    MEDIUMBLOB("MEDIUMBLOB"),
    MAP("MAP"),
    STRUCT("STRUCT"),
    UNION("UNION"),
    SET("SET"),
    GEOGRAPHY("GEOGRAPHY"),
    ENUM("ENUM"),
    JSON("JSON"),
    UUID("UUID"),
    VARIANT("VARIANT"),
    GEOMETRY("GEOMETRY"),
    BYTEA("BYTEA"),
    AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
    ERROR("ERROR"),
    FIXED("FIXED"),
    RECORD("RECORD"),
    NULL("NULL"),
    SUPER("SUPER"),
    HLLSKETCH("HLLSKETCH"),
    PG_LSN("PG_LSN"),
    PG_SNAPSHOT("PG_SNAPSHOT"),
    TSQUERY("TSQUERY"),
    TXID_SNAPSHOT("TXID_SNAPSHOT"),
    XML("XML"),
    MACADDR("MACADDR"),
    TSVECTOR("TSVECTOR"),
    UNKNOWN("UNKNOWN"),
    CIDR("CIDR"),
    INET("INET"),
    CLOB("CLOB"),
    ROWID("ROWID"),
    LOWCARDINALITY("LOWCARDINALITY"),
    YEAR("YEAR"),
    POINT("POINT"),
    POLYGON("POLYGON");

    private final String value;
    private static final Map<String, ColumnDataType> CONSTANTS;

    private ColumnDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ColumnDataType fromValue(String value) {
        ColumnDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ColumnDataType>();
        for (ColumnDataType c : ColumnDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

