/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DataInsightChartDataType {
    NUMBER("NUMBER"),
    INT("INT"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    TIMESTAMP("TIMESTAMP"),
    TIME("TIME"),
    DATE("DATE"),
    DATETIME("DATETIME"),
    ARRAY("ARRAY"),
    MAP("MAP"),
    SET("SET"),
    STRING("STRING"),
    BOOLEAN("BOOLEAN"),
    PERCENTAGE("PERCENTAGE");

    private final String value;
    private static final Map<String, DataInsightChartDataType> CONSTANTS;

    private DataInsightChartDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DataInsightChartDataType fromValue(String value) {
        DataInsightChartDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DataInsightChartDataType>();
        for (DataInsightChartDataType c : DataInsightChartDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

