/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"modelType", "description", "path", "rawSql", "sql", "upstream", "owner", "tags", "columns", "generatedAt"})
public class DataModel {
    @JsonProperty(value="modelType")
    @NotNull
    private ModelType modelType;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Path to sql definition file.")
    private String path;
    @JsonProperty(value="rawSql")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String rawSql;
    @JsonProperty(value="sql")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    @NotNull
    private String sql;
    @JsonProperty(value="upstream")
    @JsonPropertyDescription(value="Fully qualified name of Models/tables used for in `sql` for creating this table.")
    @Valid
    private List<String> upstream = new ArrayList<String>();
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this data model.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Columns from the schema defined during modeling. In case of DBT, the metadata here comes from `schema.yaml`.")
    @Valid
    private List<Column> columns = null;
    @JsonProperty(value="generatedAt")
    @JsonPropertyDescription(value="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'.")
    private Date generatedAt;

    @JsonProperty(value="modelType")
    public ModelType getModelType() {
        return this.modelType;
    }

    @JsonProperty(value="modelType")
    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public DataModel withModelType(ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataModel withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public DataModel withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="rawSql")
    public String getRawSql() {
        return this.rawSql;
    }

    @JsonProperty(value="rawSql")
    public void setRawSql(String rawSql) {
        this.rawSql = rawSql;
    }

    public DataModel withRawSql(String rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    public DataModel withSql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="upstream")
    public List<String> getUpstream() {
        return this.upstream;
    }

    @JsonProperty(value="upstream")
    public void setUpstream(List<String> upstream) {
        this.upstream = upstream;
    }

    public DataModel withUpstream(List<String> upstream) {
        this.upstream = upstream;
        return this;
    }

    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public DataModel withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public DataModel withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public DataModel withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="generatedAt")
    public Date getGeneratedAt() {
        return this.generatedAt;
    }

    @JsonProperty(value="generatedAt")
    public void setGeneratedAt(Date generatedAt) {
        this.generatedAt = generatedAt;
    }

    public DataModel withGeneratedAt(Date generatedAt) {
        this.generatedAt = generatedAt;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("modelType");
        sb.append('=');
        sb.append(this.modelType == null ? "<null>" : this.modelType);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(this.path == null ? "<null>" : this.path);
        sb.append(',');
        sb.append("rawSql");
        sb.append('=');
        sb.append(this.rawSql == null ? "<null>" : this.rawSql);
        sb.append(',');
        sb.append("sql");
        sb.append('=');
        sb.append(this.sql == null ? "<null>" : this.sql);
        sb.append(',');
        sb.append("upstream");
        sb.append('=');
        sb.append(this.upstream == null ? "<null>" : this.upstream);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("generatedAt");
        sb.append('=');
        sb.append(this.generatedAt == null ? "<null>" : this.generatedAt);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.rawSql == null ? 0 : this.rawSql.hashCode());
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        result = result * 31 + (this.upstream == null ? 0 : this.upstream.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.generatedAt == null ? 0 : this.generatedAt.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.modelType == null ? 0 : this.modelType.hashCode());
        result = result * 31 + (this.sql == null ? 0 : this.sql.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataModel)) {
            return false;
        }
        DataModel rhs = (DataModel)other;
        return (this.rawSql == rhs.rawSql || this.rawSql != null && this.rawSql.equals(rhs.rawSql)) && (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.path == rhs.path || this.path != null && this.path.equals(rhs.path)) && (this.upstream == rhs.upstream || this.upstream != null && this.upstream.equals(rhs.upstream)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.generatedAt == rhs.generatedAt || this.generatedAt != null && this.generatedAt.equals(rhs.generatedAt)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.modelType == rhs.modelType || this.modelType != null && this.modelType.equals((Object)rhs.modelType)) && (this.sql == rhs.sql || this.sql != null && this.sql.equals(rhs.sql)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }

    public static enum ModelType {
        DBT("DBT");

        private final String value;
        private static final Map<String, ModelType> CONSTANTS;

        private ModelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ModelType fromValue(String value) {
            ModelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ModelType>();
            for (ModelType c : ModelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

