/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DmlOperationType {
    UPDATE("UPDATE"),
    INSERT("INSERT"),
    DELETE("DELETE");

    private final String value;
    private static final Map<String, DmlOperationType> CONSTANTS;

    private DmlOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DmlOperationType fromValue(String value) {
        DmlOperationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DmlOperationType>();
        for (DmlOperationType c : DmlOperationType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

