/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.LineageDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fromEntity", "toEntity", "description", "lineageDetails"})
public class Edge {
    @JsonProperty(value="fromEntity")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID fromEntity;
    @JsonProperty(value="toEntity")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID toEntity;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="lineageDetails")
    @JsonPropertyDescription(value="Lineage details including sqlQuery + pipeline + columnLineage.")
    @Valid
    private LineageDetails lineageDetails;

    @JsonProperty(value="fromEntity")
    public UUID getFromEntity() {
        return this.fromEntity;
    }

    @JsonProperty(value="fromEntity")
    public void setFromEntity(UUID fromEntity) {
        this.fromEntity = fromEntity;
    }

    public Edge withFromEntity(UUID fromEntity) {
        this.fromEntity = fromEntity;
        return this;
    }

    @JsonProperty(value="toEntity")
    public UUID getToEntity() {
        return this.toEntity;
    }

    @JsonProperty(value="toEntity")
    public void setToEntity(UUID toEntity) {
        this.toEntity = toEntity;
    }

    public Edge withToEntity(UUID toEntity) {
        this.toEntity = toEntity;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Edge withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="lineageDetails")
    public LineageDetails getLineageDetails() {
        return this.lineageDetails;
    }

    @JsonProperty(value="lineageDetails")
    public void setLineageDetails(LineageDetails lineageDetails) {
        this.lineageDetails = lineageDetails;
    }

    public Edge withLineageDetails(LineageDetails lineageDetails) {
        this.lineageDetails = lineageDetails;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Edge.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fromEntity");
        sb.append('=');
        sb.append(this.fromEntity == null ? "<null>" : this.fromEntity);
        sb.append(',');
        sb.append("toEntity");
        sb.append('=');
        sb.append(this.toEntity == null ? "<null>" : this.toEntity);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("lineageDetails");
        sb.append('=');
        sb.append(this.lineageDetails == null ? "<null>" : this.lineageDetails);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.toEntity == null ? 0 : this.toEntity.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fromEntity == null ? 0 : this.fromEntity.hashCode());
        result = result * 31 + (this.lineageDetails == null ? 0 : this.lineageDetails.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge rhs = (Edge)other;
        return (this.toEntity == rhs.toEntity || this.toEntity != null && this.toEntity.equals(rhs.toEntity)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fromEntity == rhs.fromEntity || this.fromEntity != null && this.fromEntity.equals(rhs.fromEntity)) && (this.lineageDetails == rhs.lineageDetails || this.lineageDetails != null && this.lineageDetails.equals(rhs.lineageDetails));
    }
}

