/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Relationship;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fromId", "fromFQN", "fromEntity", "toId", "toFQN", "toEntity", "relation", "relationshipType", "deleted"})
public class EntityRelationship {
    @JsonProperty(value="fromId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID fromId;
    @JsonProperty(value="fromFQN")
    @JsonPropertyDescription(value="Fully qualified name of the entity from which the relationship originates.")
    private String fromFQN;
    @JsonProperty(value="fromEntity")
    @JsonPropertyDescription(value="Type of the entity from which the relationship originates. Examples: `database`, `table`, `metrics` ...")
    @NotNull
    private String fromEntity;
    @JsonProperty(value="toId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID toId;
    @JsonProperty(value="toFQN")
    @JsonPropertyDescription(value="Fully qualified name of the entity towards which the relationship refers to.")
    private String toFQN;
    @JsonProperty(value="toEntity")
    @JsonPropertyDescription(value="Type of the entity towards which the relationship refers to. Examples: `database`, `table`, `metrics` ...")
    @NotNull
    private String toEntity;
    @JsonProperty(value="relation")
    @JsonPropertyDescription(value="Describes relationship between the two entities as an integer.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer relation;
    @JsonProperty(value="relationshipType")
    @JsonPropertyDescription(value="This enum captures all the relationships between Catalog entities. Note that the relationship from is a Strong entity and to is Weak entity when possible.")
    @NotNull
    private Relationship relationshipType;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="`true` indicates the relationship has been soft deleted.")
    private Boolean deleted = false;

    @JsonProperty(value="fromId")
    public UUID getFromId() {
        return this.fromId;
    }

    @JsonProperty(value="fromId")
    public void setFromId(UUID fromId) {
        this.fromId = fromId;
    }

    public EntityRelationship withFromId(UUID fromId) {
        this.fromId = fromId;
        return this;
    }

    @JsonProperty(value="fromFQN")
    public String getFromFQN() {
        return this.fromFQN;
    }

    @JsonProperty(value="fromFQN")
    public void setFromFQN(String fromFQN) {
        this.fromFQN = fromFQN;
    }

    public EntityRelationship withFromFQN(String fromFQN) {
        this.fromFQN = fromFQN;
        return this;
    }

    @JsonProperty(value="fromEntity")
    public String getFromEntity() {
        return this.fromEntity;
    }

    @JsonProperty(value="fromEntity")
    public void setFromEntity(String fromEntity) {
        this.fromEntity = fromEntity;
    }

    public EntityRelationship withFromEntity(String fromEntity) {
        this.fromEntity = fromEntity;
        return this;
    }

    @JsonProperty(value="toId")
    public UUID getToId() {
        return this.toId;
    }

    @JsonProperty(value="toId")
    public void setToId(UUID toId) {
        this.toId = toId;
    }

    public EntityRelationship withToId(UUID toId) {
        this.toId = toId;
        return this;
    }

    @JsonProperty(value="toFQN")
    public String getToFQN() {
        return this.toFQN;
    }

    @JsonProperty(value="toFQN")
    public void setToFQN(String toFQN) {
        this.toFQN = toFQN;
    }

    public EntityRelationship withToFQN(String toFQN) {
        this.toFQN = toFQN;
        return this;
    }

    @JsonProperty(value="toEntity")
    public String getToEntity() {
        return this.toEntity;
    }

    @JsonProperty(value="toEntity")
    public void setToEntity(String toEntity) {
        this.toEntity = toEntity;
    }

    public EntityRelationship withToEntity(String toEntity) {
        this.toEntity = toEntity;
        return this;
    }

    @JsonProperty(value="relation")
    public Integer getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    public void setRelation(Integer relation) {
        this.relation = relation;
    }

    public EntityRelationship withRelation(Integer relation) {
        this.relation = relation;
        return this;
    }

    @JsonProperty(value="relationshipType")
    public Relationship getRelationshipType() {
        return this.relationshipType;
    }

    @JsonProperty(value="relationshipType")
    public void setRelationshipType(Relationship relationshipType) {
        this.relationshipType = relationshipType;
    }

    public EntityRelationship withRelationshipType(Relationship relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public EntityRelationship withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntityRelationship.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fromId");
        sb.append('=');
        sb.append(this.fromId == null ? "<null>" : this.fromId);
        sb.append(',');
        sb.append("fromFQN");
        sb.append('=');
        sb.append(this.fromFQN == null ? "<null>" : this.fromFQN);
        sb.append(',');
        sb.append("fromEntity");
        sb.append('=');
        sb.append(this.fromEntity == null ? "<null>" : this.fromEntity);
        sb.append(',');
        sb.append("toId");
        sb.append('=');
        sb.append(this.toId == null ? "<null>" : this.toId);
        sb.append(',');
        sb.append("toFQN");
        sb.append('=');
        sb.append(this.toFQN == null ? "<null>" : this.toFQN);
        sb.append(',');
        sb.append("toEntity");
        sb.append('=');
        sb.append(this.toEntity == null ? "<null>" : this.toEntity);
        sb.append(',');
        sb.append("relation");
        sb.append('=');
        sb.append(this.relation == null ? "<null>" : this.relation);
        sb.append(',');
        sb.append("relationshipType");
        sb.append('=');
        sb.append(this.relationshipType == null ? "<null>" : this.relationshipType);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.toId == null ? 0 : this.toId.hashCode());
        result = result * 31 + (this.toEntity == null ? 0 : this.toEntity.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.fromEntity == null ? 0 : this.fromEntity.hashCode());
        result = result * 31 + (this.relationshipType == null ? 0 : this.relationshipType.hashCode());
        result = result * 31 + (this.fromFQN == null ? 0 : this.fromFQN.hashCode());
        result = result * 31 + (this.fromId == null ? 0 : this.fromId.hashCode());
        result = result * 31 + (this.toFQN == null ? 0 : this.toFQN.hashCode());
        result = result * 31 + (this.relation == null ? 0 : this.relation.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EntityRelationship)) {
            return false;
        }
        EntityRelationship rhs = (EntityRelationship)other;
        return (this.toId == rhs.toId || this.toId != null && this.toId.equals(rhs.toId)) && (this.toEntity == rhs.toEntity || this.toEntity != null && this.toEntity.equals(rhs.toEntity)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.fromEntity == rhs.fromEntity || this.fromEntity != null && this.fromEntity.equals(rhs.fromEntity)) && (this.relationshipType == rhs.relationshipType || this.relationshipType != null && this.relationshipType.equals((Object)rhs.relationshipType)) && (this.fromFQN == rhs.fromFQN || this.fromFQN != null && this.fromFQN.equals(rhs.fromFQN)) && (this.fromId == rhs.fromId || this.fromId != null && this.fromId.equals(rhs.fromId)) && (this.toFQN == rhs.toFQN || this.toFQN != null && this.toFQN.equals(rhs.toFQN)) && (this.relation == rhs.relation || this.relation != null && this.relation.equals(rhs.relation));
    }
}

