/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FieldDataType {
    RECORD("RECORD"),
    NULL("NULL"),
    BOOLEAN("BOOLEAN"),
    INT("INT"),
    LONG("LONG"),
    BYTES("BYTES"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPZ("TIMESTAMPZ"),
    TIME("TIME"),
    DATE("DATE"),
    STRING("STRING"),
    ARRAY("ARRAY"),
    MAP("MAP"),
    ENUM("ENUM"),
    UNION("UNION"),
    FIXED("FIXED"),
    ERROR("ERROR");

    private final String value;
    private static final Map<String, FieldDataType> CONSTANTS;

    private FieldDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FieldDataType fromValue(String value) {
        FieldDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FieldDataType>();
        for (FieldDataType c : FieldDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

