/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"before", "after", "total"})
public class Paging {
    @JsonProperty(value="before")
    @JsonPropertyDescription(value="Before cursor used for getting the previous page (see API pagination for details).")
    private String before;
    @JsonProperty(value="after")
    @JsonPropertyDescription(value="After cursor used for getting the next page (see API pagination for details).")
    private String after;
    @JsonProperty(value="total")
    @JsonPropertyDescription(value="Total number of entries available to page through.")
    @NotNull
    private Integer total;

    @JsonProperty(value="before")
    public String getBefore() {
        return this.before;
    }

    @JsonProperty(value="before")
    public void setBefore(String before) {
        this.before = before;
    }

    public Paging withBefore(String before) {
        this.before = before;
        return this;
    }

    @JsonProperty(value="after")
    public String getAfter() {
        return this.after;
    }

    @JsonProperty(value="after")
    public void setAfter(String after) {
        this.after = after;
    }

    public Paging withAfter(String after) {
        this.after = after;
        return this;
    }

    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public Paging withTotal(Integer total) {
        this.total = total;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Paging.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("before");
        sb.append('=');
        sb.append(this.before == null ? "<null>" : this.before);
        sb.append(',');
        sb.append("after");
        sb.append('=');
        sb.append(this.after == null ? "<null>" : this.after);
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(this.total == null ? "<null>" : this.total);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.total == null ? 0 : this.total.hashCode());
        result = result * 31 + (this.after == null ? 0 : this.after.hashCode());
        result = result * 31 + (this.before == null ? 0 : this.before.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Paging)) {
            return false;
        }
        Paging rhs = (Paging)other;
        return (this.total == rhs.total || this.total != null && this.total.equals(rhs.total)) && (this.after == rhs.after || this.after != null && this.after.equals(rhs.after)) && (this.before == rhs.before || this.before != null && this.before.equals(rhs.before));
    }
}

