/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SchemaType {
    Avro("Avro"),
    Protobuf("Protobuf"),
    JSON("JSON"),
    Other("Other"),
    None("None");

    private final String value;
    private static final Map<String, SchemaType> CONSTANTS;

    private SchemaType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SchemaType fromValue(String value) {
        SchemaType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SchemaType>();
        for (SchemaType c : SchemaType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

