/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum StorageServiceType {
    S3("S3"),
    GCS("GCS"),
    HDFS("HDFS"),
    ABFS("ABFS");

    private final String value;
    private static final Map<String, StorageServiceType> CONSTANTS;

    private StorageServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static StorageServiceType fromValue(String value) {
        StorageServiceType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, StorageServiceType>();
        for (StorageServiceType c : StorageServiceType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

