/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"columns", "intervalType", "interval"})
public class TablePartition {
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="List of column names corresponding to the partition.")
    @Valid
    private List<String> columns = new ArrayList<String>();
    @JsonProperty(value="intervalType")
    @JsonPropertyDescription(value="type of partition interval, example time-unit, integer-range")
    private IntervalType intervalType;
    @JsonProperty(value="interval")
    @JsonPropertyDescription(value="partition interval , example hourly, daily, monthly.")
    private String interval;

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public TablePartition withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="intervalType")
    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    @JsonProperty(value="intervalType")
    public void setIntervalType(IntervalType intervalType) {
        this.intervalType = intervalType;
    }

    public TablePartition withIntervalType(IntervalType intervalType) {
        this.intervalType = intervalType;
        return this;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public TablePartition withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TablePartition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("intervalType");
        sb.append('=');
        sb.append(this.intervalType == null ? "<null>" : this.intervalType);
        sb.append(',');
        sb.append("interval");
        sb.append('=');
        sb.append(this.interval == null ? "<null>" : this.interval);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.intervalType == null ? 0 : this.intervalType.hashCode());
        result = result * 31 + (this.interval == null ? 0 : this.interval.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TablePartition)) {
            return false;
        }
        TablePartition rhs = (TablePartition)other;
        return (this.intervalType == rhs.intervalType || this.intervalType != null && this.intervalType.equals((Object)rhs.intervalType)) && (this.interval == rhs.interval || this.interval != null && this.interval.equals(rhs.interval)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns));
    }

    public static enum IntervalType {
        TIME_UNIT("TIME-UNIT"),
        INTEGER_RANGE("INTEGER-RANGE"),
        INGESTION_TIME("INGESTION-TIME"),
        COLUMN_VALUE("COLUMN-VALUE"),
        OTHER("OTHER");

        private final String value;
        private static final Map<String, IntervalType> CONSTANTS;

        private IntervalType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IntervalType fromValue(String value) {
            IntervalType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, IntervalType>();
            for (IntervalType c : IntervalType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

