/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TableType {
    Regular("Regular"),
    External("External"),
    View("View"),
    SecureView("SecureView"),
    MaterializedView("MaterializedView"),
    Iceberg("Iceberg"),
    Local("Local"),
    Partitioned("Partitioned"),
    Foreign("Foreign");

    private final String value;
    private static final Map<String, TableType> CONSTANTS;

    private TableType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TableType fromValue(String value) {
        TableType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TableType>();
        for (TableType c : TableType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

