/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TestCaseParameterDataType {
    NUMBER("NUMBER"),
    INT("INT"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    TIMESTAMP("TIMESTAMP"),
    TIME("TIME"),
    DATE("DATE"),
    DATETIME("DATETIME"),
    ARRAY("ARRAY"),
    MAP("MAP"),
    SET("SET"),
    STRING("STRING"),
    BOOLEAN("BOOLEAN");

    private final String value;
    private static final Map<String, TestCaseParameterDataType> CONSTANTS;

    private TestCaseParameterDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TestCaseParameterDataType fromValue(String value) {
        TestCaseParameterDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TestCaseParameterDataType>();
        for (TestCaseParameterDataType c : TestCaseParameterDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

