/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"endpoint", "secretKey"})
public class Webhook {
    @JsonProperty(value="endpoint")
    @JsonPropertyDescription(value="Endpoint to receive the webhook events over POST requests.")
    @NotNull
    private URI endpoint;
    @JsonProperty(value="secretKey")
    @JsonPropertyDescription(value="Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.")
    private String secretKey;

    @JsonProperty(value="endpoint")
    public URI getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public Webhook withEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Webhook withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Webhook.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("endpoint");
        sb.append('=');
        sb.append(this.endpoint == null ? "<null>" : this.endpoint);
        sb.append(',');
        sb.append("secretKey");
        sb.append('=');
        sb.append(this.secretKey == null ? "<null>" : this.secretKey);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = result * 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Webhook)) {
            return false;
        }
        Webhook rhs = (Webhook)other;
        return (this.secretKey == rhs.secretKey || this.secretKey != null && this.secretKey.equals(rhs.secretKey)) && (this.endpoint == rhs.endpoint || this.endpoint != null && this.endpoint.equals(rhs.endpoint));
    }
}

