/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.empoa.simple.internal.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class PathItemImpl
implements PathItem {
    private String _ref;
    private Map<String, Object> _extensions;
    private String _summary;
    private String _description;
    private Operation _gET;
    private Operation _pUT;
    private Operation _pOST;
    private Operation _dELETE;
    private Operation _oPTIONS;
    private Operation _hEAD;
    private Operation _pATCH;
    private Operation _tRACE;
    private List<Server> _servers;
    private List<Parameter> _parameters;

    public String getRef() {
        return this._ref;
    }

    public void setRef(String ref) {
        this._ref = ref != null && !ref.contains("#") && !ref.contains("/") ? "#/components/pathItems/" + ref : ref;
    }

    public Map<String, Object> getExtensions() {
        if (this._extensions == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._extensions);
    }

    public void setExtensions(Map<String, Object> extensions) {
        if (extensions == null) {
            this._extensions = null;
        } else {
            this._extensions = new LinkedHashMap<String, Object>();
            this._extensions.putAll(extensions);
        }
    }

    public PathItem addExtension(String key, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null value for key '" + key + "' is not allowed");
        }
        if (this._extensions == null) {
            this._extensions = new LinkedHashMap<String, Object>();
        }
        this._extensions.put(key, object);
        return this;
    }

    public void removeExtension(String key) {
        if (this._extensions != null) {
            this._extensions.remove(key);
        }
    }

    public String getSummary() {
        return this._summary;
    }

    public void setSummary(String summary) {
        this._summary = summary;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Operation getGET() {
        return this._gET;
    }

    public void setGET(Operation gET) {
        this._gET = gET;
    }

    public Operation getPUT() {
        return this._pUT;
    }

    public void setPUT(Operation pUT) {
        this._pUT = pUT;
    }

    public Operation getPOST() {
        return this._pOST;
    }

    public void setPOST(Operation pOST) {
        this._pOST = pOST;
    }

    public Operation getDELETE() {
        return this._dELETE;
    }

    public void setDELETE(Operation dELETE) {
        this._dELETE = dELETE;
    }

    public Operation getOPTIONS() {
        return this._oPTIONS;
    }

    public void setOPTIONS(Operation oPTIONS) {
        this._oPTIONS = oPTIONS;
    }

    public Operation getHEAD() {
        return this._hEAD;
    }

    public void setHEAD(Operation hEAD) {
        this._hEAD = hEAD;
    }

    public Operation getPATCH() {
        return this._pATCH;
    }

    public void setPATCH(Operation pATCH) {
        this._pATCH = pATCH;
    }

    public Operation getTRACE() {
        return this._tRACE;
    }

    public void setTRACE(Operation tRACE) {
        this._tRACE = tRACE;
    }

    public Map<PathItem.HttpMethod, Operation> getOperations() {
        LinkedHashMap<PathItem.HttpMethod, Operation> map = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        if (this.getGET() != null) {
            map.put(PathItem.HttpMethod.GET, this.getGET());
        }
        if (this.getPUT() != null) {
            map.put(PathItem.HttpMethod.PUT, this.getPUT());
        }
        if (this.getPOST() != null) {
            map.put(PathItem.HttpMethod.POST, this.getPOST());
        }
        if (this.getDELETE() != null) {
            map.put(PathItem.HttpMethod.DELETE, this.getDELETE());
        }
        if (this.getOPTIONS() != null) {
            map.put(PathItem.HttpMethod.OPTIONS, this.getOPTIONS());
        }
        if (this.getHEAD() != null) {
            map.put(PathItem.HttpMethod.HEAD, this.getHEAD());
        }
        if (this.getPATCH() != null) {
            map.put(PathItem.HttpMethod.PATCH, this.getPATCH());
        }
        if (this.getTRACE() != null) {
            map.put(PathItem.HttpMethod.TRACE, this.getTRACE());
        }
        return Collections.unmodifiableMap(map);
    }

    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("parameter httpMethod can not be null");
        }
        switch (httpMethod) {
            case DELETE: {
                this.setDELETE(operation);
                break;
            }
            case GET: {
                this.setGET(operation);
                break;
            }
            case HEAD: {
                this.setHEAD(operation);
                break;
            }
            case OPTIONS: {
                this.setOPTIONS(operation);
                break;
            }
            case PATCH: {
                this.setPATCH(operation);
                break;
            }
            case POST: {
                this.setPOST(operation);
                break;
            }
            case PUT: {
                this.setPUT(operation);
                break;
            }
            case TRACE: {
                this.setTRACE(operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected httpMethod: " + httpMethod);
            }
        }
    }

    public List<Server> getServers() {
        if (this._servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this._servers);
    }

    public void setServers(List<Server> servers) {
        if (servers == null) {
            this._servers = null;
        } else {
            this._servers = new ArrayList<Server>();
            this._servers.addAll(servers);
        }
    }

    public PathItem addServer(Server server) {
        if (this._servers == null) {
            this._servers = new ArrayList<Server>();
        }
        this._servers.add(server);
        return this;
    }

    public void removeServer(Server server) {
        if (this._servers != null) {
            this._servers.remove(server);
        }
    }

    public List<Parameter> getParameters() {
        if (this._parameters == null) {
            return null;
        }
        return Collections.unmodifiableList(this._parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == null) {
            this._parameters = null;
        } else {
            this._parameters = new ArrayList<Parameter>();
            this._parameters.addAll(parameters);
        }
    }

    public PathItem addParameter(Parameter parameter) {
        if (this._parameters == null) {
            this._parameters = new ArrayList<Parameter>();
        }
        this._parameters.add(parameter);
        return this;
    }

    public void removeParameter(Parameter parameter) {
        if (this._parameters != null) {
            this._parameters.remove(parameter);
        }
    }
}

