/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.generator.gradle.plugin.tasks;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R0\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@GX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/openapitools/generator/gradle/plugin/tasks/ValidateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "value", "", "input", "input$annotations", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "inputSpec", "Lorg/gradle/api/provider/Property;", "getInputSpec", "()Lorg/gradle/api/provider/Property;", "setInputSpec", "(Lorg/gradle/api/provider/Property;)V", "doWork", "", "openapi-generator-gradle-plugin"})
public class ValidateTask
extends DefaultTask {
    @NotNull
    private Property<String> inputSpec;
    @Nullable
    private String input;

    @Internal
    @NotNull
    public final Property<String> getInputSpec() {
        return this.inputSpec;
    }

    public final void setInputSpec(@NotNull Property<String> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"<set-?>");
        this.inputSpec = property;
    }

    public static /* synthetic */ void input$annotations() {
    }

    @Internal
    @Nullable
    public final String getInput() {
        return this.input;
    }

    @Option(option="input", description="The input specification.")
    public final void setInput(@Nullable String value) {
        this.inputSpec.set((Object)value);
    }

    @TaskAction
    public final void doWork() {
        SwaggerParseResult result;
        Object object = this.inputSpec.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputSpec.get()");
        String spec = (String)object;
        this.getLogger().quiet("Validating spec " + spec);
        SwaggerParseResult swaggerParseResult = result = new OpenAPIParser().readLocation(spec, null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)swaggerParseResult, (String)"result");
        List list = swaggerParseResult.getMessages();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.messages");
        Set messages = CollectionsKt.toSet((Iterable)list);
        StyledTextOutput out = ((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create("openapi");
        Collection collection = messages;
        if (!collection.isEmpty()) {
            out.withStyle(StyledTextOutput.Style.Error);
            out.println((Object)"\nSpec is invalid.\nIssues:\n");
            Iterable $receiver$iv = messages;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                out.withStyle(StyledTextOutput.Style.Error);
                out.println((Object)('\t' + it + '\n'));
            }
            throw (Throwable)new GradleException("Validation failed.");
        }
        out.withStyle(StyledTextOutput.Style.Success);
        out.println((Object)"Spec is valid.");
    }

    public ValidateTask() {
        Property property;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $receiver$iv = objectFactory;
        ValidateTask validateTask = this;
        boolean $i$f$property = false;
        Property property2 = $receiver$iv.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"property(T::class.java)");
        validateTask.inputSpec = property = property2;
    }
}

