/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.generator.gradle.plugin.tasks;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openapitools.codegen.validation.Invalid;
import org.openapitools.codegen.validation.ValidationResult;
import org.openapitools.codegen.validations.oas.OpenApiEvaluator;
import org.openapitools.codegen.validations.oas.RuleConfiguration;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R0\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@GX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/openapitools/generator/gradle/plugin/tasks/ValidateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "value", "", "input", "input$annotations", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "inputSpec", "Lorg/gradle/api/provider/Property;", "getInputSpec", "()Lorg/gradle/api/provider/Property;", "recommend", "", "getRecommend", "doWork", "", "openapi-generator-gradle-plugin"})
public class ValidateTask
extends DefaultTask {
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Property<String> inputSpec;
    @Optional
    @Input
    @NotNull
    private final Property<Boolean> recommend;
    @Nullable
    private String input;

    @InputFile
    @NotNull
    public final Property<String> getInputSpec() {
        return this.inputSpec;
    }

    @NotNull
    public final Property<Boolean> getRecommend() {
        return this.recommend;
    }

    public static /* synthetic */ void input$annotations() {
    }

    @Internal
    @Nullable
    public final String getInput() {
        return this.input;
    }

    @Option(option="input", description="The input specification.")
    public final void setInput(@Nullable String value) {
        this.inputSpec.set((Object)value);
    }

    @TaskAction
    public final void doWork() {
        StyledTextOutput out;
        Logger logger;
        block8: {
            Object it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            ValidationResult validationResult;
            Set messages;
            block7: {
                SwaggerParseResult result;
                logger = Logging.getLogger(((Object)((Object)this)).getClass());
                Object object = this.inputSpec.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputSpec.get()");
                String spec = (String)object;
                Object object2 = this.recommend.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"recommend.get()");
                boolean recommendations = (Boolean)object2;
                logger.quiet("Validating spec " + spec);
                ParseOptions options = new ParseOptions();
                options.setResolve(true);
                SwaggerParseResult swaggerParseResult = result = new OpenAPIParser().readLocation(spec, null, options);
                Intrinsics.checkExpressionValueIsNotNull((Object)swaggerParseResult, (String)"result");
                List list = swaggerParseResult.getMessages();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.messages");
                messages = CollectionsKt.toSet((Iterable)list);
                out = ((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create("openapi");
                RuleConfiguration ruleConfiguration = new RuleConfiguration();
                ruleConfiguration.setEnableRecommendations(recommendations);
                OpenApiEvaluator evaluator = new OpenApiEvaluator(ruleConfiguration);
                ValidationResult validationResult2 = validationResult = evaluator.validate(result.getOpenAPI());
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult2, (String)"validationResult");
                List list2 = validationResult2.getWarnings();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"validationResult.warnings");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    out.withStyle(StyledTextOutput.Style.Info);
                    out.println((Object)"\nSpec has issues or recommendations.\nIssues:\n");
                    List list3 = validationResult.getWarnings();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"validationResult.warnings");
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Invalid)element$iv;
                        boolean bl2 = false;
                        out.withStyle(StyledTextOutput.Style.Info);
                        StringBuilder stringBuilder = new StringBuilder().append('\t');
                        Object object3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                        out.println((Object)stringBuilder.append(object3.getMessage()).append('\n').toString());
                        logger.debug("WARNING: " + it.getMessage() + '|' + it.getDetails());
                    }
                }
                $this$forEach$iv = messages;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) break block7;
                List list4 = validationResult.getErrors();
                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"validationResult.errors");
                $this$forEach$iv = list4;
                $i$f$forEach = false;
                if (!(!$this$forEach$iv.isEmpty())) break block8;
            }
            out.withStyle(StyledTextOutput.Style.Error);
            out.println((Object)"\nSpec is invalid.\nIssues:\n");
            $this$forEach$iv = messages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                out.withStyle(StyledTextOutput.Style.Error);
                out.println((Object)('\t' + (String)it + '\n'));
                logger.debug("ERROR: " + (String)it);
            }
            List list = validationResult.getErrors();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"validationResult.errors");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Invalid)element$iv;
                boolean bl = false;
                out.withStyle(StyledTextOutput.Style.Error);
                StringBuilder stringBuilder = new StringBuilder().append('\t');
                Object object = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                out.println((Object)stringBuilder.append(object.getMessage()).append('\n').toString());
                logger.debug("ERROR: " + it.getMessage() + '|' + it.getDetails());
            }
            throw (Throwable)new GradleException("Validation failed.");
        }
        out.withStyle(StyledTextOutput.Style.Success);
        logger.debug("No error validations from swagger-parser or internal validations.");
        out.println((Object)"Spec is valid.");
    }

    public ValidateTask() {
        Property property;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        ValidateTask validateTask = this;
        boolean $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"property(T::class.java)");
        validateTask.inputSpec = property = property2;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ObjectFactory objectFactory2 = project2.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        validateTask = this;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"property(T::class.java)");
        validateTask.recommend = property = property3;
    }
}

