/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoServerCodegen
extends AbstractGoCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoServerCodegen.class);
    protected String packageVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "openapi-server";
    protected String sourceFolder = "go";

    public GoServerCodegen() {
        this.outputFolder = "generated-code/go";
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue(this.sourceFolder));
        CliOption optServerPort = new CliOption("serverPort", "The network port the generated server binds to");
        optServerPort.setType("int");
        optServerPort.defaultValue(Integer.toString(this.serverPort));
        this.cliOptions.add(optServerPort);
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.apiTemplateFiles.put("service.mustache", "_service.go");
        this.templateDir = "go-server";
        this.embeddedTemplateDir = "go-server";
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("serverPort") && this.additionalProperties.get("serverPort") instanceof Integer) {
            this.setServerPort((Integer)this.additionalProperties.get("serverPort"));
        } else {
            this.additionalProperties.put("serverPort", this.serverPort);
        }
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.sourceFolder, "routers.go"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", this.sourceFolder, "logger.go"));
        this.supportingFiles.add(new SupportingFile("api.mustache", this.sourceFolder, "api.go"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        List imports = (List)objs.get("imports");
        if (imports == null) {
            return objs;
        }
        imports.clear();
        boolean addedOptionalImport = false;
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        boolean addedReflectImport = false;
        for (CodegenOperation operation : operations) {
            for (CodegenParameter param : operation.allParams) {
                if (!addedOSImport && "*os.File".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (!param.required || addedTimeImport || !"time.Time".equals(param.dataType)) continue;
                imports.add(this.createMapping("import", "time"));
                addedTimeImport = true;
            }
        }
        return objs;
    }

    @Override
    public String apiPackage() {
        return this.sourceFolder;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library using OpenAPI-Generator. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

