/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;

public class KotlinClientCodegen
extends AbstractKotlinCodegen {
    protected static final String JVM = "jvm";
    protected static final String JVM_OKHTTP4 = "jvm-okhttp4";
    protected static final String JVM_OKHTTP3 = "jvm-okhttp3";
    protected static final String MULTIPLATFORM = "multiplatform";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String COLLECTION_TYPE = "collectionType";
    protected static final String VENDOR_EXTENSION_BASE_NAME_LITERAL = "x-base-name-literal";
    protected String dateLibrary;
    protected String collectionType;

    public KotlinClientCodegen() {
        this.dateLibrary = DateLibrary.JAVA8.value;
        this.collectionType = CollectionType.ARRAY.value;
        this.artifactId = "kotlin-client";
        this.packageName = "org.openapitools.client";
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-client";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "kotlin-client";
        this.embeddedTemplateDir = "kotlin-client";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(DateLibrary.THREETENBP.value, "Threetenbp (jvm only)");
        dateOptions.put(DateLibrary.STRING.value, "String");
        dateOptions.put(DateLibrary.JAVA8.value, "Java 8 native JSR310 (jvm only)");
        dateLibrary.setEnum(dateOptions);
        dateLibrary.setDefault(this.dateLibrary);
        this.cliOptions.add(dateLibrary);
        CliOption collectionType = new CliOption(COLLECTION_TYPE, "Option. Collection type to use");
        HashMap<String, String> collectionOptions = new HashMap<String, String>();
        collectionOptions.put(CollectionType.ARRAY.value, "kotlin.Array");
        collectionOptions.put(CollectionType.LIST.value, "kotlin.collections.List");
        collectionType.setEnum(collectionOptions);
        collectionType.setDefault(this.collectionType);
        this.cliOptions.add(collectionType);
        this.supportedLibraries.put(JVM_OKHTTP4, "[DEFAULT] Platform: Java Virtual Machine. HTTP client: OkHttp 4.2.0 (Android 5.0+ and Java 8+). JSON processing: Moshi 1.8.0.");
        this.supportedLibraries.put(JVM_OKHTTP3, "Platform: Java Virtual Machine. HTTP client: OkHttp 3.12.4 (Android 2.3+ and Java 7+). JSON processing: Moshi 1.8.0.");
        this.supportedLibraries.put(MULTIPLATFORM, "Platform: Kotlin multiplatform. HTTP client: Ktor 1.2.4. JSON processing: Kotlinx Serialization: 0.12.0.");
        CliOption libraryOption = new CliOption("library", "Library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(JVM_OKHTTP4);
        this.cliOptions.add(libraryOption);
        this.setLibrary(JVM_OKHTTP4);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "kotlin";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin client.";
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (MULTIPLATFORM.equals(this.getLibrary())) {
            this.sourceFolder = "src/commonMain/kotlin";
        }
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", "/");
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiClient.kt.mustache", infrastructureFolder, "ApiClient.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiAbstractions.kt.mustache", infrastructureFolder, "ApiAbstractions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestConfig.kt.mustache", infrastructureFolder, "RequestConfig.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestMethod.kt.mustache", infrastructureFolder, "RequestMethod.kt"));
        if (this.isJVMLibrary()) {
            this.additionalProperties.put(JVM, true);
            if (JVM_OKHTTP4.equals(this.getLibrary())) {
                this.additionalProperties.put(JVM_OKHTTP4, true);
            } else if (JVM_OKHTTP3.equals(this.getLibrary())) {
                this.additionalProperties.put(JVM_OKHTTP3, true);
            }
            this.supportedLibraries.put(JVM, "A workaround to use the same template folder for both 'jvm-okhttp3' and 'jvm-okhttp4'.");
            this.setLibrary(JVM);
            this.supportingFiles.add(new SupportingFile("infrastructure/ApplicationDelegates.kt.mustache", infrastructureFolder, "ApplicationDelegates.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/Errors.kt.mustache", infrastructureFolder, "Errors.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ResponseExtensions.kt.mustache", infrastructureFolder, "ResponseExtensions.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/Serializer.kt.mustache", infrastructureFolder, "Serializer.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ApiInfrastructureResponse.kt.mustache", infrastructureFolder, "ApiInfrastructureResponse.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ByteArrayAdapter.kt.mustache", infrastructureFolder, "ByteArrayAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/LocalDateAdapter.kt.mustache", infrastructureFolder, "LocalDateAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/LocalDateTimeAdapter.kt.mustache", infrastructureFolder, "LocalDateTimeAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/UUIDAdapter.kt.mustache", infrastructureFolder, "UUIDAdapter.kt"));
        } else if (MULTIPLATFORM.equals(this.getLibrary())) {
            this.additionalProperties.put(MULTIPLATFORM, true);
            this.setDateLibrary(DateLibrary.STRING.value);
            this.defaultIncludes.add("io.ktor.client.request.forms.InputProvider");
            this.defaultIncludes.add(this.packageName + ".infrastructure.Base64ByteArray");
            this.defaultIncludes.add(this.packageName + ".infrastructure.OctetByteArray");
            this.typeMapping.put("number", "kotlin.Double");
            this.typeMapping.put("file", "OctetByteArray");
            this.typeMapping.put("binary", "OctetByteArray");
            this.typeMapping.put("ByteArray", "Base64ByteArray");
            this.typeMapping.put("object", "kotlin.String");
            this.importMapping.put("BigDecimal", "kotlin.Double");
            this.importMapping.put("UUID", "kotlin.String");
            this.importMapping.put("URI", "kotlin.String");
            this.importMapping.put("InputProvider", "io.ktor.client.request.forms.InputProvider");
            this.importMapping.put("File", this.packageName + ".infrastructure.OctetByteArray");
            this.importMapping.put("Timestamp", "kotlin.String");
            this.importMapping.put("LocalDateTime", "kotlin.String");
            this.importMapping.put("LocalDate", "kotlin.String");
            this.importMapping.put("LocalTime", "kotlin.String");
            this.importMapping.put("Base64ByteArray", this.packageName + ".infrastructure.Base64ByteArray");
            this.importMapping.put("OctetByteArray", this.packageName + ".infrastructure.OctetByteArray");
            this.supportingFiles.add(new SupportingFile("infrastructure/Base64ByteArray.kt.mustache", infrastructureFolder, "Base64ByteArray.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/Bytes.kt.mustache", infrastructureFolder, "Bytes.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/HttpResponse.kt.mustache", infrastructureFolder, "HttpResponse.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/OctetByteArray.kt.mustache", infrastructureFolder, "OctetByteArray.kt"));
            String authFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "auth").replace(".", "/");
            this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.kt.mustache", authFolder, "ApiKeyAuth.kt"));
            this.supportingFiles.add(new SupportingFile("auth/Authentication.kt.mustache", authFolder, "Authentication.kt"));
            this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.kt.mustache", authFolder, "HttpBasicAuth.kt"));
            this.supportingFiles.add(new SupportingFile("auth/HttpBearerAuth.kt.mustache", authFolder, "HttpBearerAuth.kt"));
            this.supportingFiles.add(new SupportingFile("auth/OAuth.kt.mustache", authFolder, "OAuth.kt"));
            this.supportingFiles.add(new SupportingFile("commonTest/Coroutine.kt.mustache", "src/commonTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("iosTest/Coroutine.kt.mustache", "src/iosTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("jsTest/Coroutine.kt.mustache", "src/jsTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("jvmTest/Coroutine.kt.mustache", "src/jvmTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
            this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
            this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.properties"));
            this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.jar"));
        }
        if (DateLibrary.THREETENBP.value.equals(this.dateLibrary)) {
            this.additionalProperties.put(DateLibrary.THREETENBP.value, true);
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
            this.importMapping.put("LocalDateTime", "org.threeten.bp.LocalDateTime");
            this.defaultIncludes.add("org.threeten.bp.LocalDate");
            this.defaultIncludes.add("org.threeten.bp.LocalDateTime");
        } else if (DateLibrary.STRING.value.equals(this.dateLibrary)) {
            this.typeMapping.put("date-time", "kotlin.String");
            this.typeMapping.put("date", "kotlin.String");
            this.typeMapping.put("Date", "kotlin.String");
            this.typeMapping.put("DateTime", "kotlin.String");
        } else if (DateLibrary.JAVA8.value.equals(this.dateLibrary)) {
            this.additionalProperties.put(DateLibrary.JAVA8.value, true);
        }
        if (this.additionalProperties.containsKey(COLLECTION_TYPE)) {
            this.setCollectionType(this.additionalProperties.get(COLLECTION_TYPE).toString());
        }
        if (CollectionType.LIST.value.equals(this.collectionType)) {
            this.typeMapping.put("array", "kotlin.collections.List");
            this.typeMapping.put("list", "kotlin.collections.List");
            this.additionalProperties.put("isList", true);
        }
    }

    private boolean isJVMLibrary() {
        return this.getLibrary() != null && (this.getLibrary().contains(JVM_OKHTTP4) || this.getLibrary().contains(JVM_OKHTTP3));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> objects = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Object model : models) {
            Map mo = (Map)model;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (cm.requiredVars != null) {
                for (CodegenProperty var : cm.requiredVars) {
                    var.vendorExtensions.put(VENDOR_EXTENSION_BASE_NAME_LITERAL, var.baseName.replace("$", "\\$"));
                }
            }
            if (cm.optionalVars == null) continue;
            for (CodegenProperty var : cm.optionalVars) {
                var.vendorExtensions.put(VENDOR_EXTENSION_BASE_NAME_LITERAL, var.baseName.replace("$", "\\$"));
            }
        }
        return objects;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.hasConsumes == Boolean.TRUE && KotlinClientCodegen.isMultipartType(operation.consumes)) {
                    operation.isMultipart = Boolean.TRUE;
                }
                if (!MULTIPLATFORM.equals(this.getLibrary()) || operation.allParams == null) continue;
                for (CodegenParameter param : operation.allParams) {
                    if (param.dataFormat == null || !param.dataFormat.equals("binary")) continue;
                    param.dataType = "io.ktor.client.request.forms.InputProvider";
                    param.baseType = "io.ktor.client.request.forms.InputProvider";
                }
            }
        }
        return operations;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        if (firstType != null) {
            return "multipart/form-data".equals(firstType.get("mediaType"));
        }
        return false;
    }

    public static enum CollectionType {
        ARRAY("array"),
        LIST("list");

        public final String value;

        private CollectionType(String value) {
            this.value = value;
        }
    }

    public static enum DateLibrary {
        STRING("string"),
        THREETENBP("threetenbp"),
        JAVA8("java8");

        public final String value;

        private DateLibrary(String value) {
            this.value = value;
        }
    }
}

