/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.GoClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoClientExperimentalCodegen
extends GoClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoClientExperimentalCodegen.class);
    protected String goImportAlias = "openapiclient";
    protected boolean useOneOfDiscriminatorLookup = false;

    public GoClientExperimentalCodegen() {
        this.outputFolder = "generated-code/go-experimental";
        this.templateDir = "go-experimental";
        this.embeddedTemplateDir = "go-experimental";
        this.usesOptionals = false;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.cliOptions.add(new CliOption("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and onlye one match in oneOf's schemas) will be skipped.").defaultValue("false"));
    }

    @Override
    public String getName() {
        return "go-experimental";
    }

    @Override
    public String toGetter(String name) {
        return "Get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getHelp() {
        return "Generates a Go client library (experimental and may subject to breaking changes without further notice).";
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", "utils.go"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", "", "signing.go"));
        }
        if (this.additionalProperties.containsKey("goImportAlias")) {
            this.setGoImportAlias(this.additionalProperties.get("goImportAlias").toString());
        } else {
            this.additionalProperties.put("goImportAlias", this.goImportAlias);
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    public void setGoImportAlias(String goImportAlias) {
        this.goImportAlias = goImportAlias;
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModel(name, false));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return name + '_';
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        String prefix = "";
        if (this.enumClassPrefix) {
            prefix = datatype.toUpperCase(Locale.ROOT) + "_";
        }
        return prefix + value;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        String enumDefault = null;
        if (var.isEnum && var.defaultValue != null) {
            enumDefault = var.defaultValue;
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum && enumDefault != null) {
            var.defaultValue = enumDefault;
        }
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p = ModelUtils.getReferencedSchema(this.openAPI, p))) {
            if (p.getDefault() != null) {
                return "\"" + this.escapeText((String)p.getDefault()) + "\"";
            }
            return null;
        }
        return super.toDefaultValue(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty prop = super.fromProperty(name, p);
        String cc = StringUtils.camelize(prop.name, true);
        if (this.isReservedWord(cc)) {
            cc = this.escapeReservedWord(cc);
        }
        prop.nameInCamelCase = cc;
        return prop;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Map m : models) {
            Object v = m.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel model = (CodegenModel)v;
            if (model.isEnum) continue;
            for (CodegenProperty param : model.vars) {
                param.vendorExtensions.put("x-go-base-type", param.dataType);
                if (!param.isNullable || param.isMapContainer || param.isListContainer || param.isFreeFormObject || param.isAnyType) continue;
                if (param.isDateTime) {
                    param.dataType = "NullableTime";
                    continue;
                }
                param.dataType = "Nullable" + Character.toUpperCase(param.dataType.charAt(0)) + param.dataType.substring(1);
            }
            if (model.oneOf != null && !model.oneOf.isEmpty()) {
                imports.add(this.createMapping("import", "fmt"));
            }
            if (model.anyOf != null && !model.anyOf.isEmpty()) {
                imports.add(this.createMapping("import", "fmt"));
            }
            if (!"map[string]map[string]interface{}".equals(model.parent)) continue;
            model.vendorExtensions.put("x-additional-properties", true);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, Integer> processedModelMaps = new HashMap<String, Integer>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-go-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
        }
        processedModelMaps.clear();
        for (CodegenOperation operation : operationList) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-go-example", this.constructExampleCode(cp, modelMaps, processedModelMaps));
            }
        }
        return objs;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenParameter.isListContainer) {
            return codegenParameter.dataType + "{" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + "}";
        }
        if (codegenParameter.isMapContainer) {
            return "map[string]string{ \"Key\" = \"Value\" }";
        }
        if (codegenParameter.isPrimitiveType) {
            if (codegenParameter.isString) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                    return "\"" + codegenParameter.example + "\"";
                }
                return "\"" + codegenParameter.paramName + "_example\"";
            }
            if (codegenParameter.isBoolean) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenParameter.isUri) {
                return "URL(string: \"https://example.com\")!";
            }
            if (codegenParameter.isDateTime || codegenParameter.isDate) {
                return "Get-Date";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "987";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenProperty.isListContainer) {
            return codegenProperty.dataType + "{" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + ")";
        }
        if (codegenProperty.isMapContainer) {
            return "map[string]string{ \"Key\" = \"Value\" }";
        }
        if (codegenProperty.isPrimitiveType) {
            if (codegenProperty.isString) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if (codegenProperty.isBoolean) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenProperty.isUri) {
                return "\"https://example.com\")!";
            }
            if (codegenProperty.isDateTime || codegenProperty.isDate) {
                return "time.Now()";
            }
            String example = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) ? codegenProperty.example : "123";
            if (codegenProperty.isLong) {
                return "int64(" + example + ")";
            }
            return example;
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap);
        }
        return "\"TODO\"";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        block5: {
            String model = codegenModel.name;
            if (processedModelMap.containsKey(model)) {
                int count = processedModelMap.get(model);
                if (count == 1) {
                    processedModelMap.put(model, 2);
                    break block5;
                } else {
                    if (count != 2) throw new RuntimeException("Invalid count when constructing example: " + count);
                    return "";
                }
            }
            processedModelMap.put(model, 1);
        }
        String example = "" + this.goImportAlias + "." + codegenModel.name + "{";
        ArrayList<String> propertyExamples = new ArrayList<String>();
        Iterator<CodegenProperty> iterator = codegenModel.allVars.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                example = example + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ");
                return example + "}";
            }
            CodegenProperty codegenProperty = iterator.next();
            propertyExamples.add(codegenProperty.name + ": " + this.constructExampleCode(codegenProperty, modelMaps, processedModelMap));
        }
    }
}

