/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSharpCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalEmitDefaultValuesFlag = false;
    protected boolean optionalProjectFileFlag = true;
    protected boolean optionalMethodArgumentFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected boolean netCoreProjectFileFlag = false;
    protected String modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.PascalCase.name();
    protected String licenseUrl = "http://localhost";
    protected String licenseName = "NoLicense";
    protected String packageVersion = "1.0.0";
    protected String packageName = "Org.OpenAPITools";
    protected String packageTitle = "OpenAPI Library";
    protected String packageProductName = "OpenAPILibrary";
    protected String packageDescription = "A library generated from a OpenAPI doc";
    protected String packageCompany = "OpenAPI";
    protected String packageCopyright = "No Copyright";
    protected String packageAuthors = "OpenAPI";
    protected String interfacePrefix = "I";
    protected String enumNameSuffix = "Enum";
    protected String enumValueSuffix = "Enum";
    protected String sourceFolder;
    protected String testFolder = this.sourceFolder = "src";
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected boolean supportNullable = Boolean.FALSE;
    protected Set<String> nullableType = new HashSet<String>();
    protected Set<String> valueTypes = new HashSet<String>();
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractCSharpCodegen.class);

    public AbstractCSharpCodegen() {
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("IList", "List", "ICollection", "Collection", "IEnumerable"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary"));
        this.reservedWords.addAll(Arrays.asList("Client", "client", "parameter", "localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "bool", "double?", "double", "decimal?", "decimal", "int?", "int", "long?", "long", "float?", "float", "byte[]", "ICollection", "Collection", "List", "Dictionary", "DateTime?", "DateTime", "DateTimeOffset?", "DateTimeOffset", "Boolean", "Double", "Decimal", "Int32", "Int64", "Float", "Guid?", "Guid", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("list", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("boolean", "bool?");
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("long", "long?");
        this.typeMapping.put("double", "double?");
        this.typeMapping.put("number", "decimal?");
        this.typeMapping.put("BigDecimal", "decimal?");
        this.typeMapping.put("DateTime", "DateTime?");
        this.typeMapping.put("date", "DateTime?");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("UUID", "Guid?");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("AnyType", "Object");
        this.nullableType = new HashSet<String>(Arrays.asList("decimal", "bool", "int", "float", "long", "double", "DateTime", "DateTimeOffset", "Guid"));
        this.valueTypes = new HashSet<String>(Arrays.asList("decimal", "bool", "int", "float", "long", "double"));
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.typeMapping.put("array", "Collection");
            this.typeMapping.put("list", "Collection");
            this.instantiationTypes.put("array", "Collection");
            this.instantiationTypes.put("list", "Collection");
        }
    }

    public void setOptionalMethodArgumentFlag(boolean flag) {
        this.optionalMethodArgumentFlag = flag;
    }

    public void setNetCoreProjectFileFlag(boolean flag) {
        this.netCoreProjectFileFlag = flag;
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        if (flag) {
            this.typeMapping.put("DateTime", "DateTimeOffset");
        } else {
            this.typeMapping.put("DateTime", "DateTime");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("CSHARP_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable CSHARP_POST_PROCESS_FILE not defined so the C# code may not be properly formatted by uncrustify (0.66 or later) or other code formatter. To define it, try `export CSHARP_POST_PROCESS_FILE=\"/usr/local/bin/uncrustify --no-backup\" && export UNCRUSTIFY_CONFIG=/path/to/uncrustify-rules.cfg` (Linux/Mac). Note: replace /path/to with the location of uncrustify-rules.cfg");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn(String.format(Locale.ROOT, "%s is not used by C# generators. Please use %s", "invokerPackage", "packageName"));
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("packageAuthors")) {
            this.setPackageAuthors((String)this.additionalProperties.get("packageAuthors"));
        } else {
            this.additionalProperties.put("packageAuthors", this.packageAuthors);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(this.convertPropertyToBooleanAndWriteBack("useDateTimeOffset"));
        } else {
            this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        }
        if (this.additionalProperties.containsKey("useCollection")) {
            this.setUseCollection(this.convertPropertyToBooleanAndWriteBack("useCollection"));
        } else {
            this.additionalProperties.put("useCollection", this.useCollection);
        }
        if (this.additionalProperties.containsKey("returnICollection")) {
            this.setReturnICollection(this.convertPropertyToBooleanAndWriteBack("returnICollection"));
        } else {
            this.additionalProperties.put("returnICollection", this.returnICollection);
        }
        if (this.additionalProperties.containsKey("netCoreProjectFile")) {
            this.setNetCoreProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("netCoreProjectFile"));
        } else {
            this.additionalProperties.put("netCoreProjectFile", this.netCoreProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("interfacePrefix")) {
            String useInterfacePrefix = this.additionalProperties.get("interfacePrefix").toString();
            if ("false".equals(useInterfacePrefix.toLowerCase(Locale.ROOT))) {
                this.setInterfacePrefix("");
            } else if (!"true".equals(useInterfacePrefix.toLowerCase(Locale.ROOT))) {
                this.setInterfacePrefix(this.sanitizeName(useInterfacePrefix));
            }
        }
        if (this.additionalProperties().containsKey("enumNameSuffix")) {
            this.setEnumNameSuffix(this.additionalProperties.get("enumNameSuffix").toString());
        }
        if (this.additionalProperties().containsKey("enumValueSuffix")) {
            this.setEnumValueSuffix(this.additionalProperties.get("enumValueSuffix").toString());
        }
        this.additionalProperties.put("interfacePrefix", this.interfacePrefix);
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.name.equalsIgnoreCase(cm.name)) continue;
                var.name = "_" + var.name;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> processed = super.postProcessAllModels(objs);
        this.postProcessEnumRefs(processed);
        this.updateValueTypeProperty(processed);
        this.updateNullableTypeProperty(processed);
        return processed;
    }

    private void postProcessEnumRefs(Map<String, Object> models) {
        HashMap<String, CodegenModel> enumRefs = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            CodegenModel model = ModelUtils.getModelByName(entry.getKey(), models);
            if (!model.isEnum) continue;
            enumRefs.put(entry.getKey(), model);
        }
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String openAPIName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName(openAPIName, models);
            if (model != null) {
                CodegenModel refModel;
                for (CodegenProperty var : model.allVars) {
                    if (!enumRefs.containsKey(var.dataType)) continue;
                    refModel = (CodegenModel)enumRefs.get(var.dataType);
                    var.allowableValues = refModel.allowableValues;
                    var.isEnum = true;
                    var.isPrimitiveType = true;
                }
                for (CodegenProperty var : model.vars) {
                    if (!enumRefs.containsKey(var.dataType)) continue;
                    refModel = (CodegenModel)enumRefs.get(var.dataType);
                    var.allowableValues = refModel.allowableValues;
                    var.isEnum = true;
                    var.isPrimitiveType = true;
                }
                for (CodegenProperty var : model.readWriteVars) {
                    if (!enumRefs.containsKey(var.dataType)) continue;
                    refModel = (CodegenModel)enumRefs.get(var.dataType);
                    var.allowableValues = refModel.allowableValues;
                    var.isEnum = true;
                    var.isPrimitiveType = true;
                }
                for (CodegenProperty var : model.readOnlyVars) {
                    if (!enumRefs.containsKey(var.dataType)) continue;
                    refModel = (CodegenModel)enumRefs.get(var.dataType);
                    var.allowableValues = refModel.allowableValues;
                    var.isEnum = true;
                    var.isPrimitiveType = true;
                }
                if (!model.isEnum) continue;
                Boolean isString = false;
                Boolean isInteger = false;
                Boolean isLong = false;
                Boolean isByte = false;
                if (model.dataType.startsWith("byte")) {
                    isByte = true;
                    model.vendorExtensions.put("x-enum-byte", true);
                } else if (model.dataType.startsWith("int32")) {
                    isInteger = true;
                    model.vendorExtensions.put("x-enum-integer", true);
                } else if (model.dataType.startsWith("int64")) {
                    isLong = true;
                    model.vendorExtensions.put("x-enum-long", true);
                } else {
                    isString = true;
                    model.vendorExtensions.put("x-enum-string", true);
                }
                ArrayList enumVars = (ArrayList)model.allowableValues.get("enumVars");
                ArrayList newEnumVars = new ArrayList();
                for (Map enumVar : enumVars) {
                    HashMap<String, Boolean> mixedVars = new HashMap<String, Boolean>();
                    mixedVars.putAll(enumVar);
                    mixedVars.put("isString", isString);
                    mixedVars.put("isLong", isLong);
                    mixedVars.put("isInteger", isInteger);
                    mixedVars.put("isByte", isByte);
                    newEnumVars.add(mixedVars);
                }
                if (newEnumVars.isEmpty()) continue;
                model.allowableValues.put("enumVars", newEnumVars);
                continue;
            }
            this.LOGGER.warn("Expected to retrieve model %s by name, but no model was found. Check your -Dmodels inclusions.", (Object)openAPIName);
        }
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        if (var.vendorExtensions == null) {
            var.vendorExtensions = new HashMap<String, Object>();
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum) {
            if ("byte".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-enum-byte", true);
                var.isString = false;
                var.isLong = false;
                var.isInteger = false;
            } else if ("int32".equals(var.dataFormat)) {
                var.isInteger = true;
                var.isString = false;
                var.isLong = false;
            } else if ("int64".equals(var.dataFormat)) {
                var.isLong = true;
                var.isString = false;
                var.isInteger = false;
            } else {
                var.isString = true;
                var.isInteger = false;
                var.isLong = false;
            }
        }
    }

    protected void updateValueTypeProperty(Map<String, Object> models) {
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String openAPIName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName(openAPIName, models);
            if (model == null) continue;
            for (CodegenProperty var : model.vars) {
                var.vendorExtensions.put("x-is-value-type", this.isValueType(var));
            }
        }
    }

    protected void updateNullableTypeProperty(Map<String, Object> models) {
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String openAPIName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName(openAPIName, models);
            if (model == null) continue;
            for (CodegenProperty var : model.vars) {
                if (var.isContainer || !this.nullableType.contains(var.dataType) && !var.isEnum) continue;
                var.vendorExtensions.put("x-csharp-value-type", true);
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.returnType != null) {
                    int n = operation.returnType.lastIndexOf(".");
                    String typeMapping = n > 0 ? operation.returnType.substring(n) : operation.returnType;
                    if (this.collectionTypes.contains(typeMapping)) {
                        int genericStart;
                        operation.isArray = true;
                        operation.returnContainer = operation.returnType;
                        if (this.returnICollection && (typeMapping.startsWith("List") || typeMapping.startsWith("Collection")) && (genericStart = typeMapping.indexOf("<")) > 0) {
                            operation.returnType = "ICollection" + typeMapping.substring(genericStart);
                        }
                    } else {
                        operation.returnContainer = operation.returnType;
                        operation.isMap = this.mapTypes.contains(typeMapping);
                    }
                }
                if (operation.consumes != null) {
                    for (Map<String, String> map : operation.consumes) {
                        if (!map.containsKey("mediaType") || !AbstractCSharpCodegen.isJsonMimeType(map.get("mediaType"))) continue;
                        operation.vendorExtensions.put("x-is-json", true);
                        break;
                    }
                }
                if (operation.examples != null) {
                    for (Map map : operation.examples) {
                        for (Map.Entry entry : map.entrySet()) {
                            String val = ((String)entry.getValue()).replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                            entry.setValue(val);
                        }
                    }
                }
                if (!this.isSupportNullable()) {
                    for (CodegenParameter codegenParameter : operation.allParams) {
                        CodegenModel model = null;
                        for (Object modelHashMap : allModels) {
                            CodegenModel codegenModel = (CodegenModel)((HashMap)modelHashMap).get("model");
                            if (!codegenModel.getClassname().equals(codegenParameter.dataType)) continue;
                            model = codegenModel;
                            break;
                        }
                        if (model == null) {
                            codegenParameter.isNullable = true;
                            continue;
                        }
                        if (model.isEnum) {
                            codegenParameter.isEnum = true;
                            codegenParameter.allowableValues = model.allowableValues;
                            codegenParameter.isPrimitiveType = true;
                            codegenParameter.isNullable = false;
                            continue;
                        }
                        codegenParameter.isNullable = true;
                    }
                } else {
                    this.updateCodegenParametersEnum(operation.allParams, allModels);
                }
                this.processOperation(operation);
            }
        }
        return objs;
    }

    protected void processOperation(CodegenOperation operation) {
    }

    private void updateCodegenParametersEnum(List<CodegenParameter> parameters, List<Object> allModels) {
        for (CodegenParameter parameter : parameters) {
            CodegenModel model = null;
            for (Object modelHashMap : allModels) {
                CodegenModel codegenModel = (CodegenModel)((HashMap)modelHashMap).get("model");
                if (!codegenModel.getClassname().equals(parameter.dataType)) continue;
                model = codegenModel;
                break;
            }
            if (model != null && model.isEnum) {
                parameter.isEnum = true;
                parameter.allowableValues = model.allowableValues;
                parameter.isPrimitiveType = true;
                parameter.vendorExtensions.put("x-csharp-value-type", true);
            }
            if (!parameter.isContainer && this.nullableType.contains(parameter.dataType)) {
                parameter.vendorExtensions.put("x-csharp-value-type", true);
            }
            if (parameter.required || parameter.vendorExtensions.get("x-csharp-value-type") == null) continue;
            parameter.dataType = parameter.dataType + "?";
        }
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toExampleValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getExample() != null) {
                return "\"" + p.getExample().toString() + "\"";
            }
        } else if (ModelUtils.isBooleanSchema(p) ? p.getExample() != null : !ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p) && (ModelUtils.isNumberSchema(p) ? p.getExample() != null : ModelUtils.isIntegerSchema(p) && p.getExample() != null)) {
            return p.getExample().toString();
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                if (ModelUtils.isFloatSchema(p)) {
                    return p.getDefault().toString() + "F";
                }
                if (ModelUtils.isDoubleSchema(p)) {
                    return p.getDefault().toString() + "D";
                }
                return p.getDefault().toString() + "M";
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            String _default = (String)p.getDefault();
            if (p.getEnum() == null) {
                return "\"" + _default + "\"";
            }
            return _default;
        }
        return null;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            this.LOGGER.error("OpenAPI Type for {} is null. Default to UNKNOWN_OPENAPI_TYPE instead.", (Object)p.getName());
            openAPIType = "UNKNOWN_OPENAPI_TYPE";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            String languageType = this.getNullableType(p, type);
            if (languageType != null) {
                return languageType;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    private String getArrayTypeDeclaration(ArraySchema arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toModelName(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setPackageAuthors(String packageAuthors) {
        this.packageAuthors = packageAuthors;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    public void setEnumNameSuffix(String enumNameSuffix) {
        this.enumNameSuffix = enumNameSuffix;
    }

    public void setEnumValueSuffix(String enumValueSuffix) {
        this.enumValueSuffix = enumValueSuffix;
    }

    public boolean isSupportNullable() {
        return this.supportNullable;
    }

    public void setSupportNullable(boolean supportNullable) {
        this.supportNullable = supportNullable;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("byte")) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(this.getSymbolName(name));
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = StringUtils.camelize(enumName) + this.enumValueSuffix).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + this.enumNameSuffix;
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equalsIgnoreCase(dataType) || "double?".equals(dataType) || "decimal?".equals(dataType) || "float?".equals(dataType) || "double".equals(dataType) || "decimal".equals(dataType) || "float".equals(dataType);
    }

    protected boolean isValueType(CodegenProperty var) {
        return this.valueTypes.contains(var.dataType) || var.isEnum;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            codegenParameter.example = "true";
        } else if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            codegenParameter.example = "789";
        } else if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            codegenParameter.example = "56";
        } else if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            codegenParameter.example = "3.4F";
        } else if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            codegenParameter.example = "1.2D";
        } else if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            codegenParameter.example = "8.14";
        } else if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "BYTE_ARRAY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(codegenParameter.isUri)) {
            codegenParameter.example = "https://openapi-generator.tech";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String csharpPostProcessFile = System.getenv("CSHARP_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)csharpPostProcessFile)) {
            return;
        }
        if ("cs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = csharpPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

