/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swift5ClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(Swift5ClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String RESPONSE_AS = "responseAs";
    public static final String OBJC_COMPATIBLE = "objcCompatible";
    public static final String POD_SOURCE = "podSource";
    public static final String POD_AUTHORS = "podAuthors";
    public static final String POD_SOCIAL_MEDIA_URL = "podSocialMediaURL";
    public static final String POD_LICENSE = "podLicense";
    public static final String POD_HOMEPAGE = "podHomepage";
    public static final String POD_SUMMARY = "podSummary";
    public static final String POD_DESCRIPTION = "podDescription";
    public static final String POD_SCREENSHOTS = "podScreenshots";
    public static final String POD_DOCUMENTATION_URL = "podDocumentationURL";
    public static final String READONLY_PROPERTIES = "readonlyProperties";
    public static final String SWIFT_USE_API_NAMESPACE = "swiftUseApiNamespace";
    public static final String DEFAULT_POD_AUTHORS = "OpenAPI Generator";
    public static final String LENIENT_TYPE_CAST = "lenientTypeCast";
    protected static final String LIBRARY_ALAMOFIRE = "alamofire";
    protected static final String LIBRARY_URLSESSION = "urlsession";
    protected static final String RESPONSE_LIBRARY_PROMISE_KIT = "PromiseKit";
    protected static final String RESPONSE_LIBRARY_RX_SWIFT = "RxSwift";
    protected static final String RESPONSE_LIBRARY_RESULT = "Result";
    protected static final String RESPONSE_LIBRARY_COMBINE = "Combine";
    protected static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit", "RxSwift", "Result", "Combine"};
    protected String projectName = "OpenAPIClient";
    protected boolean nonPublicApi = false;
    protected boolean objcCompatible = false;
    protected boolean lenientTypeCast = false;
    protected boolean readonlyProperties = false;
    protected boolean swiftUseApiNamespace;
    protected String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "OpenAPIs";
    protected HashSet objcReservedWords;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public Swift5ClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift5";
        this.embeddedTemplateDir = "swift5";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "URL", "Data", "Date", "Character", "UUID", "URL", "AnyObject", "Any", "Decimal"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Data", "Date", "URL", "UUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject", "Any", "Decimal"));
        this.objcReservedWords = new HashSet<String>(Arrays.asList("id", "description", "NSArray", "NSURL", "CGFloat", "NSSet", "NSString", "NSInteger", "NSUInteger", "NSError", "NSDictionary", "hash", "className"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Response", "associatedtype", "class", "deinit", "enum", "extension", "fileprivate", "func", "import", "init", "inout", "internal", "let", "open", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "Any", "catch", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "_", "#available", "#colorLiteral", "#column", "#else", "#elseif", "#endif", "#file", "#fileLiteral", "#function", "#if", "#imageLiteral", "#line", "#selector", "#sourceLocation", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet", "Bool", "Int", "Double", "Float", "Range", "ClosedRange", "Error", "Optional", "UInt", "UInt8", "UInt16", "UInt32", "UInt64", "Int8", "Int16", "Int32", "Int64", "Float80", "Float32", "Float64", "String", "Character", "Unicode", "StaticString", "Array", "Dictionary", "Set", "OptionSet", "CountableRange", "CountableClosedRange", "URL", "Data", "Codable", "Encodable", "Decodable", "Void", "AnyObject", "Class", "dynamicType", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("file", "URL");
        this.typeMapping.put("binary", "URL");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("decimal", "Decimal");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("AnyType", "Any");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption(RESPONSE_AS, "Optionally use libraries to manage response.  Currently " + org.apache.commons.lang3.StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers.(default: false)"));
        this.cliOptions.add(new CliOption(OBJC_COMPATIBLE, "Add additional properties and methods for Objective-C compatibility (default: false)"));
        this.cliOptions.add(new CliOption(POD_SOURCE, "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption(POD_AUTHORS, "Authors used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SOCIAL_MEDIA_URL, "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_LICENSE, "License used for Podspec"));
        this.cliOptions.add(new CliOption(POD_HOMEPAGE, "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SUMMARY, "Summary used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DESCRIPTION, "Description used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SCREENSHOTS, "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCUMENTATION_URL, "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption(READONLY_PROPERTIES, "Make properties readonly (default: false)"));
        this.cliOptions.add(new CliOption(SWIFT_USE_API_NAMESPACE, "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(LENIENT_TYPE_CAST, "Accept and cast values for simple types (string->bool, string->int, int->string)").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all API names ('tags'). Default: empty string. e.g. Pet => Pet."));
        this.supportedLibraries.put(LIBRARY_URLSESSION, "[DEFAULT] HTTP client: URLSession");
        this.supportedLibraries.put(LIBRARY_ALAMOFIRE, "HTTP client: Alamofire");
        CliOption libraryOption = new CliOption("library", "Library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(LIBRARY_URLSESSION);
        this.cliOptions.add(libraryOption);
        this.setLibrary(LIBRARY_URLSESSION);
    }

    private static CodegenModel reconcileProperties(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        codegenModel.allVars = new ArrayList<CodegenProperty>(codegenProperties);
        codegenModel.parentVars = parentCodegenModel.allVars;
        boolean removedChildProperty = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.baseName.equals(parentModelCodegenProperty.baseName)) continue;
                iterator.remove();
                removedChildProperty = true;
            }
        }
        if (removedChildProperty) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift5";
    }

    @Override
    public String getHelp() {
        return "Generates a Swift 5.x client library.";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = this.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("SWIFT_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable SWIFT_POST_PROCESS_FILE not defined so the Swift code may not be properly formatted. To define it, try 'export SWIFT_POST_PROCESS_FILE=/usr/local/bin/swiftformat' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        }
        this.additionalProperties.put("nonPublicApi", this.nonPublicApi);
        if (this.additionalProperties.containsKey(OBJC_COMPATIBLE)) {
            this.setObjcCompatible(this.convertPropertyToBooleanAndWriteBack(OBJC_COMPATIBLE));
        }
        this.additionalProperties.put(OBJC_COMPATIBLE, this.objcCompatible);
        if (Boolean.TRUE.equals(this.objcCompatible)) {
            this.reservedWords.addAll(this.objcReservedWords);
        }
        if (this.additionalProperties.containsKey(RESPONSE_AS)) {
            Object responseAsObject = this.additionalProperties.get(RESPONSE_AS);
            if (responseAsObject instanceof String) {
                this.setResponseAs(((String)responseAsObject).split(","));
            } else {
                this.setResponseAs((String[])responseAsObject);
            }
        }
        this.additionalProperties.put(RESPONSE_AS, this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)RESPONSE_LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)RESPONSE_LIBRARY_RX_SWIFT)) {
            this.additionalProperties.put("useRxSwift", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)RESPONSE_LIBRARY_RESULT)) {
            this.additionalProperties.put("useResult", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)RESPONSE_LIBRARY_COMBINE)) {
            this.additionalProperties.put("useCombine", true);
        }
        if (this.additionalProperties.containsKey(READONLY_PROPERTIES)) {
            this.setReadonlyProperties(this.convertPropertyToBooleanAndWriteBack(READONLY_PROPERTIES));
        }
        this.additionalProperties.put(READONLY_PROPERTIES, this.readonlyProperties);
        if (this.additionalProperties.containsKey(SWIFT_USE_API_NAMESPACE)) {
            this.setSwiftUseApiNamespace(this.convertPropertyToBooleanAndWriteBack(SWIFT_USE_API_NAMESPACE));
        }
        if (!this.additionalProperties.containsKey(POD_AUTHORS)) {
            this.additionalProperties.put(POD_AUTHORS, DEFAULT_POD_AUTHORS);
        }
        this.setLenientTypeCast(this.convertPropertyToBooleanAndWriteBack(LENIENT_TYPE_CAST));
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("Package.swift.mustache", "", "Package.swift"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder, "Configuration.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
        this.supportingFiles.add(new SupportingFile("CodableHelper.mustache", this.sourceFolder, "CodableHelper.swift"));
        this.supportingFiles.add(new SupportingFile("OpenISO8601DateFormatter.mustache", this.sourceFolder, "OpenISO8601DateFormatter.swift"));
        this.supportingFiles.add(new SupportingFile("JSONDataEncoding.mustache", this.sourceFolder, "JSONDataEncoding.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodingHelper.mustache", this.sourceFolder, "JSONEncodingHelper.swift"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("SynchronizedDictionary.mustache", this.sourceFolder, "SynchronizedDictionary.swift"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("XcodeGen.mustache", "", "project.yml"));
        switch (this.getLibrary()) {
            case "alamofire": {
                this.additionalProperties.put("useAlamofire", true);
                this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
                break;
            }
            case "urlsession": {
                this.additionalProperties.put("useURLSession", true);
                this.supportingFiles.add(new SupportingFile("URLSessionImplementations.mustache", this.sourceFolder, "URLSessionImplementations.swift"));
                break;
            }
        }
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return ModelUtils.isSet(p) ? "Set<" + this.getTypeDeclaration(inner) + ">" : "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return "[String: " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("URL");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("Data");
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name))) {
            String modelName = "Model" + name;
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getEnum() != null && !p.getEnum().isEmpty() && p.getDefault() != null) {
            if (ModelUtils.isStringSchema(p)) {
                return "." + this.toEnumVarName(this.escapeText((String)p.getDefault()), p.getType());
            }
            return "." + this.toEnumVarName(this.escapeText(p.getDefault().toString()), p.getType());
        }
        if (p.getDefault() != null) {
            if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
                return p.getDefault().toString();
            }
            if (ModelUtils.isDateTimeSchema(p)) {
                Instant instant = ((OffsetDateTime)p.getDefault()).toInstant();
                long epochMicro = TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + (long)instant.get(ChronoField.MICRO_OF_SECOND);
                return "Date(timeIntervalSince1970: " + String.valueOf(epochMicro) + ".0 / 1_000_000)";
            }
            if (ModelUtils.isStringSchema(p)) {
                return "\"" + this.escapeText((String)p.getDefault()) + "\"";
            }
        }
        return null;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return this.getSchemaType(this.getAdditionalProperties(p));
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return ModelUtils.isSet(p) ? "Set<" + inner + ">" : "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return StringUtils.camelize(this.apiNamePrefix + "_" + name) + "API";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace("/", File.separator);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace("/", File.separator);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(operationId = StringUtils.camelize(this.sanitizeName(operationId), true)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), true);
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (allDefinitions != null) {
            String parentSchema = codegenModel.parentSchema;
            while (parentSchema != null) {
                Schema parentModel = allDefinitions.get(parentSchema);
                CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
                codegenModel = Swift5ClientCodegen.reconcileProperties(codegenModel, parentCodegenModel);
                parentSchema = parentCodegenModel.parentSchema;
            }
        }
        return codegenModel;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public void setObjcCompatible(boolean objcCompatible) {
        this.objcCompatible = objcCompatible;
    }

    public void setLenientTypeCast(boolean lenientTypeCast) {
        this.lenientTypeCast = lenientTypeCast;
    }

    public void setReadonlyProperties(boolean readonlyProperties) {
        this.readonlyProperties = readonlyProperties;
    }

    public void setResponseAs(String[] responseAs) {
        this.responseAs = responseAs;
    }

    public void setSwiftUseApiNamespace(boolean swiftUseApiNamespace) {
        this.swiftUseApiNamespace = swiftUseApiNamespace;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("String".equals(datatype) || "[String]".equals(datatype) || "[String: String]".equals(datatype)) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String nameLowercase;
        if (name.length() == 0) {
            return "empty";
        }
        Pattern startWithNumberPattern = Pattern.compile("^\\d+");
        Matcher startWithNumberMatcher = startWithNumberPattern.matcher(name);
        if (startWithNumberMatcher.find()) {
            String startingNumbers = startWithNumberMatcher.group(0);
            String nameWithoutStartingNumbers = name.substring(startingNumbers.length());
            return "_" + startingNumbers + StringUtils.camelize(nameWithoutStartingNumbers, true);
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase(Locale.ROOT)), true);
        }
        Boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = StringUtils.camelize(name, true);
            camelized = true;
        }
        if (this.isReservedWord(nameLowercase = org.apache.commons.lang3.StringUtils.lowerCase((String)name))) {
            return this.escapeReservedWord(nameLowercase);
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "number" + StringUtils.camelize(name);
            varName = varName.replaceAll("-", "minus");
            varName = varName.replaceAll("\\+", "plus");
            varName = varName.replaceAll("\\.", "dot");
            return varName;
        }
        if (camelized.booleanValue()) {
            return name;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return StringUtils.camelize(WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :\\(\\)]", ""), true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if (this.isReservedWord(property.datatypeWithEnum) || this.toVarName(property.name).equals(property.datatypeWithEnum)) {
            enumName = property.datatypeWithEnum + "Enum";
        }
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        List models = (List)postProcessedModelsEnum.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean modelHasPropertyWithEscapedName = false;
            for (CodegenProperty prop : cm.allVars) {
                if (prop.name.equals(prop.baseName)) continue;
                prop.vendorExtensions.put("x-codegen-escaped-property-name", true);
                modelHasPropertyWithEscapedName = true;
            }
            if (!modelHasPropertyWithEscapedName) continue;
            cm.vendorExtensions.put("x-codegen-has-escaped-property-names", true);
        }
        return postProcessedModelsEnum;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isSwiftScalarType;
        super.postProcessModelProperty(model, property);
        boolean bl = isSwiftScalarType = property.isInteger || property.isLong || property.isFloat || property.isDouble || property.isBoolean;
        if ((!property.required || property.isNullable) && isSwiftScalarType) {
            property.vendorExtensions.put("x-swift-optional-scalar", true);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String swiftPostProcessFile = System.getenv("SWIFT_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)swiftPostProcessFile)) {
            return;
        }
        if ("swift".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = swiftPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-swift-example", this.constructExampleCode(cp, modelMaps, new HashSet<String>()));
            }
        }
        return objs;
    }

    public String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, Set<String> visitedModels) {
        if (codegenParameter.isArray) {
            return "[" + this.constructExampleCode(codegenParameter.items, modelMaps, visitedModels) + "]";
        }
        if (codegenParameter.isMap) {
            return "\"TODO\"";
        }
        if (this.languageSpecificPrimitives.contains(codegenParameter.dataType)) {
            if ("String".equals(codegenParameter.dataType) || "Character".equals(codegenParameter.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                    return "\"" + codegenParameter.example + "\"";
                }
                return "\"" + codegenParameter.paramName + "_example\"";
            }
            if ("Bool".equals(codegenParameter.dataType)) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if ("URL".equals(codegenParameter.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("Date".equals(codegenParameter.dataType)) {
                return "Date()";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "987";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            if (visitedModels.contains(codegenParameter.dataType)) {
                return "nil";
            }
            visitedModels.add(codegenParameter.dataType);
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, visitedModels);
        }
        return "TODO";
    }

    public String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, Set<String> visitedModels) {
        if (codegenProperty.isArray) {
            return "[" + this.constructExampleCode(codegenProperty.items, modelMaps, visitedModels) + "]";
        }
        if (codegenProperty.isMap) {
            return "\"TODO\"";
        }
        if (this.languageSpecificPrimitives.contains(codegenProperty.dataType)) {
            if ("String".equals(codegenProperty.dataType) || "Character".equals(codegenProperty.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if ("Bool".equals(codegenProperty.dataType)) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "true";
                }
                return "false";
            }
            if ("URL".equals(codegenProperty.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("Date".equals(codegenProperty.dataType)) {
                return "Date()";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "123";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            if (visitedModels.contains(codegenProperty.dataType)) {
                return "nil";
            }
            visitedModels.add(codegenProperty.dataType);
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, visitedModels);
        }
        return "\"TODO\"";
    }

    public String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, Set<String> visitedModels) {
        String example = codegenModel.name + "(";
        ArrayList<String> propertyExamples = new ArrayList<String>();
        for (CodegenProperty codegenProperty : codegenModel.vars) {
            propertyExamples.add(codegenProperty.name + ": " + this.constructExampleCode(codegenProperty, modelMaps, visitedModels));
        }
        example = example + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ");
        example = example + ")";
        return example;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# swift5 generator is contributed by Bruno Coelho (https://github.com/4brunu). #");
        System.out.println("# Please support his work directly via https://paypal.com/paypalme/4brunu \ud83d\ude4f   #");
        System.out.println("################################################################################");
    }
}

