/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpClientCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpClientCodegen.class);

    public PhpClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.importMapping.clear();
        this.setInvokerPackage("OpenAPI\\Client");
        this.setApiPackage(this.getInvokerPackage() + "\\" + this.apiDirName);
        this.setModelPackage(this.getInvokerPackage() + "\\" + this.modelDirName);
        this.setPackageName("OpenAPIClient-php");
        this.supportsInheritance = true;
        this.setOutputDir("generated-code" + File.separator + "php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.templateDir = "php";
        this.embeddedTemplateDir = "php";
        this.hideGenerationTimestamp = Boolean.TRUE;
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ApiException.php"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "Configuration.php"));
        this.supportingFiles.add(new SupportingFile("ObjectSerializer.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ObjectSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toSrcPath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("HeaderSelector.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "HeaderSelector.php"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", "", "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", "", ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
    }
}

