/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validations.oas;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.validation.Severity;
import org.openapitools.codegen.validation.Validated;
import org.openapitools.codegen.validation.ValidationResult;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validation.Validator;
import org.openapitools.codegen.validations.oas.OpenApiOperationValidations;
import org.openapitools.codegen.validations.oas.OpenApiParameterValidations;
import org.openapitools.codegen.validations.oas.OpenApiSchemaValidations;
import org.openapitools.codegen.validations.oas.OpenApiSecuritySchemeValidations;
import org.openapitools.codegen.validations.oas.OperationWrapper;
import org.openapitools.codegen.validations.oas.ParameterWrapper;
import org.openapitools.codegen.validations.oas.RuleConfiguration;
import org.openapitools.codegen.validations.oas.SchemaWrapper;
import org.openapitools.codegen.validations.oas.SecuritySchemeWrapper;

public class OpenApiEvaluator
implements Validator<OpenAPI> {
    private RuleConfiguration ruleConfiguration;

    public OpenApiEvaluator(RuleConfiguration ruleConfiguration) {
        this.ruleConfiguration = ruleConfiguration;
    }

    public ValidationResult validate(OpenAPI specification) {
        Components components;
        ValidationResult validationResult = new ValidationResult();
        if (specification == null) {
            return validationResult;
        }
        OpenApiParameterValidations parameterValidations = new OpenApiParameterValidations(this.ruleConfiguration);
        OpenApiSecuritySchemeValidations securitySchemeValidations = new OpenApiSecuritySchemeValidations(this.ruleConfiguration);
        OpenApiSchemaValidations schemaValidations = new OpenApiSchemaValidations(this.ruleConfiguration);
        OpenApiOperationValidations operationValidations = new OpenApiOperationValidations(this.ruleConfiguration);
        if (this.ruleConfiguration.isEnableUnusedSchemasRecommendation()) {
            ValidationRule unusedSchema = ValidationRule.create((Severity)Severity.WARNING, (String)"Unused schema", (String)"A schema was determined to be unused.", s -> ValidationRule.Pass.empty());
            ModelUtils.getUnusedSchemas(specification).forEach(schemaName -> validationResult.addResult(Validated.invalid((ValidationRule)unusedSchema, (String)("Unused model: " + schemaName))));
        }
        List<Schema> schemas = ModelUtils.getAllSchemas(specification);
        schemas.forEach(schema -> {
            SchemaWrapper wrapper = new SchemaWrapper(specification, (Schema)schema);
            validationResult.consume(schemaValidations.validate(wrapper));
        });
        ArrayList parameters = new ArrayList(50);
        Paths paths = specification.getPaths();
        if (paths != null) {
            paths.forEach((key, pathItem) -> {
                List pathParameters = pathItem.getParameters();
                if (pathParameters != null) {
                    parameters.addAll(pathItem.getParameters());
                }
                pathItem.readOperationsMap().forEach((httpMethod, op) -> {
                    if (op != null) {
                        if (op.getParameters() != null) {
                            parameters.addAll(op.getParameters());
                        }
                        OperationWrapper wrapper = new OperationWrapper(specification, (Operation)op, (PathItem.HttpMethod)httpMethod);
                        validationResult.consume(operationValidations.validate(wrapper));
                    }
                });
            });
        }
        if ((components = specification.getComponents()) != null) {
            Map securitySchemes = components.getSecuritySchemes();
            if (securitySchemes != null && !securitySchemes.isEmpty()) {
                securitySchemes.values().forEach(securityScheme -> {
                    SecuritySchemeWrapper wrapper = new SecuritySchemeWrapper(specification, (SecurityScheme)securityScheme);
                    validationResult.consume(securitySchemeValidations.validate(wrapper));
                });
            }
            if (components.getParameters() != null) {
                parameters.addAll(components.getParameters().values());
            }
        }
        parameters.forEach(parameter -> {
            parameter = ModelUtils.getReferencedParameter(specification, parameter);
            ParameterWrapper wrapper = new ParameterWrapper(specification, (Parameter)parameter);
            validationResult.consume(parameterValidations.validate(wrapper));
        });
        List tags = specification.getTags();
        if (tags != null && tags.size() > 1) {
            HashSet distinct = new HashSet();
            HashSet duplicated = new HashSet();
            tags.forEach(tag -> {
                if (!distinct.add(tag.getName())) {
                    duplicated.add(tag.getName());
                }
            });
            if (duplicated.size() > 0) {
                ValidationRule rule = ValidationRule.warn((String)"Duplicate tags", (String)"The specification requires that tag names are unique.", s -> ValidationRule.Fail.empty());
                validationResult.addResult(Validated.invalid((ValidationRule)rule, (String)("Duplicated tag(s): " + String.join((CharSequence)",", duplicated))));
            }
        }
        return validationResult;
    }
}

