/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonLegacyClientCodegen
extends AbstractPythonCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonLegacyClientCodegen.class);
    public static final String PACKAGE_URL = "packageUrl";
    public static final String DEFAULT_LIBRARY = "urllib3";
    public static final String USE_NOSE = "useNose";
    public static final String RECURSION_LIMIT = "recursionLimit";
    public static final String PYTHON_ATTR_NONE_IF_UNSET = "pythonAttrNoneIfUnset";
    protected String packageUrl;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean useNose = Boolean.FALSE;
    protected Map<Character, String> regexModifiers;
    private String testFolder;

    public PythonLegacyClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.modelTestTemplateFiles.put("model_test.mustache", ".py");
        this.apiTestTemplateFiles.put("api_test.mustache", ".py");
        this.templateDir = "python-legacy";
        this.embeddedTemplateDir = "python-legacy";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.testFolder = "test";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("projectName", "python project name in setup.py (e.g. petstore-api)."));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(PACKAGE_URL, "python package URL."));
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("generateSourceCodeOnly", "Specifies that only a library source code is to be generated.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(USE_NOSE, "use the nose test framework").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(RECURSION_LIMIT, "Set the recursion limit. If not set, use the system default value."));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "urllib3-based client");
        this.supportedLibraries.put("asyncio", "Asyncio-based client (python 3.5+)");
        this.supportedLibraries.put("tornado", "tornado-based client");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use: asyncio, tornado, urllib3");
        libraryOption.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(DEFAULT_LIBRARY);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.setProjectName(this.packageName.replaceAll("_", "-"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("projectName", this.projectName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = Boolean.valueOf(this.additionalProperties.get("excludeTests").toString());
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        if (generateSourceCodeOnly.booleanValue()) {
            this.testFolder = this.packagePath() + File.separatorChar + this.testFolder;
            this.apiDocPath = this.packagePath() + File.separatorChar + this.apiDocPath;
            this.modelDocPath = this.packagePath() + File.separatorChar + this.modelDocPath;
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.additionalProperties.containsKey(PACKAGE_URL)) {
            this.setPackageUrl((String)this.additionalProperties.get(PACKAGE_URL));
        }
        if (this.additionalProperties.containsKey(USE_NOSE)) {
            this.setUseNose((String)this.additionalProperties.get(USE_NOSE));
        }
        if (this.additionalProperties.containsKey(RECURSION_LIMIT)) {
            try {
                Integer.parseInt((String)this.additionalProperties.get(RECURSION_LIMIT));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new IllegalArgumentException("recursionLimit must be an integer, e.g. 2000.");
            }
        }
        String modelPath = this.packagePath() + File.separatorChar + this.modelPackage.replace('.', File.separatorChar);
        String apiPath = this.packagePath() + File.separatorChar + this.apiPackage.replace('.', File.separatorChar);
        String readmePath = "README.md";
        String readmeTemplate = "README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packagePath() + "_" + readmePath;
            readmeTemplate = "README_onlypackage.mustache";
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tox.mustache", "", "tox.ini"));
            this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("setup_cfg.mustache", "", "setup.cfg"));
            this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
            this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
            this.supportingFiles.add(new SupportingFile("gitlab-ci.mustache", "", ".gitlab-ci.yml"));
            this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
        }
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.packagePath(), "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", this.packagePath(), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", modelPath, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", apiPath, "__init__.py"));
        String[] packageNameSplits = this.packageName.split("\\.");
        String currentPackagePath = "";
        for (int i = 0; i < packageNameSplits.length - 1; ++i) {
            if (i > 0) {
                currentPackagePath = currentPackagePath + File.separatorChar;
            }
            currentPackagePath = currentPackagePath + packageNameSplits[i];
            this.supportingFiles.add(new SupportingFile("__init__.mustache", currentPackagePath, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("exceptions.mustache", this.packagePath(), "exceptions.py"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("__init__.mustache", this.testFolder, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.packagePath(), "api_client.py"));
        if ("asyncio".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("asyncio/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("asyncio", "true");
        } else if ("tornado".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("tornado/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("tornado", "true");
        } else {
            this.supportingFiles.add(new SupportingFile("rest.mustache", this.packagePath(), "rest.py"));
        }
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.apiPackage = this.packageName + "." + this.apiPackage;
    }

    @Override
    public String toModelImport(String name) {
        String modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = modelImport + this.modelPackage() + ".";
            }
            modelImport = modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python-legacy";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + "/" + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + "/" + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    public void setUseNose(String val) {
        this.useNose = Boolean.parseBoolean(val);
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String packagePath() {
        return this.packageName.replace('.', File.separatorChar);
    }

    public String generatePackageName(String packageName) {
        return StringUtils.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String generatorLanguageVersion() {
        return "2.7 and 3.4+";
    }
}

