/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ElmClientCodegen.class);
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elm";
    }

    @Override
    public String getHelp() {
        return "Generates an Elm client library.";
    }

    public ElmClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.templateDir = "elm";
        this.apiPackage = "Api.Request";
        this.modelPackage = "Api";
        this.supportsInheritance = true;
        this.reservedWords = new HashSet<String>(Arrays.asList("if", "then", "else", "case", "of", "let", "in", "type", "module", "where", "import", "exposing", "as", "port"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Order", "Never", "List", "Maybe", "Result", "Program", "Cmd", "Sub"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "Dict", "Float", "Int", "List", "String"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Dict");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("date", "Posix");
        this.typeMapping.put("DateTime", "Posix");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("UUID", "Uuid");
        this.typeMapping.put("URI", "String");
        this.importMapping.clear();
        this.cliOptions.clear();
        this.apiTemplateFiles.put("operation.mustache", ".elm");
        this.modelTemplateFiles.put("model.mustache", ".elm");
        this.supportingFiles.add(new SupportingFile("Api.mustache", "", "src" + File.separator + "Api.elm"));
        this.supportingFiles.add(new SupportingFile("Time.mustache", "", "src" + File.separator + "Api" + File.separator + "Time.elm"));
        this.supportingFiles.add(new SupportingFile("elm.mustache", "", "elm.json"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"removeWhitespace", (Object)new RemoveWhitespaceLambda());
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        return operationId;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = StringUtils.camelize(name);
        return this.defaultIncludes.contains(modelName) ? modelName + "_" : modelName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.toModelName(property.name);
    }

    @Override
    public String toVarName(String name) {
        String varName = StringUtils.camelize(name.replaceAll("[^a-zA-Z0-9_]", ""), CamelizeOption.LOWERCASE_FIRST_LETTER);
        return this.isReservedWord(varName) ? this.escapeReservedWord(name) : varName;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String camelized = StringUtils.camelize(value.replace(" ", "_").replace("(", "_").replace(")", ""));
        if (camelized.length() == 0) {
            this.LOGGER.error("Unable to determine enum variable name (name: {}, datatype: {}) from empty string. Default to UnknownEnumVariableName", (Object)value, (Object)datatype);
            camelized = "UnknownEnumVariableName";
        }
        return camelized;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + " " + inner;
        }
        return null;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (property.getAllowableValues() != null && !property.getAllowableValues().isEmpty()) {
            property.isModel = true;
        }
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> orgObjs) {
        Map<String, ModelsMap> objs = super.postProcessAllModels(orgObjs);
        HashMap<String, ModelsMap> objects = new HashMap<String, ModelsMap>();
        ModelsMap dataObj = objs.values().stream().findFirst().orElse(new ModelsMap());
        List<ModelMap> models = objs.values().stream().flatMap(obj -> obj.getModels().stream()).flatMap(obj -> {
            CodegenModel model = obj.getModel();
            model.vars.forEach(var -> {
                var.isCircularReference = model.allVars.stream().filter(v -> var.baseName.equals(v.baseName)).map(v -> v.isCircularReference).findAny().orElse(false);
                CodegenProperty items = var.items;
                while (items != null) {
                    items.isCircularReference = var.isCircularReference;
                    items.required = true;
                    items = items.items;
                }
            });
            if (model.discriminator != null && model.getChildren() != null) {
                model.getChildren().forEach(child -> {
                    child.allOf = child.allOf.stream().map(v -> model.classname.equals(v) ? "Base" + v : v).collect(Collectors.toSet());
                });
            }
            if (model.classname.endsWith("AllOf")) {
                return Stream.empty();
            }
            model.allOf.removeIf(name -> name.endsWith("AllOf"));
            return Stream.of(obj);
        }).collect(Collectors.toList());
        boolean includeTime = this.anyVarMatches(models, prop -> prop.isDate || prop.isDateTime);
        boolean includeUuid = this.anyVarMatches(models, prop -> prop.isUuid);
        dataObj.setModels(models);
        dataObj.put("includeTime", includeTime);
        dataObj.put("includeUuid", includeUuid);
        objects.put("Data", dataObj);
        return objects;
    }

    private boolean anyVarMatches(List<ModelMap> models, Predicate<CodegenProperty> predicate) {
        return models.stream().map(ModelMap::getModel).flatMap(model -> model.vars.stream()).anyMatch(var -> {
            CodegenProperty prop = var;
            while (prop != null) {
                if (predicate.test(prop)) {
                    return true;
                }
                prop = prop.items;
            }
            return false;
        });
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    private static boolean anyOperationParam(List<CodegenOperation> operations, Predicate<CodegenParameter> predicate) {
        return operations.stream().flatMap(operation -> operation.allParams.stream()).anyMatch(predicate);
    }

    private static boolean anyOperationResponse(List<CodegenOperation> operations, Predicate<CodegenResponse> predicate) {
        return operations.stream().flatMap(operation -> operation.responses.stream()).anyMatch(predicate);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> allModels) {
        OperationMap objs = operations.getOperations();
        List<CodegenOperation> ops = objs.getOperation();
        ops.forEach(op -> {
            op.allParams = op.allParams.stream().sorted(new ParameterSorter()).collect(Collectors.toList());
            op.responses.forEach(response -> {
                if (response.isDefault) {
                    response.isModel = !response.primitiveType;
                }
            });
        });
        boolean includeTime = ElmClientCodegen.anyOperationResponse(ops, response -> response.isDate || response.isDateTime) || ElmClientCodegen.anyOperationParam(ops, param -> param.isDate || param.isDateTime);
        boolean includeUuid = ElmClientCodegen.anyOperationResponse(ops, response -> response.isUuid) || ElmClientCodegen.anyOperationParam(ops, param -> param.isUuid);
        operations.put("includeTime", includeTime);
        operations.put("includeUuid", includeUuid);
        return operations;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return Boolean.parseBoolean(p.getDefault().toString()) ? "True" : "False";
            }
        } else if (ModelUtils.isNumberSchema(p) ? p.getDefault() != null : ModelUtils.isIntegerSchema(p) && p.getDefault() != null) {
            return p.getDefault().toString();
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.ELM;
    }

    private static class RemoveWhitespaceLambda
    implements Mustache.Lambda {
        private RemoveWhitespaceLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll("\\s+", ""));
        }
    }

    static class ParameterSorter
    implements Comparator<CodegenParameter> {
        ParameterSorter() {
        }

        @Override
        public int compare(CodegenParameter p1, CodegenParameter p2) {
            return this.index(p1) - this.index(p2);
        }

        private int index(CodegenParameter p) {
            if (p.isPathParam) {
                return 1;
            }
            if (p.isQueryParam) {
                return 2;
            }
            if (p.isHeaderParam) {
                return 3;
            }
            if (p.isBodyParam) {
                return 4;
            }
            return 5;
        }
    }
}

