/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.PathFileComparator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenServer;
import org.openapitools.codegen.DryRunStatus;
import org.openapitools.codegen.DryRunTemplateManager;
import org.openapitools.codegen.Generator;
import org.openapitools.codegen.InlineModelResolver;
import org.openapitools.codegen.OpenAPINormalizer;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.TemplateManager;
import org.openapitools.codegen.api.TemplateDefinition;
import org.openapitools.codegen.api.TemplateFileType;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.ignore.CodegenIgnoreProcessor;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ApiInfoMap;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.openapitools.codegen.templating.CommonTemplateContentLocator;
import org.openapitools.codegen.templating.GeneratorTemplateContentLocator;
import org.openapitools.codegen.templating.MustacheEngineAdapter;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.openapitools.codegen.utils.ImplementationVersion;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.SemVer;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
implements Generator {
    private static final String METADATA_DIR = ".openapi-generator";
    protected final Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    private final boolean dryRun;
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected OpenAPI openAPI;
    protected CodegenIgnoreProcessor ignoreProcessor;
    private Boolean generateApis = null;
    private Boolean generateModels = null;
    private Boolean generateSupportingFiles = null;
    private Boolean generateApiTests = null;
    private Boolean generateApiDocumentation = null;
    private Boolean generateModelTests = null;
    private Boolean generateModelDocumentation = null;
    private Boolean generateMetadata = true;
    private String basePath;
    private String basePathWithoutHost;
    private String contextPath;
    private Map<String, String> generatorPropertyDefaults = new HashMap<String, String>();
    protected TemplateProcessor templateProcessor = null;
    private List<TemplateDefinition> userDefinedTemplates = new ArrayList<TemplateDefinition>();

    public DefaultGenerator() {
        this(false);
    }

    public DefaultGenerator(Boolean dryRun) {
        this.dryRun = Boolean.TRUE.equals(dryRun);
        this.LOGGER.info("Generating with dryRun={}", (Object)this.dryRun);
    }

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.openAPI = opts.getOpenAPI();
        this.config = opts.getConfig();
        List<TemplateDefinition> userFiles = opts.getUserDefinedTemplates();
        if (userFiles != null) {
            this.userDefinedTemplates = Collections.unmodifiableList(userFiles);
        }
        TemplateManagerOptions templateManagerOptions = new TemplateManagerOptions(this.config.isEnableMinimalUpdate(), this.config.isSkipOverwrite());
        if (this.dryRun) {
            this.templateProcessor = new DryRunTemplateManager(templateManagerOptions);
        } else {
            TemplatingEngineAdapter templatingEngine = this.config.getTemplatingEngine();
            if (templatingEngine instanceof MustacheEngineAdapter) {
                MustacheEngineAdapter mustacheEngineAdapter = (MustacheEngineAdapter)templatingEngine;
                mustacheEngineAdapter.setCompiler(this.config.processCompiler(mustacheEngineAdapter.getCompiler()));
            }
            CommonTemplateContentLocator commonTemplateLocator = new CommonTemplateContentLocator();
            GeneratorTemplateContentLocator generatorTemplateLocator = new GeneratorTemplateContentLocator(this.config);
            this.templateProcessor = new TemplateManager(templateManagerOptions, templatingEngine, new TemplatePathLocator[]{generatorTemplateLocator, commonTemplateLocator});
        }
        String ignoreFileLocation = this.config.getIgnoreFilePathOverride();
        if (ignoreFileLocation != null) {
            File ignoreFile = new File(ignoreFileLocation);
            if (ignoreFile.exists() && ignoreFile.canRead()) {
                this.ignoreProcessor = new CodegenIgnoreProcessor(ignoreFile);
            } else {
                this.LOGGER.warn("Ignore file specified at {} is not valid. This will fall back to an existing ignore file if present in the output directory.", (Object)ignoreFileLocation);
            }
        }
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        }
        return this;
    }

    public TemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public void setGenerateMetadata(Boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public void setGeneratorPropertyDefault(String key, String value) {
        this.generatorPropertyDefaults.put(key, value);
    }

    private Boolean getGeneratorPropertyDefaultSwitch(String key, Boolean defaultValue) {
        String result = null;
        if (this.generatorPropertyDefaults.containsKey(key)) {
            result = this.generatorPropertyDefaults.get(key);
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return defaultValue;
    }

    void configureGeneratorProperties() {
        this.generateApis = GlobalSettings.getProperty("apis") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("apis", null);
        this.generateModels = GlobalSettings.getProperty("models") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("models", null);
        Boolean bl = this.generateSupportingFiles = GlobalSettings.getProperty("supportingFiles") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("supportingFiles", null);
        if (this.generateApis == null && this.generateModels == null && this.generateSupportingFiles == null) {
            this.generateModels = this.generateSupportingFiles = Boolean.valueOf(true);
            this.generateApis = this.generateSupportingFiles;
        } else {
            if (this.generateApis == null) {
                this.generateApis = false;
            }
            if (this.generateModels == null) {
                this.generateModels = false;
            }
            if (this.generateSupportingFiles == null) {
                this.generateSupportingFiles = false;
            }
        }
        this.generateModelTests = GlobalSettings.getProperty("modelTests") != null ? Boolean.valueOf(GlobalSettings.getProperty("modelTests")) : this.getGeneratorPropertyDefaultSwitch("modelTests", true);
        this.generateModelDocumentation = GlobalSettings.getProperty("modelDocs") != null ? Boolean.valueOf(GlobalSettings.getProperty("modelDocs")) : this.getGeneratorPropertyDefaultSwitch("modelDocs", true);
        this.generateApiTests = GlobalSettings.getProperty("apiTests") != null ? Boolean.valueOf(GlobalSettings.getProperty("apiTests")) : this.getGeneratorPropertyDefaultSwitch("apiTests", true);
        this.generateApiDocumentation = GlobalSettings.getProperty("apiDocs") != null ? Boolean.valueOf(GlobalSettings.getProperty("apiDocs")) : this.getGeneratorPropertyDefaultSwitch("apiDocs", true);
        this.config.additionalProperties().put("generateApiTests", this.generateApiTests);
        this.config.additionalProperties().put("generateModelTests", this.generateModelTests);
        this.config.additionalProperties().put("generateApiDocs", this.generateApiDocumentation);
        this.config.additionalProperties().put("generateModelDocs", this.generateModelDocumentation);
        this.config.additionalProperties().put("generateApis", this.generateApis);
        this.config.additionalProperties().put("generateModels", this.generateModels);
        if (!this.generateApiTests.booleanValue() && !this.generateModelTests.booleanValue()) {
            this.config.additionalProperties().put("excludeTests", true);
        }
        if (GlobalSettings.getProperty("debugOpenAPI") != null) {
            System.out.println(SerializerUtils.toJsonString(this.openAPI));
        } else if (GlobalSettings.getProperty("debugSwagger") != null) {
            this.LOGGER.info("Please use system property 'debugOpenAPI' instead of 'debugSwagger'.");
            System.out.println(SerializerUtils.toJsonString(this.openAPI));
        }
        this.config.processOpts();
        if (this.opts != null && this.opts.getGeneratorSettings() != null) {
            this.config.typeMapping().putAll(this.opts.getGeneratorSettings().getTypeMappings());
            this.config.importMapping().putAll(this.opts.getGeneratorSettings().getImportMappings());
        }
        try {
            if (this.config.getUseOpenAPINormalizer()) {
                SemVer version = new SemVer(this.openAPI.getOpenapi());
                if (version.atLeast("3.1.0")) {
                    this.config.openapiNormalizer().put("NORMALIZE_31SPEC", "true");
                }
                OpenAPINormalizer openapiNormalizer = new OpenAPINormalizer(this.openAPI, this.config.openapiNormalizer());
                openapiNormalizer.normalize();
            }
        }
        catch (Exception e) {
            this.LOGGER.error("An exception occurred in OpenAPI Normalizer. Please report the issue via https://github.com/openapitools/openapi-generator/issues/new/: ");
            e.printStackTrace();
        }
        if (this.config.getUseInlineModelResolver()) {
            InlineModelResolver inlineModelResolver = new InlineModelResolver();
            inlineModelResolver.setInlineSchemaNameMapping(this.config.inlineSchemaNameMapping());
            inlineModelResolver.setInlineSchemaOptions(this.config.inlineSchemaOption());
            inlineModelResolver.flatten(this.openAPI);
        }
        this.config.preprocessOpenAPI(this.openAPI);
        this.config.setOpenAPI(this.openAPI);
        this.config.additionalProperties().put("generatorVersion", ImplementationVersion.read());
        this.config.additionalProperties().put("generatedDate", ZonedDateTime.now().toString());
        this.config.additionalProperties().put("generatedYear", String.valueOf(ZonedDateTime.now().getYear()));
        this.config.additionalProperties().put("generatorClass", this.config.getClass().getName());
        this.config.additionalProperties().put("inputSpec", this.config.getInputSpec());
        if (this.openAPI.getExtensions() != null) {
            this.config.vendorExtensions().putAll(this.openAPI.getExtensions());
        }
        URL url = URLPathUtils.getServerURL(this.openAPI, this.config.serverVariableOverrides());
        this.basePathWithoutHost = this.contextPath = this.removeTrailingSlash(this.config.escapeText(url.getPath()));
        this.basePath = URLPathUtils.isRelativeUrl(this.openAPI.getServers()) ? this.removeTrailingSlash(this.basePathWithoutHost) : this.removeTrailingSlash(this.config.escapeText(URLPathUtils.getHost(this.openAPI, this.config.serverVariableOverrides())));
    }

    private void configureOpenAPIInfo() {
        Info info = this.openAPI.getInfo();
        if (info == null) {
            return;
        }
        if (info.getTitle() != null) {
            this.config.additionalProperties().put("appName", this.config.escapeText(info.getTitle()));
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("appVersion", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default appVersion set to 1.0.0");
            this.config.additionalProperties().put("appVersion", "1.0.0");
        }
        if (StringUtils.isEmpty((CharSequence)info.getDescription())) {
            this.config.additionalProperties().put("appDescription", "No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)");
            this.config.additionalProperties().put("appDescriptionWithNewLines", this.config.additionalProperties().get("appDescription"));
            this.config.additionalProperties().put("unescapedAppDescription", "No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)");
        } else {
            this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            this.config.additionalProperties().put("appDescriptionWithNewLines", this.config.escapeTextWhileAllowingNewLines(info.getDescription()));
            this.config.additionalProperties().put("unescapedAppDescription", info.getDescription());
        }
        if (info.getContact() != null) {
            Contact contact = info.getContact();
            if (contact.getEmail() != null) {
                this.config.additionalProperties().put("infoEmail", this.config.escapeText(contact.getEmail()));
            }
            if (contact.getName() != null) {
                this.config.additionalProperties().put("infoName", this.config.escapeText(contact.getName()));
            }
            if (contact.getUrl() != null) {
                this.config.additionalProperties().put("infoUrl", this.config.escapeText(contact.getUrl()));
            }
        }
        if (info.getLicense() != null) {
            License license = info.getLicense();
            if (license.getName() != null) {
                this.config.additionalProperties().put("licenseInfo", this.config.escapeText(license.getName()));
            }
            if (license.getUrl() != null) {
                this.config.additionalProperties().put("licenseUrl", this.config.escapeText(license.getUrl()));
            }
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("version", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default version set to 1.0.0");
            this.config.additionalProperties().put("version", "1.0.0");
        }
        if (info.getTermsOfService() != null) {
            this.config.additionalProperties().put("termsOfService", this.config.escapeText(info.getTermsOfService()));
        }
    }

    private void generateModelTests(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (Map.Entry<String, String> configModelTestTemplateFilesEntry : this.config.modelTestTemplateFiles().entrySet()) {
            String templateName = configModelTestTemplateFilesEntry.getKey();
            String suffix = configModelTestTemplateFilesEntry.getValue();
            String filename = this.config.modelTestFileFolder() + File.separator + this.config.toModelTestFilename(modelName) + suffix;
            if (this.generateModelTests.booleanValue()) {
                File modelTestFile = new File(filename);
                if (modelTestFile.exists()) {
                    this.templateProcessor.skip(modelTestFile.toPath(), "Test files never overwrite an existing file of the same name.");
                    continue;
                }
                File written = this.processTemplateToFile(models, templateName, filename, this.generateModelTests, "modelTests", this.config.modelTestFileFolder());
                if (written == null) continue;
                files.add(written);
                if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
                this.config.postProcessFile(written, "model-test");
                continue;
            }
            if (!this.dryRun) continue;
            Path skippedPath = Paths.get(filename, new String[0]);
            this.templateProcessor.skip(skippedPath, "Skipped by modelTests option supplied by user.");
        }
    }

    private void generateModelDocumentation(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelDocTemplateFiles().keySet()) {
            String suffix;
            String docExtension = this.config.getDocExtension();
            String string = suffix = docExtension != null ? docExtension : this.config.modelDocTemplateFiles().get(templateName);
            String filename = this.config.modelDocFileFolder() + File.separator + this.config.toModelDocFilename(modelName) + suffix;
            File written = this.processTemplateToFile(models, templateName, filename, this.generateModelDocumentation, "modelDocs");
            if (written == null) continue;
            files.add(written);
            if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
            this.config.postProcessFile(written, "model-doc");
        }
    }

    private void generateModel(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelTemplateFiles().keySet()) {
            String filename;
            File written = this.processTemplateToFile(models, templateName, filename = this.config.modelFilename(templateName, modelName), this.generateModels, "models");
            if (written == null) continue;
            files.add(written);
            if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
            this.config.postProcessFile(written, "model");
        }
    }

    void generateModels(List<File> files, List<ModelMap> allModels, List<String> unusedModels) {
        if (!this.generateModels.booleanValue()) {
            this.LOGGER.info("Skipping generation of models.");
            return;
        }
        Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
        if (schemas == null) {
            this.LOGGER.warn("Skipping generation of models because specification document has no schemas.");
            return;
        }
        String modelNames = GlobalSettings.getProperty("models");
        HashSet<String> modelsToGenerate = null;
        if (modelNames != null && !modelNames.isEmpty()) {
            modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
        }
        Set<String> modelKeys = schemas.keySet();
        if (modelsToGenerate != null && !modelsToGenerate.isEmpty()) {
            HashSet<String> updatedKeys = new HashSet<String>();
            for (String m : modelKeys) {
                if (!modelsToGenerate.contains(m)) continue;
                updatedKeys.add(m);
            }
            modelKeys = updatedKeys;
        }
        Map<String, ModelsMap> allProcessedModels = new TreeMap<String, ModelsMap>((o1, o2) -> ObjectUtils.compare((Comparable)((Object)this.config.toModelName((String)o1)), (Comparable)((Object)this.config.toModelName((String)o2))));
        Boolean skipFormModel = GlobalSettings.getProperty("skipFormModel") != null ? Boolean.valueOf(GlobalSettings.getProperty("skipFormModel")) : this.getGeneratorPropertyDefaultSwitch("skipFormModel", true);
        for (String name : modelKeys) {
            try {
                Schema schema;
                if (this.config.schemaMapping().containsKey(name)) {
                    this.LOGGER.debug("Model {} not imported due to import mapping", (Object)name);
                    for (String templateName : this.config.modelTemplateFiles().keySet()) {
                        String filename = this.config.modelFilename(templateName, name);
                        Path path = Paths.get(filename, new String[0]);
                        this.templateProcessor.skip(path, "Skipped prior to model processing due to schema mapping.");
                    }
                    continue;
                }
                if (unusedModels.contains(name)) {
                    if (Boolean.FALSE.equals(skipFormModel)) {
                        this.LOGGER.info("Model {} (marked as unused due to form parameters) is generated due to the global property `skipFormModel` set to false", (Object)name);
                    } else {
                        this.LOGGER.info("Model {} not generated since it's marked as unused (due to form parameters) and `skipFormModel` (global property) set to true (default)", (Object)name);
                        continue;
                    }
                }
                if (ModelUtils.isFreeFormObject(schema = schemas.get(name))) {
                    Schema refSchema = new Schema();
                    refSchema.set$ref("#/components/schemas/" + name);
                    Schema unaliasedSchema = this.config.unaliasSchema(refSchema);
                    if (unaliasedSchema.get$ref() == null) {
                        this.LOGGER.info("Model {} not generated since it's a free-form object", (Object)name);
                        continue;
                    }
                } else if (ModelUtils.isMapSchema(schema)) {
                    if (!(ModelUtils.isGenerateAliasAsModel(schema) || ModelUtils.isComposedSchema(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty())) {
                        this.LOGGER.info("Model {} not generated since it's an alias to map (without property) and `generateAliasAsModel` is set to false (default)", (Object)name);
                        continue;
                    }
                } else if (ModelUtils.isArraySchema(schema) && !ModelUtils.isGenerateAliasAsModel(schema) && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
                    this.LOGGER.info("Model {} not generated since it's an alias to array (without property) and `generateAliasAsModel` is set to false (default)", (Object)name);
                    continue;
                }
                HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
                schemaMap.put(name, schema);
                ModelsMap models = this.processModels(this.config, schemaMap);
                models.put("classname", this.config.toModelName(name));
                models.putAll(this.config.additionalProperties());
                allProcessedModels.put(name, models);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not process model '" + name + "'.Please make sure that your schema is correct!", e);
            }
        }
        allProcessedModels = this.config.updateAllModels(allProcessedModels);
        allProcessedModels = this.config.postProcessAllModels(allProcessedModels);
        for (String modelName : allProcessedModels.keySet()) {
            ModelsMap models = allProcessedModels.get(modelName);
            models.put("modelPackage", this.config.modelPackage());
            try {
                if (this.config.schemaMapping().containsKey(modelName)) continue;
                List<ModelMap> modelList = models.getModels();
                if (modelList != null && !modelList.isEmpty()) {
                    ModelMap modelTemplate = modelList.get(0);
                    if (modelTemplate != null && modelTemplate.getModel() != null) {
                        CodegenModel m = modelTemplate.getModel();
                        if (m.isAlias) continue;
                    }
                    allModels.add(modelTemplate);
                }
                this.generateModel(files, models, modelName);
                this.generateModelTests(files, models, modelName);
                this.generateModelDocumentation(files, models, modelName);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate model '" + modelName + "'", e);
            }
        }
        if (GlobalSettings.getProperty("debugModels") != null) {
            this.LOGGER.info("############ Model info ############");
            Json.prettyPrint(allModels);
        }
    }

    void generateApis(List<File> files, List<OperationsMap> allOperations, List<ModelMap> allModels) {
        if (!this.generateApis.booleanValue()) {
            this.LOGGER.info("Skipping generation of APIs.");
            return;
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.openAPI.getPaths());
        HashSet<String> apisToGenerate = null;
        String apiNames = GlobalSettings.getProperty("apis");
        if (apiNames != null && !apiNames.isEmpty()) {
            apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
        }
        if (apisToGenerate != null && !apisToGenerate.isEmpty()) {
            TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
            for (String m : paths.keySet()) {
                if (!apisToGenerate.contains(m)) continue;
                updatedPaths.put(m, paths.get(m));
            }
            paths = updatedPaths;
        }
        for (String tag : paths.keySet()) {
            try {
                File written;
                String filename;
                List<CodegenOperation> ops = paths.get(tag);
                ops.sort((one, another) -> ObjectUtils.compare((Comparable)((Object)one.operationId), (Comparable)((Object)another.operationId)));
                OperationsMap operation = this.processOperations(this.config, tag, ops, allModels);
                URL url = URLPathUtils.getServerURL(this.openAPI, this.config.serverVariableOverrides());
                operation.put("basePath", this.basePath);
                operation.put("basePathWithoutHost", this.removeTrailingSlash(this.config.encodePath(url.getPath())));
                operation.put("contextPath", this.contextPath);
                operation.put("baseName", tag);
                Optional.ofNullable(this.openAPI.getTags()).orElseGet(Collections::emptyList).stream().map(Tag::getName).filter(Objects::nonNull).filter(tag::equalsIgnoreCase).findFirst().ifPresent(tagName -> operation.put("operationTagName", this.config.escapeText((String)tagName)));
                operation.put("operationTagDescription", "");
                Optional.ofNullable(this.openAPI.getTags()).orElseGet(Collections::emptyList).stream().filter(t -> tag.equalsIgnoreCase(t.getName())).map(Tag::getDescription).filter(Objects::nonNull).findFirst().ifPresent(description -> operation.put("operationTagDescription", this.config.escapeText((String)description)));
                Optional.ofNullable(this.config.additionalProperties().get("appVersion")).ifPresent(version -> operation.put("version", version));
                operation.put("apiPackage", this.config.apiPackage());
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                operation.put("importPath", this.config.toApiImport(tag));
                operation.put("classFilename", this.config.toApiFilename(tag));
                operation.put("strictSpecBehavior", this.config.isStrictSpecBehavior());
                Optional.ofNullable(this.openAPI.getInfo()).map(Info::getLicense).ifPresent(license -> operation.put("license", license));
                Optional.ofNullable(this.openAPI.getInfo()).map(Info::getContact).ifPresent(contact -> operation.put("contact", contact));
                if (allModels == null || allModels.isEmpty()) {
                    operation.put("hasModel", false);
                } else {
                    operation.put("hasModel", true);
                }
                if (!this.config.vendorExtensions().isEmpty()) {
                    operation.put("vendorExtensions", this.config.vendorExtensions());
                }
                if (this.config.vendorExtensions().containsKey("x-group-parameters")) {
                    boolean isGroupParameters = Boolean.parseBoolean(this.config.vendorExtensions().get("x-group-parameters").toString());
                    OperationMap objectMap = operation.getOperations();
                    List<CodegenOperation> operations = objectMap.getOperation();
                    for (CodegenOperation op : operations) {
                        if (!isGroupParameters || op.vendorExtensions.containsKey("x-group-parameters")) continue;
                        op.vendorExtensions.put("x-group-parameters", Boolean.TRUE);
                    }
                }
                boolean sortParamsByRequiredFlag = true;
                if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                    sortParamsByRequiredFlag = Boolean.parseBoolean(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                }
                operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                allOperations.add(operation);
                this.addAuthenticationSwitches(operation);
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    written = this.processTemplateToFile(operation, templateName, filename = this.config.apiFilename(templateName, tag), this.generateApis, "apis");
                    if (written == null) continue;
                    files.add(written);
                    if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
                    this.config.postProcessFile(written, "api");
                }
                for (String templateName : this.config.apiTestTemplateFiles().keySet()) {
                    filename = this.config.apiTestFilename(templateName, tag);
                    File apiTestFile = new File(filename);
                    if (apiTestFile.exists()) {
                        this.templateProcessor.skip(apiTestFile.toPath(), "Test files never overwrite an existing file of the same name.");
                        continue;
                    }
                    File written2 = this.processTemplateToFile(operation, templateName, filename, this.generateApiTests, "apiTests", this.config.apiTestFileFolder());
                    if (written2 == null) continue;
                    files.add(written2);
                    if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
                    this.config.postProcessFile(written2, "api-test");
                }
                for (String templateName : this.config.apiDocTemplateFiles().keySet()) {
                    written = this.processTemplateToFile(operation, templateName, filename = this.config.apiDocFilename(templateName, tag), this.generateApiDocumentation, "apiDocs");
                    if (written == null) continue;
                    files.add(written);
                    if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
                    this.config.postProcessFile(written, "api-doc");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
            }
        }
        if (GlobalSettings.getProperty("debugOperations") != null) {
            this.LOGGER.info("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateSupportingFiles(List<File> files, Map<String, Object> bundle) {
        if (!this.generateSupportingFiles.booleanValue()) {
            this.LOGGER.info("Skipping generation of supporting files.");
            return;
        }
        supportingFilesToGenerate = null;
        supportingFiles = GlobalSettings.getProperty("supportingFiles");
        if (supportingFiles != null && !supportingFiles.isEmpty()) {
            supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
        }
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                outputFolder = this.config.outputFolder();
                if (StringUtils.isNotEmpty((CharSequence)support.getFolder())) {
                    outputFolder = (String)outputFolder + File.separator + support.getFolder();
                }
                of = new File((String)outputFolder);
                v0 = outputFilename = new File(support.getDestinationFilename()).isAbsolute() != false ? support.getDestinationFilename() : (String)outputFolder + File.separator + support.getDestinationFilename().replace('/', File.separatorChar);
                if (!of.isDirectory() && !this.dryRun && this.ignoreProcessor.allowsFile(new File(outputFilename)) && !of.mkdirs()) {
                    OnceLogger.once(this.LOGGER).debug("Output directory {} not created. It {}.", outputFolder, (Object)(of.exists() != false ? "already exists." : "may not have appropriate permissions."));
                }
                shouldGenerate = true;
                if (supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
                    shouldGenerate = supportingFilesToGenerate.contains(support.getDestinationFilename());
                }
                if ((written = this.processTemplateToFile(bundle, support.getTemplateFile(), outputFilename, shouldGenerate, "supportingFiles")) == null) continue;
                files.add(written);
                if (!this.config.isEnablePostProcessFile() || this.dryRun) continue;
                this.config.postProcessFile(written, "supporting-file");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
            }
        }
        openapiGeneratorIgnore = ".openapi-generator-ignore";
        ignoreFileNameTarget = this.config.outputFolder() + File.separator + ".openapi-generator-ignore";
        ignoreFile = new File(ignoreFileNameTarget);
        if (this.generateMetadata.booleanValue()) {
            try {
                v1 = shouldGenerate = ignoreFile.exists() == false;
                if (shouldGenerate && supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
                    shouldGenerate = supportingFilesToGenerate.contains(".openapi-generator-ignore");
                }
                if ((written = this.processTemplateToFile(bundle, ".openapi-generator-ignore", ignoreFileNameTarget, shouldGenerate, "supportingFiles")) == null) ** GOTO lbl45
                files.add(written);
                if (!this.config.isEnablePostProcessFile() || this.dryRun) ** GOTO lbl45
                this.config.postProcessFile(written, "openapi-generator-ignore");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate supporting file '" + ignoreFileNameTarget + "'", e);
            }
        } else {
            this.templateProcessor.skip(ignoreFile.toPath(), "Skipped by generateMetadata option supplied by user.");
        }
lbl45:
        // 4 sources

        this.generateVersionMetadata(files);
    }

    Map<String, Object> buildSupportFileBundle(List<OperationsMap> allOperations, List<ModelMap> allModels) {
        HashMap<String, Object> bundle = new HashMap<String, Object>(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        ApiInfoMap apis = new ApiInfoMap();
        apis.setApis(allOperations);
        URL url = URLPathUtils.getServerURL(this.openAPI, this.config.serverVariableOverrides());
        bundle.put("openAPI", this.openAPI);
        bundle.put("basePath", this.basePath);
        bundle.put("basePathWithoutHost", this.basePathWithoutHost);
        bundle.put("scheme", URLPathUtils.getScheme(url, this.config));
        bundle.put("host", url.getHost());
        if (url.getPort() != 80 && url.getPort() != 443 && url.getPort() != -1) {
            bundle.put("port", url.getPort());
        }
        bundle.put("contextPath", this.contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        bundle.put("library", this.config.getLibrary());
        bundle.put("generatorLanguageVersion", this.config.generatorLanguageVersion());
        this.addAuthenticationSwitches(bundle);
        List<CodegenServer> servers = this.config.fromServers(this.openAPI.getServers());
        if (servers != null && !servers.isEmpty()) {
            servers.forEach(server -> {
                server.url = this.removeTrailingSlash(server.url);
            });
            bundle.put("servers", servers);
            bundle.put("hasServers", true);
        }
        boolean hasOperationServers = allOperations != null && allOperations.stream().flatMap(om -> om.getOperations().getOperation().stream()).anyMatch(o -> o.servers != null && !o.servers.isEmpty());
        bundle.put("hasOperationServers", hasOperationServers);
        if (this.openAPI.getExternalDocs() != null) {
            bundle.put("externalDocs", this.openAPI.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            CodegenModel m = allModels.get(i).getModel();
            m.hasMoreModels = true;
        }
        this.config.postProcessSupportingFileData(bundle);
        if (GlobalSettings.getProperty("debugSupportingFiles") != null) {
            this.LOGGER.info("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        return bundle;
    }

    void addAuthenticationSwitches(Map<String, Object> bundle) {
        Map securitySchemeMap = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List<CodegenSecurity> authMethods = this.config.fromSecurity(securitySchemeMap);
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
            if (ProcessUtils.hasOAuthMethods(authMethods)) {
                bundle.put("hasOAuthMethods", true);
                bundle.put("oauthMethods", ProcessUtils.getOAuthMethods(authMethods));
            }
            if (ProcessUtils.hasOpenIdConnectMethods(authMethods)) {
                bundle.put("hasOpenIdConnectMethods", true);
                bundle.put("openIdConnectMethods", ProcessUtils.getOpenIdConnectMethods(authMethods));
            }
            if (ProcessUtils.hasHttpBearerMethods(authMethods)) {
                bundle.put("hasHttpBearerMethods", true);
                bundle.put("httpBearerMethods", ProcessUtils.getHttpBearerMethods(authMethods));
            }
            if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
                bundle.put("hasHttpSignatureMethods", true);
                bundle.put("httpSignatureMethods", ProcessUtils.getHttpSignatureMethods(authMethods));
            }
            if (ProcessUtils.hasHttpBasicMethods(authMethods)) {
                bundle.put("hasHttpBasicMethods", true);
                bundle.put("httpBasicMethods", ProcessUtils.getHttpBasicMethods(authMethods));
            }
            if (ProcessUtils.hasApiKeyMethods(authMethods)) {
                bundle.put("hasApiKeyMethods", true);
                bundle.put("apiKeyMethods", ProcessUtils.getApiKeyMethods(authMethods));
            }
        }
    }

    @Override
    public List<File> generate() {
        if (this.openAPI == null) {
            throw new RuntimeException("Issues with the OpenAPI input. Possible causes: invalid/missing spec, malformed JSON/YAML files, etc.");
        }
        if (this.config == null) {
            throw new RuntimeException("missing config!");
        }
        if (this.config.getGeneratorMetadata() == null) {
            this.LOGGER.warn("Generator '{}' is missing generator metadata!", (Object)this.config.getName());
        } else {
            GeneratorMetadata generatorMetadata = this.config.getGeneratorMetadata();
            if (StringUtils.isNotEmpty((CharSequence)generatorMetadata.getGenerationMessage())) {
                this.LOGGER.info(generatorMetadata.getGenerationMessage());
            }
            Stability stability = generatorMetadata.getStability();
            String stabilityMessage = String.format(Locale.ROOT, "Generator '%s' is considered %s.", this.config.getName(), stability.value());
            if (stability == Stability.DEPRECATED) {
                this.LOGGER.warn(stabilityMessage);
            } else {
                this.LOGGER.info(stabilityMessage);
            }
        }
        this.configureGeneratorProperties();
        this.configureOpenAPIInfo();
        this.config.processOpenAPI(this.openAPI);
        this.processUserDefinedTemplates();
        ArrayList<File> files = new ArrayList<File>();
        List<String> filteredSchemas = ModelUtils.getSchemasUsedOnlyInFormParam(this.openAPI);
        ArrayList<ModelMap> allModels = new ArrayList<ModelMap>();
        this.generateModels(files, allModels, filteredSchemas);
        ArrayList<OperationsMap> allOperations = new ArrayList<OperationsMap>();
        this.generateApis(files, allOperations, allModels);
        Map<String, Object> bundle = this.buildSupportFileBundle(allOperations, allModels);
        this.generateSupportingFiles(files, bundle);
        if (this.dryRun) {
            boolean verbose = Boolean.parseBoolean(GlobalSettings.getProperty("verbose"));
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            sb.append("Dry Run Results:");
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            Map<String, DryRunStatus> dryRunStatusMap = ((DryRunTemplateManager)this.templateProcessor).getDryRunStatusMap();
            dryRunStatusMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                DryRunStatus status = (DryRunStatus)entry.getValue();
                try {
                    status.appendTo(sb);
                    sb.append(System.lineSeparator());
                    if (verbose) {
                        sb.append("  ").append(StringUtils.rightPad((String)status.getState().getDescription(), (int)20, (String)".")).append(" ").append(status.getReason()).append(System.lineSeparator());
                    }
                }
                catch (IOException e) {
                    this.LOGGER.debug("Unable to document dry run status for {}.", entry.getKey());
                }
            });
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            sb.append("States:");
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            for (DryRunStatus.State state : DryRunStatus.State.values()) {
                sb.append("  - ").append(state.getShortDisplay()).append(" ").append(state.getDescription()).append(System.lineSeparator());
            }
            sb.append(System.lineSeparator());
            this.LOGGER.error(sb.toString());
        } else if (this.generateSupportingFiles.booleanValue()) {
            this.generateFilesMetadata(files);
        }
        this.config.postProcess();
        GlobalSettings.reset();
        return files;
    }

    private void processUserDefinedTemplates() {
        if (this.userDefinedTemplates != null && !this.userDefinedTemplates.isEmpty()) {
            Map supportingFilesMap = this.config.supportingFiles().stream().collect(Collectors.toMap(TemplateDefinition::getTemplateFile, Function.identity(), (oldValue, newValue) -> oldValue));
            this.userDefinedTemplates.stream().filter(i -> i.getTemplateType().equals((Object)TemplateFileType.SupportingFiles)).forEach(userDefinedTemplate -> {
                SupportingFile newFile = new SupportingFile(userDefinedTemplate.getTemplateFile(), userDefinedTemplate.getFolder(), userDefinedTemplate.getDestinationFilename());
                if (supportingFilesMap.containsKey(userDefinedTemplate.getTemplateFile())) {
                    SupportingFile f = (SupportingFile)((Object)((Object)supportingFilesMap.get(userDefinedTemplate.getTemplateFile())));
                    this.config.supportingFiles().remove((Object)f);
                    if (!f.isCanOverwrite()) {
                        newFile.doNotOverwrite();
                    }
                }
                this.config.supportingFiles().add(newFile);
            });
            this.userDefinedTemplates.stream().filter(i -> !i.getTemplateType().equals((Object)TemplateFileType.SupportingFiles)).forEach(userDefinedTemplate -> {
                int lastSeparator;
                String templateFile = userDefinedTemplate.getTemplateFile();
                String templateExt = FilenameUtils.getExtension((String)templateFile.substring(0, lastSeparator = templateFile.lastIndexOf(46)));
                templateExt = StringUtils.isBlank((CharSequence)templateExt) ? userDefinedTemplate.getDestinationFilename() : StringUtils.prependIfMissing((String)templateExt, (CharSequence)".", (CharSequence[])new CharSequence[0]);
                switch (userDefinedTemplate.getTemplateType()) {
                    case API: {
                        this.config.apiTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                    case Model: {
                        this.config.modelTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                    case APIDocs: {
                        this.config.apiDocTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                    case ModelDocs: {
                        this.config.modelDocTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                    case APITests: {
                        this.config.apiTestTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                    case ModelTests: {
                        this.config.modelTestTemplateFiles().put(templateFile, templateExt);
                        break;
                    }
                }
            });
        }
    }

    protected File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename, boolean shouldGenerate, String skippedByOption) throws IOException {
        return this.processTemplateToFile(templateData, templateName, outputFilename, shouldGenerate, skippedByOption, this.config.getOutputDir());
    }

    private File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename, boolean shouldGenerate, String skippedByOption, String intendedOutputDir) throws IOException {
        String adjustedOutputFilename = outputFilename.replaceAll("//", "/").replace('/', File.separatorChar);
        File target = new File(adjustedOutputFilename);
        if (this.ignoreProcessor.allowsFile(target)) {
            if (shouldGenerate) {
                Path outDir = Paths.get(intendedOutputDir, new String[0]).toAbsolutePath();
                Path absoluteTarget = target.toPath().toAbsolutePath();
                if (!absoluteTarget.startsWith(outDir)) {
                    throw new RuntimeException(String.format(Locale.ROOT, "Target files must be generated within the output directory; absoluteTarget=%s outDir=%s", absoluteTarget, outDir));
                }
                return this.templateProcessor.write(templateData, templateName, target);
            }
            this.templateProcessor.skip(target.toPath(), String.format(Locale.ROOT, "Skipped by %s options supplied by user.", skippedByOption));
            return null;
        }
        this.templateProcessor.ignore(target.toPath(), "Ignored by rule in ignore file.");
        return null;
    }

    public Map<String, List<CodegenOperation>> processPaths(io.swagger.v3.oas.models.Paths paths) {
        TreeMap<String, List<CodegenOperation>> ops = new TreeMap<String, List<CodegenOperation>>();
        if (paths == null) {
            return ops;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            String resourcePath = (String)pathsEntry.getKey();
            PathItem path = (PathItem)pathsEntry.getValue();
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
            this.processOperation(resourcePath, "trace", path.getTrace(), ops, path);
        }
        return ops;
    }

    private void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, PathItem path) {
        if (operation == null) {
            return;
        }
        if (GlobalSettings.getProperty("debugOperations") != null) {
            this.LOGGER.info("processOperation: resourcePath=  {}\t;{} {}\n", new Object[]{resourcePath, httpMethod, operation});
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List tagNames = operation.getTags();
        List swaggerTags = this.openAPI.getTags();
        if (tagNames != null) {
            if (swaggerTags == null) {
                for (Iterator tagName : tagNames) {
                    tags.add(new Tag().name(tagName));
                }
            } else {
                for (Iterator tagName : tagNames) {
                    boolean foundTag = false;
                    for (Tag tag : swaggerTags) {
                        if (!tag.getName().equals(tagName)) continue;
                        tags.add(tag);
                        foundTag = true;
                        break;
                    }
                    if (foundTag) continue;
                    tags.add(new Tag().name(tagName));
                }
            }
        }
        if (tags.isEmpty()) {
            tags.add(new Tag().name("default"));
        }
        HashSet<String> operationParameters = new HashSet<String>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                operationParameters.add(DefaultGenerator.generateParameterId(parameter));
            }
        }
        if (path.getParameters() != null) {
            for (Parameter parameter : path.getParameters()) {
                if (operationParameters.contains(DefaultGenerator.generateParameterId(parameter))) continue;
                operation.addParametersItem(parameter);
            }
        }
        Map securitySchemes = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List globalSecurities = this.openAPI.getSecurity();
        for (Tag tag : tags) {
            try {
                List<CodegenSecurity> fullAuthMethods;
                CodegenOperation codegenOperation = this.config.fromOperation(resourcePath, httpMethod, operation, path.getServers());
                codegenOperation.tags = new ArrayList<Tag>(tags);
                this.config.addOperationToGroup(this.config.sanitizeTag(tag.getName()), resourcePath, operation, codegenOperation, operations);
                List securities = operation.getSecurity();
                if (securities != null && securities.isEmpty()) continue;
                Map<String, SecurityScheme> authMethods = this.getAuthMethods(securities, securitySchemes);
                if (authMethods != null && !authMethods.isEmpty()) {
                    fullAuthMethods = this.config.fromSecurity(authMethods);
                    codegenOperation.authMethods = this.filterAuthMethods(fullAuthMethods, securities);
                    codegenOperation.hasAuthMethods = true;
                    continue;
                }
                authMethods = this.getAuthMethods(globalSecurities, securitySchemes);
                if (authMethods == null || authMethods.isEmpty()) continue;
                fullAuthMethods = this.config.fromSecurity(authMethods);
                codegenOperation.authMethods = this.filterAuthMethods(fullAuthMethods, globalSecurities);
                codegenOperation.hasAuthMethods = true;
            }
            catch (Exception ex) {
                String msg = "Could not process operation:\n  Tag: " + tag + "\n  Operation: " + operation.getOperationId() + "\n  Resource: " + httpMethod + " " + resourcePath + "\n  Schemas: " + this.openAPI.getComponents().getSchemas() + "\n  Exception: " + ex.getMessage();
                throw new RuntimeException(msg, ex);
            }
        }
    }

    private static String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    private OperationsMap processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops, List<ModelMap> allModels) {
        OperationsMap operations = new OperationsMap();
        OperationMap objs = new OperationMap();
        objs.setClassname(config.toApiName(tag));
        objs.setPathPrefix(config.toApiVarName(tag));
        if (config.getAddSuffixToDuplicateOperationNicknames()) {
            HashSet<String> opIds = new HashSet<String>();
            int counter = 0;
            for (CodegenOperation op : ops) {
                String opId = op.nickname;
                if (opIds.contains(opId)) {
                    op.nickname = op.nickname + "_" + ++counter;
                }
                opIds.add(opId);
            }
        }
        objs.setOperation(ops);
        operations.setOperation(objs);
        operations.put("package", config.apiPackage());
        ConcurrentSkipListSet<String> allImports = new ConcurrentSkipListSet<String>();
        for (CodegenOperation op : ops) {
            allImports.addAll(op.imports);
        }
        Map<String, String> mappings = this.getAllImportsMappings(allImports);
        Set<Map<String, String>> imports = this.toImportsObjects(mappings);
        operations.setImports(new ArrayList<Map<String, String>>(imports));
        if (!imports.isEmpty()) {
            operations.put("hasImport", true);
        }
        config.postProcessOperationsWithModels(operations, allModels);
        return operations;
    }

    private Map<String, String> getAllImportsMappings(Set<String> allImports) {
        HashMap<String, String> result = new HashMap<String, String>();
        allImports.forEach(nextImport -> {
            String mapping = this.config.importMapping().get(nextImport);
            if (mapping != null) {
                result.put(mapping, (String)nextImport);
            } else {
                result.putAll(this.config.toModelImportMap((String)nextImport));
            }
        });
        return result;
    }

    private Set<Map<String, String>> toImportsObjects(Map<String, String> mappedImports) {
        TreeSet<Map<String, String>> result = new TreeSet<Map<String, String>>(Comparator.comparing(o -> (String)o.get("classname")));
        mappedImports.forEach((key, value) -> {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            im.put("import", (String)key);
            im.put("classname", (String)value);
            result.add(im);
        });
        return result;
    }

    private ModelsMap processModels(CodegenConfig config, Map<String, Schema> definitions) {
        ModelsMap objs = new ModelsMap();
        objs.put("package", config.modelPackage());
        ArrayList<ModelMap> modelMaps = new ArrayList<ModelMap>();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (Map.Entry<String, Schema> entry : definitions.entrySet()) {
            String key = entry.getKey();
            Schema schema = entry.getValue();
            if (schema == null) {
                this.LOGGER.warn("Schema {} cannot be null in processModels", (Object)key);
                continue;
            }
            CodegenModel cm = config.fromModel(key, schema);
            ModelMap mo = new ModelMap();
            mo.setModel(cm);
            mo.put("importPath", config.toModelImport(cm.classname));
            modelMaps.add(mo);
            cm.removeSelfReferenceImport();
            allImports.addAll(cm.imports);
        }
        objs.setModels(modelMaps);
        ConcurrentSkipListSet<String> importSet = new ConcurrentSkipListSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            arrayList.add(item);
        }
        objs.setImports(arrayList);
        config.postProcessModels(objs);
        return objs;
    }

    private Map<String, SecurityScheme> getAuthMethods(List<SecurityRequirement> securities, Map<String, SecurityScheme> securitySchemes) {
        if (securities == null || securitySchemes == null || securitySchemes.isEmpty()) {
            return null;
        }
        HashMap<String, SecurityScheme> authMethods = new HashMap<String, SecurityScheme>();
        for (SecurityRequirement requirement : securities) {
            for (Map.Entry entry : requirement.entrySet()) {
                String key = (String)entry.getKey();
                SecurityScheme securityScheme = securitySchemes.get(key);
                if (securityScheme == null) continue;
                if (securityScheme.getType().equals((Object)SecurityScheme.Type.OAUTH2)) {
                    OAuthFlow updatedFlow;
                    OAuthFlows oauthUpdatedFlows = new OAuthFlows();
                    oauthUpdatedFlows.extensions(securityScheme.getFlows().getExtensions());
                    SecurityScheme oauthUpdatedScheme = new SecurityScheme().type(securityScheme.getType()).description(securityScheme.getDescription()).name(securityScheme.getName()).$ref(securityScheme.get$ref()).in(securityScheme.getIn()).scheme(securityScheme.getScheme()).bearerFormat(securityScheme.getBearerFormat()).openIdConnectUrl(securityScheme.getOpenIdConnectUrl()).extensions(securityScheme.getExtensions()).flows(oauthUpdatedFlows);
                    OAuthFlows securitySchemeFlows = securityScheme.getFlows();
                    if (securitySchemeFlows.getAuthorizationCode() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getAuthorizationCode(), (List)entry.getValue());
                        oauthUpdatedFlows.setAuthorizationCode(updatedFlow);
                    }
                    if (securitySchemeFlows.getImplicit() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getImplicit(), (List)entry.getValue());
                        oauthUpdatedFlows.setImplicit(updatedFlow);
                    }
                    if (securitySchemeFlows.getPassword() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getPassword(), (List)entry.getValue());
                        oauthUpdatedFlows.setPassword(updatedFlow);
                    }
                    if (securitySchemeFlows.getClientCredentials() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getClientCredentials(), (List)entry.getValue());
                        oauthUpdatedFlows.setClientCredentials(updatedFlow);
                    }
                    authMethods.put(key, oauthUpdatedScheme);
                    continue;
                }
                if (securityScheme.getType().equals((Object)SecurityScheme.Type.OPENIDCONNECT)) {
                    OAuthFlows openIdConnectUpdatedFlows = new OAuthFlows();
                    OAuthFlow flow = new OAuthFlow();
                    Scopes flowScopes = new Scopes();
                    securities.stream().map(secReq -> (List)secReq.get((Object)key)).filter(Objects::nonNull).flatMap(Collection::stream).forEach(value -> flowScopes.put(value, value));
                    flow.scopes(flowScopes);
                    openIdConnectUpdatedFlows.authorizationCode(flow);
                    SecurityScheme openIdConnectUpdatedScheme = new SecurityScheme().type(securityScheme.getType()).description(securityScheme.getDescription()).name(securityScheme.getName()).$ref(securityScheme.get$ref()).in(securityScheme.getIn()).scheme(securityScheme.getScheme()).bearerFormat(securityScheme.getBearerFormat()).openIdConnectUrl(securityScheme.getOpenIdConnectUrl()).extensions(securityScheme.getExtensions()).flows(openIdConnectUpdatedFlows);
                    authMethods.put(key, openIdConnectUpdatedScheme);
                    continue;
                }
                authMethods.put(key, securityScheme);
            }
        }
        return authMethods;
    }

    private static OAuthFlow cloneOAuthFlow(OAuthFlow originFlow, List<String> operationScopes) {
        Scopes newScopes = new Scopes();
        for (String operationScope : operationScopes) {
            if (!originFlow.getScopes().containsKey((Object)operationScope)) continue;
            newScopes.put((Object)operationScope, (Object)((String)originFlow.getScopes().get((Object)operationScope)));
        }
        return new OAuthFlow().authorizationUrl(originFlow.getAuthorizationUrl()).tokenUrl(originFlow.getTokenUrl()).refreshUrl(originFlow.getRefreshUrl()).extensions(originFlow.getExtensions()).scopes(newScopes);
    }

    private List<CodegenSecurity> filterAuthMethods(List<CodegenSecurity> authMethods, List<SecurityRequirement> securities) {
        if (securities == null || securities.isEmpty() || authMethods == null) {
            return authMethods;
        }
        ArrayList<CodegenSecurity> result = new ArrayList<CodegenSecurity>();
        for (CodegenSecurity security : authMethods) {
            boolean filtered = false;
            if (security != null && security.scopes != null) {
                for (SecurityRequirement requirement : securities) {
                    List opScopes = (List)requirement.get((Object)security.name);
                    if (opScopes == null) continue;
                    CodegenSecurity opSecurity = security.filterByScopeNames(opScopes);
                    result.add(opSecurity);
                    filtered = true;
                    break;
                }
            }
            if (filtered) continue;
            result.add(security);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateVersionMetadata(List<File> files) {
        String versionMetadata = this.config.outputFolder() + File.separator + METADATA_DIR + File.separator + this.config.getVersionMetadataFilename();
        if (this.generateMetadata.booleanValue()) {
            File versionMetadataFile = new File(versionMetadata);
            try {
                File written = this.templateProcessor.writeToFile(versionMetadata, ImplementationVersion.read().getBytes(StandardCharsets.UTF_8));
                if (written == null) return;
                files.add(versionMetadataFile);
                if (!this.config.isEnablePostProcessFile() || this.dryRun) return;
                this.config.postProcessFile(written, "openapi-generator-version");
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '" + versionMetadata + "'", e);
            }
        } else {
            Path metadata = Paths.get(versionMetadata, new String[0]);
            this.templateProcessor.skip(metadata, "Skipped by generateMetadata option supplied by user.");
        }
    }

    private Path absPath(File input) {
        return Paths.get(input.getAbsolutePath(), new String[0]);
    }

    private void generateFilesMetadata(List<File> files) {
        if (this.generateMetadata.booleanValue()) {
            try {
                StringBuilder sb = new StringBuilder();
                Path outDir = this.absPath(new File(this.config.getOutputDir()));
                ArrayList filesToSort = new ArrayList();
                files.forEach(f -> {
                    if (f != null && f.getPath() != null) {
                        filesToSort.add(outDir.relativize(this.absPath((File)f)).normalize().toFile());
                    }
                });
                String relativeMeta = ".openapi-generator/VERSION";
                filesToSort.sort(PathFileComparator.PATH_COMPARATOR);
                filesToSort.forEach(f -> {
                    String relativePath = StringUtils.removeStart((String)StringUtils.removeStart((String)f.toString(), (String)("." + File.separator)), (String)File.separator);
                    if (File.separator.equals("\\")) {
                        relativePath = relativePath.replace(File.separator, "/");
                    }
                    if (!relativePath.equals(relativeMeta)) {
                        sb.append(relativePath).append(System.lineSeparator());
                    }
                });
                String targetFile = this.config.outputFolder() + File.separator + METADATA_DIR + File.separator + this.config.getFilesMetadataFilename();
                File filesFile = this.templateProcessor.writeToFile(targetFile, sb.toString().getBytes(StandardCharsets.UTF_8));
                if (filesFile != null) {
                    files.add(filesFile);
                }
            }
            catch (Exception e) {
                this.LOGGER.warn("Failed to write FILES metadata to track generated files.");
            }
        }
    }

    private String removeTrailingSlash(String value) {
        return StringUtils.removeEnd((String)value, (String)"/");
    }
}

