/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public interface DocumentationProviderFeatures {
    public static final String DOCUMENTATION_PROVIDER = "documentationProvider";
    public static final String ANNOTATION_LIBRARY = "annotationLibrary";

    default public DocumentationProvider defaultDocumentationProvider() {
        return null;
    }

    default public List<DocumentationProvider> supportedDocumentationProvider() {
        ArrayList<DocumentationProvider> supportedProviders = new ArrayList<DocumentationProvider>();
        supportedProviders.add(DocumentationProvider.NONE);
        return supportedProviders;
    }

    default public List<AnnotationLibrary> supportedAnnotationLibraries() {
        ArrayList<AnnotationLibrary> supportedLibraries = new ArrayList<AnnotationLibrary>();
        supportedLibraries.add(AnnotationLibrary.NONE);
        return supportedLibraries;
    }

    public DocumentationProvider getDocumentationProvider();

    public void setDocumentationProvider(DocumentationProvider var1);

    public AnnotationLibrary getAnnotationLibrary();

    public void setAnnotationLibrary(AnnotationLibrary var1);

    public static enum AnnotationLibrary {
        NONE("withoutAnnotationLibrary", "Do not annotate Model and Api with complementary annotations."),
        SWAGGER1("swagger1AnnotationLibrary", "Annotate Model and Api using the Swagger Annotations 1.x library."),
        SWAGGER2("swagger2AnnotationLibrary", "Annotate Model and Api using the Swagger Annotations 2.x library."),
        MICROPROFILE("microprofileAnnotationLibrary", "Annotate Model and Api using the Microprofile annotations.");

        private final String propertyName;
        private final String description;

        public static AnnotationLibrary ofCliOption(String optVal) {
            optVal = Objects.requireNonNull(optVal).toUpperCase(Locale.ROOT);
            return AnnotationLibrary.valueOf(optVal);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        private AnnotationLibrary(String propertyName, String description) {
            this.propertyName = propertyName;
            this.description = description;
        }

        public String toCliOptValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum DocumentationProvider {
        NONE("withoutDocumentationProvider", "Do not publish an OpenAPI specification.", AnnotationLibrary.NONE, AnnotationLibrary.values()),
        SOURCE("sourceDocumentationProvider", "Publish the original input OpenAPI specification.", AnnotationLibrary.NONE, AnnotationLibrary.values()),
        SWAGGER1("swagger1DocumentationProvider", "Generate an OpenAPI 2 (fka Swagger RESTful API Documentation Specification) specification using Swagger-Core 1.x.", AnnotationLibrary.SWAGGER1, AnnotationLibrary.SWAGGER1),
        SWAGGER2("swagger2DocumentationProvider", "Generate an OpenAPI 3 specification using Swagger-Core 2.x.", AnnotationLibrary.SWAGGER2, AnnotationLibrary.SWAGGER2),
        SPRINGFOX("springFoxDocumentationProvider", "Generate an OpenAPI 2 (fka Swagger RESTful API Documentation Specification) specification using SpringFox 2.x. Deprecated (for removal); use springdoc instead.", AnnotationLibrary.SWAGGER1, AnnotationLibrary.SWAGGER1),
        SPRINGDOC("springDocDocumentationProvider", "Generate an OpenAPI 3 specification using SpringDoc.", AnnotationLibrary.SWAGGER2, AnnotationLibrary.SWAGGER2);

        private final String propertyName;
        private final String description;
        private final AnnotationLibrary preferredAnnotationLibrary;
        private final AnnotationLibrary[] supportedAnnotationLibraries;

        private DocumentationProvider(String propertyName, String description, AnnotationLibrary preferredAnnotationLibrary, AnnotationLibrary ... supportedAnnotationLibraries) {
            this.propertyName = propertyName;
            this.description = description;
            this.preferredAnnotationLibrary = preferredAnnotationLibrary;
            this.supportedAnnotationLibraries = supportedAnnotationLibraries;
        }

        public static DocumentationProvider ofCliOption(String optVal) {
            optVal = Objects.requireNonNull(optVal).toUpperCase(Locale.ROOT);
            return DocumentationProvider.valueOf(optVal);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public AnnotationLibrary getPreferredAnnotationLibrary() {
            return this.preferredAnnotationLibrary;
        }

        public AnnotationLibrary[] getSupportedAnnotationLibraries() {
            return this.supportedAnnotationLibraries;
        }

        public List<AnnotationLibrary> supportedAnnotationLibraries() {
            return Arrays.asList(this.getSupportedAnnotationLibraries());
        }

        public String toCliOptValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

