/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.examples;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.examples.XmlExampleGenerator;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGenerator {
    private final Logger LOGGER = LoggerFactory.getLogger(ExampleGenerator.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_XML = "application/xml";
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
    private static final String EXAMPLE = "example";
    private static final String CONTENT_TYPE = "contentType";
    private static final String GENERATED_CONTENT_TYPE = "generatedContentType";
    private static final String OUTPUT = "output";
    private static final String NONE = "none";
    private static final String URL = "url";
    private static final String URI = "uri";
    private static final String STATUS_CODE = "statusCode";
    protected Map<String, Schema> examples;
    private OpenAPI openAPI;
    private Random random;

    public ExampleGenerator(Map<String, Schema> examples, OpenAPI openAPI) {
        this.examples = examples;
        this.openAPI = openAPI;
        this.random = new Random("ExampleGenerator".hashCode());
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public List<Map<String, String>> generateFromResponseSchema(String statusCode, Schema responseSchema, Set<String> producesInfo) {
        List<Map<String, String>> examples = this.generateFromResponseSchema(responseSchema, producesInfo);
        if (examples == null) {
            return null;
        }
        for (Map<String, String> example : examples) {
            example.put(STATUS_CODE, statusCode);
        }
        return examples;
    }

    private List<Map<String, String>> generateFromResponseSchema(Schema responseSchema, Set<String> producesInfo) {
        if (responseSchema.getExample() == null && StringUtils.isEmpty((CharSequence)responseSchema.get$ref()) && !ModelUtils.isArraySchema(responseSchema)) {
            return null;
        }
        if (responseSchema.getExample() != null && !(responseSchema.getExample() instanceof Map)) {
            return this.generate(responseSchema.getExample(), new ArrayList<String>(producesInfo));
        }
        if (ModelUtils.isArraySchema(responseSchema)) {
            if (ModelUtils.getSchemaItems(responseSchema) != null) {
                return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), responseSchema);
            }
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)responseSchema.get$ref())) {
            return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), responseSchema);
        }
        return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), ModelUtils.getSimpleRef(responseSchema.get$ref()));
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Schema property) {
        this.LOGGER.debug("debugging generate in ExampleGenerator");
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (property != null && (string.startsWith(MIME_TYPE_JSON) || string.contains("*/*"))) {
                    example = Json.pretty((Object)this.resolvePropertyToExample("", string, property, processedModels));
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    kv.put(GENERATED_CONTENT_TYPE, MIME_TYPE_JSON);
                    output.add(kv);
                    continue;
                }
                if (property == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(property)) == null) continue;
                kv.put(EXAMPLE, example);
                kv.put(GENERATED_CONTENT_TYPE, MIME_TYPE_XML);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, (String)entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, String modelName) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                Schema schema;
                HashMap<String, Object> kv = new HashMap<String, Object>();
                kv.put(CONTENT_TYPE, string);
                if (modelName != null && (string.startsWith(MIME_TYPE_JSON) || string.contains("*/*"))) {
                    schema = this.examples.get(modelName);
                    if (schema == null || (example = Json.pretty((Object)this.resolveModelToExample(modelName, string, schema, processedModels))) == null) continue;
                    kv.put(EXAMPLE, example);
                    kv.put(GENERATED_CONTENT_TYPE, MIME_TYPE_JSON);
                    output.add(kv);
                    continue;
                }
                if (modelName != null && string.startsWith(MIME_TYPE_XML)) {
                    schema = this.examples.get(modelName);
                    example = new XmlExampleGenerator(this.examples).toXml(schema, 0, Collections.emptySet());
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    kv.put(GENERATED_CONTENT_TYPE, MIME_TYPE_XML);
                    output.add(kv);
                    continue;
                }
                kv.put(EXAMPLE, "Custom MIME type example not yet supported: " + string);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, (String)entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private List<Map<String, String>> generate(Object example, List<String> mediaTypes) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        if (this.examples != null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String mediaType : mediaTypes) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, mediaType);
                if (mediaType.startsWith(MIME_TYPE_JSON) || mediaType.contains("*/*")) {
                    kv.put(EXAMPLE, Json.pretty((Object)example));
                    kv.put(GENERATED_CONTENT_TYPE, MIME_TYPE_JSON);
                    output.add(kv);
                    continue;
                }
                if (!mediaType.startsWith(MIME_TYPE_XML)) continue;
                this.LOGGER.warn("XML example value of (array/primitive) is not handled at the moment: {}", example);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private Object resolvePropertyToExample(String propertyName, String mediaType, Schema property, Set<String> processedModels) {
        if (property == null) {
            this.LOGGER.error("Property schema shouldn't be null. Please report the issue to the openapi-generator team.");
            return "";
        }
        this.LOGGER.debug("Resolving example for property {}...", (Object)property);
        if (property.getExample() != null) {
            this.LOGGER.debug("Example set in openapi spec, returning example: '{}'", (Object)property.getExample().toString());
            if (property.getExample() instanceof Date) {
                return this.dateFormat.format(property.getExample());
            }
            return property.getExample();
        }
        if (ModelUtils.isBooleanSchema(property)) {
            Object defaultValue = property.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.TRUE;
        }
        if (ModelUtils.isArraySchema(property)) {
            Schema<?> innerType = ModelUtils.getSchemaItems(property);
            if (innerType != null) {
                int arrayLength = null == property.getMaxItems() ? 2 : property.getMaxItems();
                arrayLength = Math.min(arrayLength, 5);
                Object[] objectProperties = new Object[arrayLength];
                Object objProperty = this.resolvePropertyToExample(propertyName, mediaType, innerType, processedModels);
                for (int i = 0; i < arrayLength; ++i) {
                    objectProperties[i] = objProperty;
                }
                return objectProperties;
            }
        } else {
            if (ModelUtils.isDateSchema(property)) {
                return "2000-01-23";
            }
            if (ModelUtils.isDateTimeSchema(property)) {
                return "2000-01-23T04:56:07.000+00:00";
            }
            if (ModelUtils.isNumberSchema(property)) {
                Double min = this.getPropertyValue(property.getMinimum());
                Double max = this.getPropertyValue(property.getMaximum());
                if (ModelUtils.isFloatSchema(property)) {
                    return Float.valueOf((float)this.randomNumber(min, max));
                }
                if (ModelUtils.isDoubleSchema(property)) {
                    return BigDecimal.valueOf(this.randomNumber(min, max));
                }
                return this.randomNumber(min, max);
            }
            if (ModelUtils.isFileSchema(property)) {
                return "";
            }
            if (ModelUtils.isIntegerSchema(property)) {
                Double min = this.getPropertyValue(property.getMinimum());
                Double max = this.getPropertyValue(property.getMaximum());
                if (ModelUtils.isLongSchema(property)) {
                    return (long)this.randomNumber(min, max);
                }
                return (int)this.randomNumber(min, max);
            }
            if (ModelUtils.isMapSchema(property)) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (property.getName() != null) {
                    mp.put(property.getName(), this.resolvePropertyToExample(propertyName, mediaType, ModelUtils.getAdditionalProperties(property), processedModels));
                } else {
                    mp.put("key", this.resolvePropertyToExample(propertyName, mediaType, ModelUtils.getAdditionalProperties(property), processedModels));
                }
                return mp;
            }
            if (ModelUtils.isUUIDSchema(property)) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
            if (ModelUtils.isURISchema(property)) {
                return "https://openapi-generator.tech";
            }
            if (ModelUtils.isStringSchema(property)) {
                this.LOGGER.debug("String property");
                if (property.getDefault() != null) {
                    return String.valueOf(property.getDefault());
                }
                List enumValues = property.getEnum();
                if (enumValues != null && !enumValues.isEmpty()) {
                    this.LOGGER.debug("Enum value found: '{}'", enumValues.get(0));
                    return enumValues.get(0);
                }
                String format = property.getFormat();
                if (format != null && (URI.equals(format) || URL.equals(format))) {
                    this.LOGGER.debug("URI or URL format, without default or enum, generating random one.");
                    return "http://example.com/aeiou";
                }
                this.LOGGER.debug("No values found, using property name {} as example", (Object)propertyName);
                return propertyName;
            }
            if (!StringUtils.isEmpty((CharSequence)property.get$ref())) {
                String simpleName = ModelUtils.getSimpleRef(property.get$ref());
                Schema schema = ModelUtils.getSchema(this.openAPI, simpleName);
                if (schema == null) {
                    return "{}";
                }
                return this.resolveModelToExample(simpleName, mediaType, schema, processedModels);
            }
            if (ModelUtils.isObjectSchema(property)) {
                return "{}";
            }
        }
        return "";
    }

    private Double getPropertyValue(BigDecimal propertyValue) {
        return propertyValue == null ? null : Double.valueOf(propertyValue.doubleValue());
    }

    private double randomNumber(Double min, Double max) {
        if (min != null && max != null) {
            double range = max - min;
            return this.random.nextDouble() * range + min;
        }
        if (min != null) {
            return this.random.nextDouble() + min;
        }
        if (max != null) {
            return this.random.nextDouble() * max;
        }
        return this.random.nextDouble() * 10.0;
    }

    private Object resolveModelToExample(String name, String mediaType, Schema schema, Set<String> processedModels) {
        if (processedModels.contains(name)) {
            return schema.getExample();
        }
        processedModels.add(name);
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.LOGGER.debug("Resolving model '{}' to example", (Object)name);
        if (schema.getExample() != null) {
            this.LOGGER.debug("Using example from spec: {}", schema.getExample());
            return schema.getExample();
        }
        if (schema.getProperties() != null) {
            this.LOGGER.debug("Creating example from model values");
            this.traverseSchemaProperties(mediaType, schema, processedModels, values);
            schema.setExample(values);
            return schema.getExample();
        }
        if (ModelUtils.isAllOf(schema) || ModelUtils.isAllOfWithProperties(schema)) {
            this.LOGGER.debug("Resolving allOf model '{}' to example", (Object)name);
            this.resolveAllOfSchemaProperties(mediaType, schema, processedModels, values);
            schema.setExample(values);
            return schema.getExample();
        }
        if (ModelUtils.isAnyOf(schema) || ModelUtils.isOneOf(schema)) {
            this.LOGGER.debug("Resolving anyOf/oneOf model '{}' using the first schema to example", (Object)name);
            Optional<Schema> found = ModelUtils.getInterfaces(schema).stream().filter(this::hasValidRef).findFirst();
            if (found.isEmpty()) {
                return null;
            }
            return this.resolvePropertyToExample(name, mediaType, found.get(), processedModels);
        }
        if (ModelUtils.isArraySchema(schema) || ModelUtils.isEnumSchema(schema)) {
            return this.resolvePropertyToExample(schema.getName(), mediaType, schema, processedModels);
        }
        return null;
    }

    private void traverseSchemaProperties(String mediaType, Schema schema, Set<String> processedModels, Map<String, Object> values) {
        if (schema.getProperties() != null) {
            for (Object propertyName : schema.getProperties().keySet()) {
                Schema property = (Schema)schema.getProperties().get(propertyName.toString());
                values.put(propertyName.toString(), this.resolvePropertyToExample(propertyName.toString(), mediaType, property, processedModels));
            }
        } else if (ModelUtils.isAllOf(schema) || ModelUtils.isAllOfWithProperties(schema)) {
            this.resolveAllOfSchemaProperties(mediaType, schema, processedModels, values);
        }
    }

    private void resolveAllOfSchemaProperties(String mediaType, Schema schema, Set<String> processedModels, Map<String, Object> values) {
        List interfaces = schema.getAllOf();
        for (Schema composed : interfaces) {
            String ref;
            Schema resolved;
            this.traverseSchemaProperties(mediaType, composed, processedModels, values);
            if (composed.get$ref() == null || (resolved = ModelUtils.getSchema(this.openAPI, ref = ModelUtils.getSimpleRef(composed.get$ref()))) == null) continue;
            this.traverseSchemaProperties(mediaType, resolved, processedModels, values);
        }
    }

    private boolean hasValidRef(Schema schema) {
        if (schema.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef(schema.get$ref());
            Schema resolved = ModelUtils.getSchema(this.openAPI, ref);
            return resolved != null;
        }
        return true;
    }
}

