/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptClosureAngularClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(JavascriptClosureAngularClientCodegen.class);
    public static final String USE_ES6 = "useEs6";
    protected boolean useEs6;

    public JavascriptClosureAngularClientCodegen() {
        this.outputFolder = "generated-code/javascript-closure-angular";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.supportsInheritance = false;
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "const", "super", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "boolean", "number", "Object", "Blob", "Date"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("Object", "Object");
        this.typeMapping.put("File", "Blob");
        this.typeMapping.put("file", "Blob");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "Object");
        this.typeMapping.put("map", "Object");
        this.typeMapping.put("DateTime", "Date");
        this.importMapping = new HashMap();
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Object", "Array", "Blob"));
        this.typeMapping.put("binary", "string");
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(USE_ES6, "use ES6 templates").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(USE_ES6)) {
            this.setUseEs6(this.convertPropertyToBooleanAndWriteBack(USE_ES6));
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (this.useEs6) {
            this.templateDir = "Javascript-Closure-Angular/es6";
            this.embeddedTemplateDir = "Javascript-Closure-Angular/es6";
            this.apiPackage = "resources";
            this.apiTemplateFiles.put("api.mustache", ".js");
            this.supportingFiles.add(new SupportingFile("module.mustache", "", "module.js"));
        } else {
            this.modelTemplateFiles.put("model.mustache", ".js");
            this.apiTemplateFiles.put("api.mustache", ".js");
            this.templateDir = "Javascript-Closure-Angular";
            this.embeddedTemplateDir = "Javascript-Closure-Angular";
            this.apiPackage = "API.Client";
            this.modelPackage = "API.Client";
        }
    }

    @Override
    public String getName() {
        return "javascript-closure-angular";
    }

    @Override
    public String getHelp() {
        return "Generates a Javascript AngularJS client library (beta) annotated with Google Closure Compiler annotations(https://developers.google.com/closure/compiler/docs/js-for-compiler?hl=en)";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)name)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = "model_" + (String)name;
        }
        return StringUtils.camelize((String)name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "<!" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "Object<!string, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "Object";
        }
        String type = super.getTypeDeclaration(p);
        if (type.equals("boolean") || type.equals("Date") || type.equals("number") || type.equals("string")) {
            return type;
        }
        return this.apiPackage + "." + type;
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return type;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!var.isEnum || var.defaultValue == null || "null".equals(var.defaultValue)) continue;
                var.defaultValue = var.datatypeWithEnum + "." + var.defaultValue;
            }
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        List<Map<String, String>> imports = objs.getImports();
        imports.sort(Comparator.comparing(o -> (String)o.get("import")));
        objs.put("imports", imports);
        return objs;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setUseEs6(boolean useEs6) {
        this.useEs6 = useEs6;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.JAVASCRIPT;
    }
}

