/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KtormSchemaCodegen
extends AbstractKotlinCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(KtormSchemaCodegen.class);
    public static final String VENDOR_EXTENSION_SCHEMA = "x-ktorm-schema";
    public static final String DEFAULT_DATABASE_NAME = "defaultDatabaseName";
    public static final String IMPORT_MODEL_PACKAGE_NAME = "importModelPackageName";
    public static final String IDENTIFIER_NAMING_CONVENTION = "identifierNamingConvention";
    public static final String PRIMARY_KEY_CONVENTION = "primaryKeyConvention";
    public static final String ADD_SURROGATE_KEY = "addSurrogateKey";
    public static final Integer IDENTIFIER_MAX_LENGTH = 255;
    protected String importModelPackageName = "";
    protected String defaultDatabaseName = "sqlite.db";
    protected String databaseNamePrefix = "_";
    protected String databaseNameSuffix = "";
    protected String tableNamePrefix = "_";
    protected String tableNameSuffix = "";
    protected String columnNamePrefix = "_";
    protected String columnNameSuffix = "";
    protected String identifierNamingConvention = "original";
    protected String primaryKeyConvention = "id";
    protected boolean addSurrogateKey = false;
    protected Map<String, String> sqlTypeMapping = new HashMap<String, String>();

    public KtormSchemaCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.noneOf(WireFormatFeature.class)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)));
        this.setReservedWordsLowerCase(Arrays.asList("ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ALWAYS", "ANALYZE", "AND", "ANY", "AS", "ASC", "ATTACH", "AUTOINCR", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BITAND", "BITNOT", "BITOR", "BLOB", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMA", "COMMIT", "CONCAT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DO", "DOT", "DROP", "EACH", "ELSE", "END", "EQ", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FILTER", "FIRST", "FLOAT", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "GE", "GENERATED", "GLOB", "GROUP", "GROUPS", "GT", "HAVING", "ID", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTEGER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LAST", "LE", "LEFT", "LIKE", "LIMIT", "LP", "LSHIFT", "LT", "MATCH", "MINUS", "NATURAL", "NE", "NO", "NOT", "NOTHING", "NOTNULL", "NULL", "NULLS", "OF", "OFFSET", "ON", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "PARTITION", "PLAN", "PLUS", "PRAGMA", "PRECEDING", "PRIMARY", "QUERY", "RAISE", "RANGE", "RECURSIVE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "REM", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RP", "RSHIFT", "SAVEPOINT", "SELECT", "SET", "SLASH", "STAR", "STRING", "TABLE", "TEMP", "TEMPORARY", "THEN", "TIES", "TO", "TRANSACTION", "TRIGGER", "UNBOUNDED", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VARIABLE", "VIEW", "VIRTUAL", "WHEN", "WHERE", "WINDOW", "WITH", "WITHOUT"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.LocalDateTime");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("set", "kotlin.collections.Set");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.ByteArray");
        this.typeMapping.put("Date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.LocalDateTime");
        this.typeMapping.put("byte", "kotlin.Byte");
        this.typeMapping.put("short", "kotlin.Short");
        this.typeMapping.put("char", "kotlin.String");
        this.typeMapping.put("real", "kotlin.Double");
        this.typeMapping.put("UUID", "java.util.UUID");
        this.typeMapping.put("URI", "java.net.URI");
        this.typeMapping.put("decimal", "java.math.BigDecimal");
        this.typeMapping.put("BigDecimal", "java.math.BigDecimal");
        this.typeMapping.put("AnyType", "kotlin.Any");
        this.typeMapping.put("password", "kotlin.String");
        this.sqlTypeMapping.put("kotlin.String", "text");
        this.sqlTypeMapping.put("kotlin.Boolean", "boolean");
        this.sqlTypeMapping.put("kotlin.Byte", "int");
        this.sqlTypeMapping.put("kotlin.Short", "int");
        this.sqlTypeMapping.put("kotlin.Int", "int");
        this.sqlTypeMapping.put("kotlin.Long", "long");
        this.sqlTypeMapping.put("kotlin.Float", "float");
        this.sqlTypeMapping.put("kotlin.Double", "double");
        this.sqlTypeMapping.put("kotlin.ByteArray", "blob");
        this.sqlTypeMapping.put("kotlin.Array", "blob");
        this.sqlTypeMapping.put("kotlin.collections.List", "blob");
        this.sqlTypeMapping.put("kotlin.collections.MutableList", "blob");
        this.sqlTypeMapping.put("kotlin.collections.Set", "blob");
        this.sqlTypeMapping.put("kotlin.collections.MutableSet", "blob");
        this.sqlTypeMapping.put("kotlin.collections.Map", "blob");
        this.sqlTypeMapping.put("kotlin.collections.MutableMap", "blob");
        this.sqlTypeMapping.put("kotlin.Any", "blob");
        this.sqlTypeMapping.put("java.io.File", "blob");
        this.sqlTypeMapping.put("java.math.BigDecimal", "decimal");
        this.sqlTypeMapping.put("java.time.LocalDateTime", "datetime");
        this.sqlTypeMapping.put("java.time.LocalDate", "date");
        this.sqlTypeMapping.put("java.util.UUID", "text");
        this.sqlTypeMapping.put("java.net.URI", "text");
        this.artifactId = "ktorm";
        this.artifactVersion = "1.0.0";
        this.packageName = "org.openapitools.database";
        this.outputFolder = "generated-code" + File.separator + "kotlin-client";
        this.templateDir = "ktorm-schema";
        this.embeddedTemplateDir = "ktorm-schema";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.modelPackage = this.packageName + ".models";
        this.importModelPackageName = this.modelPackage;
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.removeOption("apiSuffix");
        this.removeOption("parcelizeModels");
        this.removeOption("serializableModel");
        this.removeOption("serializationLibrary");
        this.addOption(DEFAULT_DATABASE_NAME, "Default database name for all queries", this.defaultDatabaseName);
        this.addOption(IMPORT_MODEL_PACKAGE_NAME, "Package name of the imported models", this.importModelPackageName);
        this.addOption(PRIMARY_KEY_CONVENTION, "Primary key naming convention", this.primaryKeyConvention);
        this.addSwitch(ADD_SURROGATE_KEY, "Adds the surrogate key for all models that don't already have a primary key (named by the above convention)", this.addSurrogateKey);
        CliOption identifierNamingOpt = new CliOption(IDENTIFIER_NAMING_CONVENTION, "Naming convention of Ktorm identifiers(table names and column names). This is not related to database name which is defined by defaultDatabaseName option");
        identifierNamingOpt.addEnum("original", "Do not transform original names").addEnum("snake_case", "Use snake_case names").setDefault("original");
        this.cliOptions.add(identifierNamingOpt);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public String getName() {
        return "ktorm-schema";
    }

    @Override
    public String getHelp() {
        return "Generates a kotlin-ktorm schema (beta)";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DEFAULT_DATABASE_NAME)) {
            if (this.additionalProperties.get(DEFAULT_DATABASE_NAME).equals("")) {
                this.additionalProperties.remove(DEFAULT_DATABASE_NAME);
            } else {
                this.setDefaultDatabaseName((String)this.additionalProperties.get(DEFAULT_DATABASE_NAME));
                this.additionalProperties.put(DEFAULT_DATABASE_NAME, this.getDefaultDatabaseName());
            }
        }
        if (this.additionalProperties.containsKey(IDENTIFIER_NAMING_CONVENTION)) {
            this.setIdentifierNamingConvention((String)this.additionalProperties.get(IDENTIFIER_NAMING_CONVENTION));
        }
        if (this.additionalProperties.containsKey(IMPORT_MODEL_PACKAGE_NAME)) {
            this.setImportModelPackageName((String)this.additionalProperties.get(IMPORT_MODEL_PACKAGE_NAME));
        }
        if (this.additionalProperties.containsKey(PRIMARY_KEY_CONVENTION)) {
            this.setPrimaryKeyConvention((String)this.additionalProperties.get(PRIMARY_KEY_CONVENTION));
        }
        if (this.additionalProperties.containsKey(ADD_SURROGATE_KEY)) {
            this.setAddSurrogateKey(this.convertPropertyToBooleanAndWriteBack(ADD_SURROGATE_KEY));
        }
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("ktorm_schema.mustache", "", "ktorm_schema.sql"));
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        for (ModelMap mo : objs.getModels()) {
            CodegenModel model = mo.getModel();
            String modelName = model.getName();
            String tableName = this.toTableName(modelName);
            Object modelDescription = model.getDescription();
            Map<String, Object> modelVendorExtensions = model.getVendorExtensions();
            HashMap ktormSchema = new HashMap();
            HashMap<String, Object> tableDefinition = new HashMap<String, Object>();
            if (this.getIdentifierNamingConvention().equals("snake_case") && !modelName.equals(tableName)) {
                String commentExtra = "Original model name - " + modelName + ".";
                Object object = modelDescription = modelDescription == null || ((String)modelDescription).isEmpty() ? commentExtra : (String)modelDescription + ". " + commentExtra;
            }
            if (modelVendorExtensions.containsKey(VENDOR_EXTENSION_SCHEMA)) {
                this.LOGGER.info("Found vendor extension in '{}' model, autogeneration skipped", (Object)modelName);
            } else {
                modelVendorExtensions.put(VENDOR_EXTENSION_SCHEMA, ktormSchema);
                ktormSchema.put("tableDefinition", tableDefinition);
                tableDefinition.put("tblName", tableName);
                tableDefinition.put("tblComment", modelDescription);
            }
            if (!this.addSurrogateKey) continue;
            boolean hasPrimaryKey = false;
            for (CodegenProperty var : model.vars) {
                if (!var.getBaseName().equals(this.primaryKeyConvention)) continue;
                hasPrimaryKey = true;
                break;
            }
            if (hasPrimaryKey) continue;
            IntegerSchema schema = new IntegerSchema().format("int64");
            CodegenProperty cp = super.fromProperty(this.primaryKeyConvention, (Schema)schema, false);
            cp.setRequired(true);
            model.vars.add(0, cp);
            model.allVars.add(0, cp);
            model.requiredVars.add(0, cp);
            model.readWriteVars.add(0, cp);
            this.postProcessModelProperty(model, cp);
            objs = super.postProcessModels(objs);
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        HashMap<String, Object> relationDefinition = new HashMap<String, Object>();
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        KtormSchema ktormSchema = new KtormSchema();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        Object description = property.getDescription();
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '{}' property, autogeneration skipped", (Object)baseName);
            return;
        }
        vendorExtensions.put(VENDOR_EXTENSION_SCHEMA, ktormSchema);
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || ((String)description).isEmpty() ? commentExtra : (String)description + ". " + commentExtra;
        }
        switch (actualType) {
            case "boolean": {
                this.processBooleanTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            case "int": 
            case "long": {
                this.processIntegerTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            case "float": 
            case "double": 
            case "decimal": {
                this.processRealTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            case "blob": 
            case "text": 
            case "varchar": 
            case "bytes": {
                this.processStringTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            case "date": 
            case "datetime": {
                this.processDateTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            case "json": {
                this.processJsonTypeProperty(model, property, (String)description, ktormSchema);
                break;
            }
            default: {
                this.processUnknownTypeProperty(model, property, (String)description, ktormSchema);
            }
        }
        if (this.processForeignKey(model, property, relationDefinition)) {
            ktormSchema.put("relationDefinition", relationDefinition);
            ktormSchema.put("relation", true);
        }
    }

    public void processIntegerTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        Long cmax;
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        String minimum = property.getMinimum();
        String maximum = property.getMaximum();
        boolean exclusiveMinimum = property.getExclusiveMinimum();
        boolean exclusiveMaximum = property.getIExclusiveMaximum();
        boolean unsigned = false;
        Boolean isUuid = property.isUuid;
        Long cmin = minimum != null ? Long.valueOf(Long.parseLong(minimum)) : null;
        Long l = cmax = maximum != null ? Long.valueOf(Long.parseLong(maximum)) : null;
        if (exclusiveMinimum && cmin != null) {
            cmin = cmin + 1L;
        }
        if (exclusiveMaximum && cmax != null) {
            cmax = cmax - 1L;
        }
        if (cmin != null && cmin >= 0L) {
            unsigned = true;
        }
        long min = cmin != null ? cmin : Long.MIN_VALUE;
        long max = cmax != null ? cmax : Long.MAX_VALUE;
        long actualMin = Math.min(min, max);
        long actualMax = Math.max(min, max);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        columnDefinition.put("colUnsigned", unsigned);
        columnDefinition.put("colMinimum", actualMin);
        columnDefinition.put("colMaximum", actualMax);
        columnDefinition.put("colIsUuid", isUuid);
        this.processTypeArgs(dataType, dataFormat, actualMin, actualMax, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processRealTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        Float cmax;
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        String minimum = property.getMinimum();
        String maximum = property.getMaximum();
        boolean exclusiveMinimum = property.getExclusiveMinimum();
        boolean exclusiveMaximum = property.getIExclusiveMaximum();
        Float cmin = minimum != null ? Float.valueOf(Float.parseFloat(minimum)) : null;
        Float f = cmax = maximum != null ? Float.valueOf(Float.parseFloat(maximum)) : null;
        if (exclusiveMinimum && cmin != null) {
            cmin = Float.valueOf(cmin.floatValue() + 1.0f);
        }
        if (exclusiveMaximum && cmax != null) {
            cmax = Float.valueOf(cmax.floatValue() - 1.0f);
        }
        Float min = Float.valueOf(cmin != null ? cmin.floatValue() : Float.MIN_VALUE);
        Float max = Float.valueOf(cmax != null ? cmax.floatValue() : Float.MAX_VALUE);
        Float actualMin = Float.valueOf(Math.min(min.floatValue(), max.floatValue()));
        Float actualMax = Float.valueOf(Math.max(min.floatValue(), max.floatValue()));
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        columnDefinition.put("colMinimum", actualMin);
        columnDefinition.put("colMaximum", actualMax);
        this.processTypeArgs(dataType, dataFormat, actualMin, actualMax, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processBooleanTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        this.processTypeArgs(dataType, dataFormat, 0, 1, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processStringTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        Integer minLength = property.getMinLength();
        Integer maxLength = property.getMaxLength();
        Integer min = minLength != null ? minLength : 0;
        Integer max = maxLength != null ? maxLength : Integer.MAX_VALUE;
        int actualMin = Math.min(min, max);
        int actualMax = Math.max(min, max);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        if (actualMin != 0) {
            columnDefinition.put("colMinimum", actualMin);
        }
        if (actualMax != Integer.MAX_VALUE) {
            columnDefinition.put("colMaximum", actualMax);
        }
        this.processTypeArgs(dataType, dataFormat, actualMin, actualMax, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processDateTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        this.processTypeArgs(dataType, dataFormat, null, null, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processJsonTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        this.processTypeArgs(dataType, dataFormat, null, null, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processUnknownTypeProperty(CodegenModel model, CodegenProperty property, String description, KtormSchema ktormSchema) {
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String actualType = this.toColumnType(dataType, dataFormat);
        ktormSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colType", actualType);
        columnDefinition.put("colKotlinType", dataType);
        this.processTypeArgs(dataType, dataFormat, null, null, columnDefinition);
        this.processNullAndDefault(model, property, description, columnDefinition);
    }

    public void processTypeArgs(String dataType, String dataFormat, Object min, Object max, Map<String, Object> columnDefinition) {
        HashMap<String, Boolean> a = new HashMap<String, Boolean>();
        SqlTypeArgs args = new SqlTypeArgs();
        this.toColumnTypeArgs(dataType, dataFormat, min, max, args);
        a.put("isPrimitive", args.isPrimitive);
        a.put("isNumeric", args.isNumeric);
        a.put("isBoolean", args.isBoolean);
        a.put("isInteger", args.isInteger);
        a.put("isFloat", args.isFloat);
        a.put("isDecimal", args.isDecimal);
        a.put("isString", args.isString);
        a.put("isDate", args.isDate);
        a.put("isDateTime", args.isDateTime);
        a.put("isBlob", args.isBlob);
        a.put("isJson", args.isJson);
        a.put("isNull", args.isNull);
        columnDefinition.put("colPrimaryKey", this.isPrimaryKey(columnDefinition));
    }

    public void processNullAndDefault(CodegenModel model, CodegenProperty property, String description, Map<String, Object> columnDefinition) {
        String baseName = property.getBaseName();
        Boolean required = property.getRequired();
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String defaultValue = property.getDefaultValue();
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toColumnTypeDefault(defaultValue, dataType, dataFormat));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '{}' of model '{}' mapped to data type which doesn't support default value", (Object)baseName, (Object)model.getName());
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public boolean processForeignKey(CodegenModel model, CodegenProperty property, Map<String, Object> relationDefinition) {
        String dataType = property.getDataType();
        if (!property.isArray && !this.isRelation(dataType)) {
            return false;
        }
        String modelName = model.getName();
        String tryDataType = property.isArray ? property.items.dataType : property.dataType;
        String tryDataFormat = property.isArray ? property.items.dataFormat : property.dataFormat;
        Boolean isPrimitive = tryDataType.startsWith("kotlin.") || tryDataType.startsWith("java.");
        String propName = isPrimitive != false ? property.getName() : tryDataType;
        String pkName = this.toTitleCase(this.toModelName(modelName));
        String pkColName = this.toColumnName(pkName);
        String fkName = this.toTitleCase(this.toModelName(propName));
        String fkColName = this.toColumnName(fkName);
        String relName = this.toModelName(StringUtils.camelize(modelName) + StringUtils.camelize(propName));
        String relTblName = this.toTableName(relName);
        IntegerSchema pkSchema = new IntegerSchema().format("int64");
        String pkDataType = this.getSchemaType((Schema)pkSchema);
        String pkDataFormat = pkSchema.getFormat();
        String pkColType = this.toColumnType(pkDataType, pkDataFormat);
        String fkDataType = isPrimitive != false ? tryDataType : pkDataType;
        String fkDataFormat = isPrimitive != false ? tryDataFormat : pkDataFormat;
        String fkColType = this.toColumnType(fkDataType, fkDataFormat);
        SqlTypeArgs pkArgs = new SqlTypeArgs();
        this.toColumnTypeArgs(pkDataType, pkDataFormat, null, null, pkArgs);
        SqlTypeArgs fkArgs = new SqlTypeArgs();
        this.toColumnTypeArgs(fkDataType, fkDataFormat, null, null, fkArgs);
        relationDefinition.put("pkName", pkName);
        relationDefinition.put("pkColName", pkColName);
        relationDefinition.put("pkColType", pkColType);
        relationDefinition.put("pkColKotlinType", pkDataType);
        relationDefinition.put("pkIsNumeric", pkArgs.isNumeric);
        relationDefinition.put("pkIsInteger", pkArgs.isInteger);
        relationDefinition.put("pkIsString", pkArgs.isString);
        relationDefinition.put("pkIsPrimitive", pkArgs.isPrimitive);
        relationDefinition.put("fkName", fkName);
        relationDefinition.put("fkColName", fkColName);
        relationDefinition.put("fkColType", fkColType);
        relationDefinition.put("fkColKotlinType", fkDataType);
        relationDefinition.put("fkIsNumeric", fkArgs.isNumeric);
        relationDefinition.put("fkIsInteger", fkArgs.isInteger);
        relationDefinition.put("fkIsString", fkArgs.isString);
        relationDefinition.put("fkIsPrimitive", fkArgs.isPrimitive);
        relationDefinition.put("relName", relName);
        relationDefinition.put("relTblName", relTblName);
        return true;
    }

    private String toTitleCase(String input) {
        return input.substring(0, 1).toLowerCase(Locale.ROOT) + input.substring(1);
    }

    private boolean isPrimaryKey(Map<String, Object> columnDefinition) {
        String colName = (String)columnDefinition.get("colName");
        return colName.equals(this.primaryKeyConvention);
    }

    private boolean isRelation(String dataType) {
        String sqlType;
        switch (sqlType = this.sqlTypeMapping.getOrDefault(dataType, "").toLowerCase(Locale.ROOT)) {
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "decimal": 
            case "text": 
            case "varchar": 
            case "date": 
            case "datetime": 
            case "blob": 
            case "json": {
                return false;
            }
        }
        return !dataType.startsWith("kotlin.") && !dataType.startsWith("java.");
    }

    private String toColumnType(String dataType, String dataFormat) {
        String sqlType;
        switch (sqlType = this.sqlTypeMapping.getOrDefault(dataType, "").toLowerCase(Locale.ROOT)) {
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "decimal": 
            case "text": 
            case "varchar": 
            case "date": 
            case "datetime": 
            case "blob": 
            case "json": {
                return sqlType;
            }
        }
        return this.isRelation(dataType) ? "long" : "blob";
    }

    private void toColumnTypeArgs(String dataType, String dataFormat, Object min, Object max, SqlTypeArgs args) {
        String sqlType;
        switch (sqlType = this.toColumnType(dataType, dataFormat)) {
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "decimal": 
            case "text": 
            case "varchar": 
            case "date": 
            case "datetime": {
                args.isPrimitive = true;
                break;
            }
        }
        switch (sqlType) {
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "decimal": {
                args.isNumeric = true;
                break;
            }
        }
        switch (sqlType) {
            case "boolean": {
                args.isBoolean = true;
                break;
            }
            case "int": 
            case "long": {
                args.isInteger = true;
                break;
            }
            case "float": 
            case "double": {
                args.isFloat = true;
                break;
            }
            case "decimal": {
                args.isDecimal = true;
                break;
            }
            case "text": 
            case "varchar": {
                args.isString = true;
                break;
            }
            case "date": {
                args.isDate = true;
                break;
            }
            case "datetime": {
                args.isDateTime = true;
                break;
            }
            case "blob": {
                args.isBlob = true;
                break;
            }
            case "json": {
                args.isJson = true;
                break;
            }
            default: {
                args.isNull = true;
            }
        }
    }

    private Map<String, Object> toColumnTypeDefault(String defaultValue, String dataType, String dataFormat) {
        String sqlType = this.toColumnType(dataType, dataFormat);
        String sqlDefault = "";
        if (defaultValue == null || defaultValue.toUpperCase(Locale.ROOT).equals("NULL")) {
            sqlType = "null";
        }
        switch (sqlType) {
            case "boolean": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "decimal": 
            case "text": 
            case "varchar": 
            case "date": 
            case "datetime": {
                sqlDefault = defaultValue;
            }
            case "blob": 
            case "json": {
                throw new RuntimeException("The BLOB and JSON data types cannot be assigned a default value");
            }
        }
        sqlDefault = "NULL";
        HashMap<String, Object> args = new HashMap<String, Object>();
        this.processTypeArgs(sqlType, null, null, null, args);
        args.put("defaultValue", sqlDefault);
        return args;
    }

    public String toDatabaseName(String name) {
        String identifier = this.toIdentifier(name, this.databaseNamePrefix, this.databaseNameSuffix);
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Database name too long. Name '{}' will be truncated", (Object)name);
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toTableName(String name) {
        String identifier = this.toIdentifier(name, this.tableNamePrefix, this.tableNameSuffix);
        if (this.identifierNamingConvention.equals("snake_case")) {
            identifier = StringUtils.underscore(identifier);
        }
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Table name too long. Name '{}' will be truncated", (Object)name);
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toColumnName(String name) {
        String identifier = this.toIdentifier(name, this.columnNamePrefix, this.columnNameSuffix);
        if (this.identifierNamingConvention.equals("snake_case")) {
            identifier = StringUtils.underscore(identifier);
        }
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Column name too long. Name '{}' will be truncated", (Object)name);
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toIdentifier(String name, String prefix, String suffix) {
        Object escapedName = this.escapeQuotedIdentifier(name);
        if (((String)escapedName).matches(".*\\s$")) {
            this.LOGGER.warn("Database, table, and column names cannot end with space characters. Check '{}' name", (Object)name);
            escapedName = ((String)escapedName).replaceAll("\\s+$", "");
        }
        if (((String)escapedName).matches("^\\d+$")) {
            this.LOGGER.warn("Database, table, and column names cannot consist solely of digits. Check '{}' name", (Object)name);
            escapedName = prefix + (String)escapedName + suffix;
        }
        if (((String)escapedName).isEmpty()) {
            throw new RuntimeException("Empty database/table/column name for property '" + name + "' not allowed");
        }
        return escapedName;
    }

    public String escapeQuotedIdentifier(String identifier) {
        Pattern regexp = Pattern.compile("[^0-9a-zA-z$_\\x0080-\\xFFFF]");
        Matcher matcher = regexp.matcher(identifier);
        if (matcher.find()) {
            this.LOGGER.warn("Identifier '{}' contains unsafe characters out of [0-9,a-z,A-Z$_] and U+0080..U+FFFF range", (Object)identifier);
            identifier = identifier.replaceAll("[^0-9a-zA-z$_\\x0080-\\xFFFF]", "");
        }
        return identifier;
    }

    @Override
    public String escapeReservedWord(String name) {
        return name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    public void setDefaultDatabaseName(String databaseName) {
        String escapedName = this.toDatabaseName(databaseName);
        if (!escapedName.equals(databaseName)) {
            this.LOGGER.error("Invalid database name. '{}' cannot be used as identifier. Escaped value '{}' will be used instead.", (Object)databaseName, (Object)escapedName);
        }
        this.defaultDatabaseName = escapedName;
    }

    public void setIdentifierNamingConvention(String naming) {
        switch (naming) {
            case "original": 
            case "snake_case": {
                this.identifierNamingConvention = naming;
                break;
            }
            default: {
                this.LOGGER.warn("\"{}\" is invalid \"identifierNamingConvention\" argument. Current \"{}\" used instead.", (Object)naming, (Object)this.identifierNamingConvention);
            }
        }
    }

    public boolean getAddSurrogateKey() {
        return this.addSurrogateKey;
    }

    public String toSrcPath(String packageName) {
        String packagePath = org.apache.commons.lang3.StringUtils.removeStart((String)packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement("/")), (String)File.separator);
        return org.apache.commons.lang3.StringUtils.removeEnd((String)packagePath, (String)File.separator);
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.KTORM;
    }

    public String getImportModelPackageName() {
        return this.importModelPackageName;
    }

    public void setImportModelPackageName(String importModelPackageName) {
        this.importModelPackageName = importModelPackageName;
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    public String getIdentifierNamingConvention() {
        return this.identifierNamingConvention;
    }

    public String getPrimaryKeyConvention() {
        return this.primaryKeyConvention;
    }

    public void setPrimaryKeyConvention(String primaryKeyConvention) {
        this.primaryKeyConvention = primaryKeyConvention;
    }

    public void setAddSurrogateKey(boolean addSurrogateKey) {
        this.addSurrogateKey = addSurrogateKey;
    }

    private static class SqlTypeArgs {
        public boolean isPrimitive;
        public boolean isNumeric;
        public boolean isBoolean;
        public boolean isInteger;
        public boolean isFloat;
        public boolean isDecimal;
        public boolean isString;
        public boolean isDate;
        public boolean isDateTime;
        public boolean isBlob;
        public boolean isJson;
        public boolean isNull;

        private SqlTypeArgs() {
        }
    }

    private static class KtormSchema
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -9159755928980443880L;

        private KtormSchema() {
        }
    }

    protected static class SqlType {
        protected static final String Blob = "blob";
        protected static final String Boolean = "boolean";
        protected static final String Bytes = "bytes";
        protected static final String Date = "date";
        protected static final String DateTime = "datetime";
        protected static final String Decimal = "decimal";
        protected static final String Double = "double";
        protected static final String Float = "float";
        protected static final String Enum = "enum";
        protected static final String Int = "int";
        protected static final String Long = "long";
        protected static final String Text = "text";
        protected static final String Varchar = "varchar";
        protected static final String Json = "json";

        protected SqlType() {
        }
    }
}

