/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;

public class TypeScriptReduxQueryClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String USE_SINGLE_REQUEST_PARAMETER = "useSingleRequestParameter";
    protected String npmRepository = null;
    private boolean useSingleRequestParameter = true;
    protected boolean addedApiIndex = false;
    protected boolean addedModelIndex = false;

    public TypeScriptReduxQueryClientCodegen() {
        this.modifyFeatureSet(features -> features.includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}));
        this.importMapping.clear();
        this.supportsMultipleInheritance = true;
        this.outputFolder = "generated-code/typescript-redux-query";
        this.templateDir = "typescript-redux-query";
        this.embeddedTemplateDir = "typescript-redux-query";
        this.apiPackage = "src" + File.separator + "apis";
        this.modelPackage = "src" + File.separator + "models";
        this.apiTemplateFiles.put("apis.mustache", ".ts");
        this.modelTemplateFiles.put("models.mustache", ".ts");
        this.addExtraReservedWords();
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.supportModelPropertyNaming(CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.camelCase);
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_SINGLE_REQUEST_PARAMETER, "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", "boolean").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public String getName() {
        return "typescript-redux-query";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using redux-query API (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("isOriginalModelPropertyNaming", this.getModelPropertyNaming() == CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.original);
        this.additionalProperties.put("modelPropertyNaming", this.getModelPropertyNaming().name());
        this.supportingFiles.add(new SupportingFile("index.mustache", "src", "index.ts"));
        this.supportingFiles.add(new SupportingFile("runtime.mustache", "src", "runtime.ts"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        if (this.additionalProperties.containsKey(USE_SINGLE_REQUEST_PARAMETER)) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean(USE_SINGLE_REQUEST_PARAMETER));
        }
        this.writePropertyBack(USE_SINGLE_REQUEST_PARAMETER, this.getUseSingleRequestParameter());
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration();
        }
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema(p)) {
            return "Blob";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        for (ModelMap mo : models) {
            CodegenModel cm = mo.getModel();
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent != null) {
                for (CodegenProperty var : cm.allVars) {
                    if (!Boolean.TRUE.equals(var.isEnum)) continue;
                    var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                }
            }
            if (cm.oneOf.isEmpty()) continue;
            TreeSet<String> oneOfRefs = new TreeSet<String>();
            for (String im : cm.imports) {
                if (!cm.oneOf.contains(im)) continue;
                oneOfRefs.add(im);
            }
            cm.imports = oneOfRefs;
        }
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (ModelsMap entry : result.values()) {
            for (ModelMap model : entry.getModels()) {
                CodegenModel codegenModel = model.getModel();
                model.put("hasImports", codegenModel.imports.size() > 0);
            }
        }
        return result;
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("npmignore.mustache", "", ".npmignore"));
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> allModels) {
        if (!operations.isEmpty() && !this.addedApiIndex) {
            this.addedApiIndex = true;
            this.supportingFiles.add(new SupportingFile("apis.index.mustache", this.apiPackage().replace('.', File.separatorChar), "index.ts"));
        }
        if (!allModels.isEmpty() && !this.addedModelIndex) {
            this.addedModelIndex = true;
            this.supportingFiles.add(new SupportingFile("models.index.mustache", this.modelPackage().replace('.', File.separatorChar), "index.ts"));
        }
        this.addOperationModelImportInformation(operations);
        this.updateOperationParameterEnumInformation(operations);
        this.addOperationObjectResponseInformation(operations);
        return operations;
    }

    private void addOperationModelImportInformation(OperationsMap operations) {
        List<Map<String, String>> imports = operations.getImports();
        for (Map<String, String> im : imports) {
            String[] parts;
            for (String s : parts = im.get("import").replace(this.modelPackage() + ".", "").split("( [|&] )|[<>]")) {
                if (!this.needToImport(s)) continue;
                im.put("filename", im.get("import"));
                im.put("className", s);
            }
        }
    }

    private void updateOperationParameterEnumInformation(OperationsMap operations) {
        boolean hasEnum = false;
        for (CodegenOperation op : operations.getOperations().getOperation()) {
            for (CodegenParameter param : op.allParams) {
                if (!Boolean.TRUE.equals(param.isEnum)) continue;
                hasEnum = true;
                param.datatypeWithEnum = param.datatypeWithEnum.replace(param.enumName, op.operationIdCamelCase + param.enumName);
            }
        }
        operations.put("hasEnums", hasEnum);
    }

    private void addOperationObjectResponseInformation(OperationsMap operations) {
        for (CodegenOperation op : operations.getOperations().getOperation()) {
            if (!"object".equals(op.returnType)) continue;
            op.isMap = true;
            op.returnSimpleType = false;
        }
    }

    private void addExtraReservedWords() {
        this.reservedWords.add("BASE_PATH");
        this.reservedWords.add("BaseAPI");
        this.reservedWords.add("RequiredError");
        this.reservedWords.add("COLLECTION_FORMATS");
        this.reservedWords.add("ConfigurationParameters");
        this.reservedWords.add("Configuration");
        this.reservedWords.add("configuration");
        this.reservedWords.add("HTTPMethod");
        this.reservedWords.add("HTTPHeaders");
        this.reservedWords.add("HTTPQuery");
        this.reservedWords.add("HTTPBody");
        this.reservedWords.add("ModelPropertyNaming");
        this.reservedWords.add("RequestOpts");
        this.reservedWords.add("exists");
        this.reservedWords.add("RequestContext");
        this.reservedWords.add("ResponseContext");
        this.reservedWords.add("Middleware");
        this.reservedWords.add("ApiResponse");
        this.reservedWords.add("ResponseTransformer");
        this.reservedWords.add("JSONApiResponse");
        this.reservedWords.add("VoidApiResponse");
        this.reservedWords.add("BlobApiResponse");
        this.reservedWords.add("TextApiResponse");
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }
}

