/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.core;

import java.io.Console;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPInitializationException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPParsingException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jps.preset.JPForce;
import org.openbase.jps.preset.JPHelp;
import org.openbase.jps.preset.JPLogLevel;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jps.preset.JPVerbose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPService {
    private static final Set<Class<? extends AbstractJavaProperty<?>>> registeredPropertyClasses = Collections.synchronizedSet(new HashSet());
    private static final Map<Class<? extends AbstractJavaProperty<?>>, AbstractJavaProperty<?>> initializedProperties = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends AbstractJavaProperty<?>>, AbstractJavaProperty<?>> loadedProperties = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends AbstractJavaProperty<?>>, Object> overwrittenDefaultValueMap = Collections.synchronizedMap(new HashMap());
    private static Logger LOGGER = LoggerFactory.getLogger(JPService.class);
    private static String applicationName = "";
    private static String submoduleName = "";
    private static Class<?> applicationMainClass;
    private static Class<?> submoduleMainClass;
    private static boolean argumentsAnalyzed;
    private static String[] args;

    private static void initJPSDefaultProperties() {
        JPService.registerProperty(JPHelp.class);
        JPService.registerProperty(JPVerbose.class);
        JPService.registerProperty(JPLogLevel.class);
    }

    public static void setApplicationName(String name) {
        String[] prefixFilters = new String[]{"-"};
        String[] suffixFilters = new String[]{"launcher", "controller", "-"};
        applicationName = JPService.generateName(name, prefixFilters, suffixFilters);
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setApplicationName(Class<?> mainclass) {
        applicationMainClass = mainclass;
        JPService.setApplicationName(JPService.transformToKebabCase(mainclass.getSimpleName()));
    }

    public static void setSubmoduleName(String name) {
        String[] prefixFilters = new String[]{JPService.getApplicationName().toLowerCase(), "-"};
        String[] suffixFilters = new String[]{"launcher", "controller", "-"};
        submoduleName = JPService.generateName(name, prefixFilters, suffixFilters);
    }

    public static String getSubmoduleName() {
        return submoduleName;
    }

    public static void setSubmoduleName(Class<?> mainClass) {
        submoduleMainClass = mainClass;
        JPService.setSubmoduleName(JPService.transformToKebabCase(submoduleMainClass.getSimpleName()));
    }

    private static String transformToKebabCase(String string) {
        return string.replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase();
    }

    private static String generateName(String name, String[] prefixFilters, String[] suffixFilters) {
        for (String prefix : prefixFilters) {
            name = name.toLowerCase().startsWith(prefix) ? name.substring(prefix.length()) : name;
        }
        for (String suffix : suffixFilters) {
            name = name.toLowerCase().endsWith(suffix) ? name.substring(0, name.length() - suffix.length()) : name;
        }
        return name.trim();
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> void registerProperty(Class<C> propertyClass, V defaultValue) {
        JPService.registerProperty(propertyClass);
        overwrittenDefaultValueMap.put(propertyClass, defaultValue);
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> void overwriteDefaultValue(Class<C> propertyClass, V defaultValue) {
        if (argumentsAnalyzed) {
            LOGGER.warn("Property modification after argument analysis detected! Read JPService doc for more information.");
        }
        overwrittenDefaultValueMap.put(propertyClass, defaultValue);
    }

    public static void registerProperty(Class<? extends AbstractJavaProperty<?>> propertyClass) {
        if (argumentsAnalyzed) {
            LOGGER.warn("Property modification after argument analysis detected! Read JPService doc for more information.");
        }
        registeredPropertyClasses.add(propertyClass);
    }

    public static void parseAndExitOnError(List<String> args) {
        JPService.parseAndExitOnError(args.toArray(new String[args.size()]));
    }

    public static void parseAndExitOnError(String[] args) throws RuntimeException {
        try {
            JPService.parse(args);
        }
        catch (JPServiceException ex) {
            try {
                JPService.printHelp();
            }
            catch (JPServiceException ex1) {
                JPService.getApplicationLogger().error("Could not print help text!");
                JPService.printError(ex1);
            }
            JPService.printError(ex);
            JPService.getApplicationLogger().info("Exit " + applicationName);
            if (!JPService.testMode()) {
                System.exit(255);
            }
            throw new RuntimeException("Could not parse arguments!", ex);
        }
    }

    private static void handleHelpCall() throws JPServiceException {
        block5: {
            try {
                if (!JPService.getProperty(JPHelp.class).isIdentified()) break block5;
                try {
                    JPService.printHelp();
                }
                catch (Exception ex) {
                    LOGGER.error("Could not fully generate help page!", (Throwable)ex);
                }
                if (!JPService.testMode()) {
                    System.exit(0);
                }
            }
            catch (JPServiceException ex) {
                throw new JPServiceException("Could not generate help page!", ex);
            }
        }
    }

    public static void parse(List<String> args) throws JPServiceException {
        JPService.parse(args.toArray(new String[args.size()]));
    }

    public static void exitOnError() {
        JPService.parseAndExitOnError(new String[0]);
    }

    public static void parse(String[] args) throws JPServiceException {
        JPService.parse(args, false);
    }

    public static void parse(String[] args, boolean skipUnknownProperties) throws JPServiceException {
        JPService.args = args;
        argumentsAnalyzed = true;
        try {
            JPService.printValueModification(args);
            JPService.initRegisteredProperties(args, skipUnknownProperties);
            JPService.loadAllProperties(true);
        }
        catch (Exception ex) {
            throw new JPServiceException("Could not analyse arguments: " + ex.getMessage(), ex);
        }
        JPService.handleHelpCall();
    }

    public static void printError(String message, Throwable cause) {
        JPService.printError(new JPServiceException(message, cause));
    }

    public static void printError(Throwable cause) {
        JPService.getApplicationLogger().error("=========================================================================");
        JPService.printError(cause, "=");
        try {
            if (((Boolean)JPService.getProperty(JPVerbose.class).getValue()).booleanValue()) {
                cause.printStackTrace(System.err);
            }
        }
        catch (JPNotAvailableException ex) {
            JPService.getApplicationLogger().error("Could not load exception stack: " + ex.getMessage());
        }
        JPService.getApplicationLogger().error("=========================================================================");
    }

    protected static void printError(Throwable cause, String prefix) {
        JPService.getApplicationLogger().error(prefix + " " + cause.getMessage());
        Throwable innerCause = cause.getCause();
        if (innerCause != null) {
            JPService.printError(innerCause, prefix + "==");
        }
    }

    private static void printValueModification(String[] args) {
        if (args == null) {
            return;
        }
        String argsString = "";
        for (String arg : args) {
            argsString = arg.startsWith("--") ? argsString + "\n\t" : (arg.startsWith("-") ? argsString + "\n\t " : argsString + " ");
            argsString = argsString + arg;
        }
        if (!argsString.isEmpty()) {
            argsString = argsString + "\n";
            JPService.getApplicationLogger().info("[command line value modification]" + argsString);
        }
    }

    private static void initRegisteredProperties() throws JPServiceException {
        JPService.initRegisteredProperties(null, false);
    }

    private static void initRegisteredProperties(String[] args, boolean skipUnknownProperties) throws JPServiceException {
        loadedProperties.clear();
        try {
            boolean modification = true;
            while (modification) {
                modification = false;
                for (Class<? extends AbstractJavaProperty<?>> clazz : new HashSet(registeredPropertyClasses)) {
                    if (initializedProperties.containsKey(clazz)) continue;
                    JPService.initProperty(clazz);
                    modification = true;
                }
            }
            if (args != null) {
                JPService.parseArguments(args, skipUnknownProperties);
                loadedProperties.clear();
            }
        }
        catch (JPServiceException ex) {
            throw new JPServiceException("Could not init registered properties!", ex);
        }
    }

    private static synchronized AbstractJavaProperty<?> initProperty(Class<? extends AbstractJavaProperty<?>> propertyClass) throws JPServiceException {
        try {
            if (!registeredPropertyClasses.contains(propertyClass)) {
                registeredPropertyClasses.add(propertyClass);
            }
            if (initializedProperties.containsKey(propertyClass)) {
                throw new JPServiceException("Already initialized!");
            }
            AbstractJavaProperty<?> newInstance = propertyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            initializedProperties.put(propertyClass, newInstance);
            for (Class<AbstractJavaProperty<?>> dependentPropertyClass : newInstance.getDependencyList()) {
                if (initializedProperties.containsKey(dependentPropertyClass)) continue;
                JPService.initProperty(dependentPropertyClass);
            }
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JPServiceException ex) {
            throw new JPInitializationException("Could not init " + propertyClass.getSimpleName(), ex);
        }
    }

    public static void setupJUnitTestMode() throws JPServiceException {
        try {
            JPService.registerProperty(JPVerbose.class, true);
            JPService.registerProperty(JPTestMode.class, true);
            JPService.initRegisteredProperties();
        }
        catch (JPValidationException ex) {
            throw new JPServiceException("Could not setup JPService for UnitTestMode!", ex);
        }
    }

    private static <O> void loadProperty(AbstractJavaProperty<O> property, boolean errorReport) throws JPServiceException {
        block9: {
            try {
                block8: {
                    if (loadedProperties.containsKey(property.getClass()) && !loadedProperties.get(property.getClass()).neetToBeParsed()) {
                        return;
                    }
                    try {
                        JPService.parseProperty(property);
                    }
                    catch (JPBadArgumentException ex) {
                        if (!errorReport) break block8;
                        throw ex;
                    }
                }
                if (overwrittenDefaultValueMap.containsKey(property.getClass())) {
                    property.overwriteDefaultValue(overwrittenDefaultValueMap.get(property.getClass()));
                }
                property.updateValue();
                property.validate();
            }
            catch (JPBadArgumentException | JPValidationException ex) {
                if (!errorReport) break block9;
                throw new JPServiceException("Could not load " + property + "!", ex);
            }
        }
        loadedProperties.put(property.getClass(), property);
        try {
            property.loadAction();
        }
        catch (Throwable ex) {
            throw new JPServiceException("Could not load Property[" + property.getClass().getSimpleName() + "] action!", ex);
        }
    }

    private static void parseArguments(String[] args, boolean skipUnknownProperties) throws JPServiceException {
        AbstractJavaProperty<?> lastProperty = null;
        boolean unknownProperty = true;
        block4: for (String arg : args) {
            try {
                arg = arg.trim();
                if (arg.equals("--")) break;
                if (arg.startsWith("-D")) {
                    try {
                        String propertyString = arg.substring(2);
                        if (propertyString.contains("=")) {
                            String[] keyValueArray = propertyString.split("=");
                            System.setProperty(keyValueArray[0], keyValueArray[1]);
                            continue;
                        }
                        System.setProperty(propertyString, "");
                        continue;
                    }
                    catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException | SecurityException ex) {
                        throw new JPParsingException("invalid system property syntax: " + arg);
                    }
                }
                if (arg.startsWith("-") || arg.startsWith("--")) {
                    unknownProperty = true;
                    lastProperty = null;
                    for (AbstractJavaProperty<?> property : initializedProperties.values()) {
                        if (!property.match(arg)) continue;
                        property.reset();
                        lastProperty = property;
                        unknownProperty = false;
                        continue block4;
                    }
                    if (arg.startsWith("-", 0) && !arg.startsWith("-", 1) && arg.length() > 2) {
                        unknownProperty = false;
                        block6: for (int i = 1; i < arg.length(); ++i) {
                            String singleArg = "-" + arg.substring(i, i + 1);
                            for (AbstractJavaProperty<?> property : initializedProperties.values()) {
                                if (!property.match(singleArg)) continue;
                                property.reset();
                                continue block6;
                            }
                            unknownProperty = true;
                            if (skipUnknownProperties) continue;
                            throw new JPParsingException("unknown property: " + singleArg);
                        }
                    }
                    if (skipUnknownProperties || !unknownProperty) continue;
                    throw new JPParsingException("unknown property: " + arg);
                }
                if (skipUnknownProperties && unknownProperty) continue;
                if (lastProperty == null) {
                    throw new JPParsingException("found value without property assignment: " + arg);
                }
                lastProperty.addArgument(arg);
            }
            catch (JPServiceException ex) {
                throw new JPServiceException("Could not parse Argument[" + arg + "]!", ex);
            }
        }
    }

    private static void parseProperty(AbstractJavaProperty<?> property) throws JPBadArgumentException {
        if (property.neetToBeParsed()) {
            try {
                property.parseArguments();
            }
            catch (Exception ex) {
                throw new JPBadArgumentException("Could not parse " + property + "!", ex);
            }
        }
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> V getValue(Class<C> propertyClass, V alternative) {
        try {
            return ((AbstractJavaProperty)JPService.getProperty(propertyClass)).getValue();
        }
        catch (JPNotAvailableException e) {
            return alternative;
        }
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> V getValue(Class<C> propertyClass) throws JPNotAvailableException {
        return ((AbstractJavaProperty)JPService.getProperty(propertyClass)).getValue();
    }

    public static synchronized <V, C extends AbstractJavaProperty<V>> V getPreEvaluatedValue(Class<C> propertyClass, String[] args, V alternative) {
        try {
            return JPService.getPreEvaluatedValue(propertyClass, args);
        }
        catch (JPServiceException e) {
            return alternative;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <V, C extends AbstractJavaProperty<V>> V getPreEvaluatedValue(Class<C> propertyClass, String[] args) throws JPServiceException {
        V value;
        if (argumentsAnalyzed) {
            throw new RuntimeException("Pre evaluated java property value was requested after the application arguments were parsed!");
        }
        HashSet previouslyRegisteredPropertyClasses = new HashSet(registeredPropertyClasses);
        HashMap previouslyOverwrittenDefaultValueMap = new HashMap(overwrittenDefaultValueMap);
        try {
            JPService.registerProperty(propertyClass);
            JPService.initRegisteredProperties(args, true);
            value = ((AbstractJavaProperty)JPService.getProperty(propertyClass)).getValue();
        }
        finally {
            JPService.reset();
            for (Class clazz : previouslyRegisteredPropertyClasses) {
                JPService.registerProperty(clazz);
            }
            for (Map.Entry entry : previouslyOverwrittenDefaultValueMap.entrySet()) {
                overwrittenDefaultValueMap.put((Class)entry.getKey(), entry.getValue());
            }
        }
        return value;
    }

    public static synchronized <C extends AbstractJavaProperty> C getProperty(Class<C> propertyClass) throws JPNotAvailableException {
        return JPService.getProperty(propertyClass, true);
    }

    private static synchronized <C extends AbstractJavaProperty<?>> C getProperty(Class<C> propertyClass, boolean errorReport) throws JPNotAvailableException {
        try {
            if (propertyClass == null) {
                throw new JPNotAvailableException(propertyClass, (Throwable)new JPServiceException("Given propertyClass is a Nullpointer!"));
            }
            if (!loadedProperties.containsKey(propertyClass) || loadedProperties.get(propertyClass).neetToBeParsed()) {
                if (!initializedProperties.containsKey(propertyClass)) {
                    JPService.initProperty(propertyClass);
                }
                JPService.loadProperty(initializedProperties.get(propertyClass), errorReport);
            }
            return (C)loadedProperties.get(propertyClass);
        }
        catch (JPServiceException ex) {
            throw new JPNotAvailableException(propertyClass, (Throwable)ex);
        }
    }

    private static List<AbstractJavaProperty<?>> loadAllProperties(boolean errorReport) throws JPServiceException {
        ArrayList properties = new ArrayList();
        HashSet currentlyRegisteredPropertyClasses = new HashSet(registeredPropertyClasses);
        boolean modification = true;
        while (modification) {
            modification = false;
            for (Class clazz : currentlyRegisteredPropertyClasses) {
                try {
                    properties.add((AbstractJavaProperty<?>)JPService.getProperty(clazz, errorReport));
                }
                catch (Exception ex) {
                    if (errorReport) {
                        throw new JPServiceException("Could not load Property[" + clazz.getSimpleName() + "]!", ex);
                    }
                    LOGGER.debug("Could not load Property[" + clazz.getSimpleName() + "]!", (Throwable)ex);
                }
            }
        }
        return properties;
    }

    public static void printHelp() throws JPServiceException {
        String help = "Help Page:\n\nusage: " + applicationName;
        String header = "";
        ArrayList propertyList = new ArrayList(initializedProperties.values());
        Collections.sort(propertyList);
        header = propertyList.stream().map(property -> " [" + property.getSyntax() + "]").reduce(header, (s, str) -> s.concat((String)str));
        help = help + JPService.newLineFormatter(header, "\n\t", 100);
        help = help + "\nwhere:\n";
        List<AbstractJavaProperty<?>> properties = JPService.loadAllProperties(false);
        Collections.sort(properties, (o1, o2) -> {
            try {
                return o1.getDefaultExample().compareTo(o2.getDefaultExample());
            }
            catch (Exception ex) {
                JPService.getApplicationLogger().warn("Could not compare properties!");
                return -1;
            }
        });
        for (AbstractJavaProperty<?> property2 : properties) {
            help = help + "\t" + property2.getSyntax() + " " + JPService.getDefault(property2);
            help = help + "\n ";
            help = help + "\t\t" + JPService.newLineFormatter(property2.getDescription(), "\n\t\t", 100);
            help = help + "\n";
        }
        JPService.getApplicationLogger().info(help);
    }

    public static Logger getApplicationLogger(Logger defaultLogger) {
        if (submoduleMainClass != null) {
            return LoggerFactory.getLogger(submoduleMainClass);
        }
        if (applicationMainClass != null) {
            return LoggerFactory.getLogger(applicationMainClass);
        }
        return defaultLogger;
    }

    public static Logger getApplicationLogger() {
        return JPService.getApplicationLogger(LOGGER);
    }

    private static String getDefault(AbstractJavaProperty<?> property) {
        return "[Default: " + property.getDefaultExample() + "]";
    }

    public static String newLineFormatter(String text, String newLineOperator, int maxChars) {
        String[] textArray = text.split(" ");
        text = "";
        int charCounter = 0;
        for (int i = 0; i < textArray.length; ++i) {
            if (charCounter + textArray[i].length() >= maxChars) {
                text = text + newLineOperator + textArray[i];
                charCounter = textArray[i].length();
            } else {
                text = text + textArray[i];
                charCounter = textArray[i].contains("\n") ? textArray[i].indexOf("\n") : (charCounter += textArray[i].length());
            }
            if (i == textArray.length - 1) continue;
            text = text + " ";
        }
        return text;
    }

    public static final void awaitUserConfirmationOrExit(String infoMessage, String cancelMessage, int exitCode) {
        Console console = System.console();
        if (console == null) {
            System.err.println(infoMessage);
            try {
                int read = System.in.read();
                if (read != 121 && read != 106 && read != 122) {
                    System.err.println(cancelMessage);
                    System.exit(exitCode);
                }
            }
            catch (IOException ex) {
                System.err.println(cancelMessage);
                System.exit(exitCode);
            }
        } else {
            String userConfirmation = console.readLine(infoMessage, new Object[0]).toLowerCase();
            if (!(userConfirmation.contains("y") || userConfirmation.contains("j") || userConfirmation.contains("z"))) {
                System.err.println(cancelMessage);
                System.exit(exitCode);
            }
        }
    }

    public static String[] getArgs() {
        return args;
    }

    public static void reset() {
        registeredPropertyClasses.clear();
        initializedProperties.clear();
        loadedProperties.clear();
        overwrittenDefaultValueMap.clear();
        argumentsAnalyzed = false;
        JPService.initJPSDefaultProperties();
    }

    public static boolean testMode() {
        try {
            return (Boolean)JPService.getProperty(JPTestMode.class).getValue();
        }
        catch (JPServiceException ex) {
            JPService.printError("Could not detect TestMode!", ex);
            return false;
        }
    }

    public static boolean verboseMode() {
        try {
            return (Boolean)JPService.getProperty(JPVerbose.class).getValue();
        }
        catch (JPServiceException ex) {
            JPService.printError("Could not detect VerboseMode!", ex);
            return false;
        }
    }

    public static boolean forceMode() {
        try {
            return (Boolean)JPService.getProperty(JPForce.class).getValue();
        }
        catch (JPServiceException ex) {
            JPService.printError("Could not detect ForceMode!", ex);
            return false;
        }
    }

    public static boolean debugMode() {
        try {
            return (Boolean)JPService.getProperty(JPDebugMode.class).getValue();
        }
        catch (JPServiceException ex) {
            JPService.printError("Could not detect DebugMode!", ex);
            return false;
        }
    }

    static {
        argumentsAnalyzed = false;
        args = new String[0];
        JPService.initJPSDefaultProperties();
    }
}

