/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.tools.FileHandler;

public class JPSystemDirectory
extends AbstractJPDirectory {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--usr"};

    public JPSystemDirectory() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
    }

    @Override
    public File getParentDirectory() throws JPNotAvailableException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(System.getenv("WINDIR"));
        }
        return new File("/");
    }

    @Override
    protected File getPropertyDefaultValue() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File("system32");
        }
        return new File("usr");
    }

    @Override
    public void validate() throws JPValidationException {
        if (JPService.testMode()) {
            this.setAutoCreateMode(FileHandler.AutoMode.On);
            this.setExistenceHandling(FileHandler.ExistenceHandling.Must);
        }
        super.validate();
    }

    @Override
    public String getDescription() {
        return "Specifies the global system directory which is used to lookup static resources like databases, models, templates or images.";
    }
}

