/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.HashMap;

public class OpenBaseLogConfigurator
extends ContextAwareBase
implements Configurator {
    public void configure(LoggerContext context) {
        this.addInfo("Setting up default configuration.");
        HashMap<String, String> ruleRegistry = (HashMap<String, String>)context.getObject("PATTERN_RULE_REGISTRY");
        if (ruleRegistry == null) {
            ruleRegistry = new HashMap<String, String>();
        }
        ruleRegistry.put("messageHighlighting", "org.openbase.log.OpenBaseLogbackMessageColorTheme");
        ruleRegistry.put("loggerHighlighting", "org.openbase.log.OpenBaseLogbackLoggerColorTheme");
        context.putObject("PATTERN_RULE_REGISTRY", ruleRegistry);
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext((Context)context);
        consoleAppender.setName("STDOUT");
        consoleAppender.setWithJansi(true);
        PatternLayout layout = new PatternLayout();
        layout.setPattern("%d{HH:mm:ss.SSS} [%thread] %loggerHighlighting(%-5level) %cyan(%logger{15}) %messageHighlighting(%msg%n)");
        layout.setContext((Context)context);
        layout.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setContext((Context)context);
        encoder.setLayout((Layout)layout);
        consoleAppender.setEncoder((Encoder)encoder);
        consoleAppender.start();
        Logger rootLogger = context.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender((Appender)consoleAppender);
    }
}

