/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.jps.exception.JPParsingException;
import org.openbase.jps.preset.AbstractJPMap;

public abstract class AbstractJPMapStringString
extends AbstractJPMap<String, String> {
    public AbstractJPMapStringString(String[] commandIdentifier) {
        super(commandIdentifier);
    }

    @Override
    protected Map<String, String> parse(List<String> arguments) throws Exception {
        this.checkArgumentCountMin(1);
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String argument : arguments) {
            if (!argument.contains("=")) {
                throw new JPParsingException("KeyValueSeparator[=] is missing for Argument[" + argument + "].");
            }
            String[] split = argument.split("=");
            if (split.length != 2) {
                throw new JPParsingException("Argument[" + argument + "] does not contain a valid key value mapping!");
            }
            keyValueMap.put(split[0], split[1]);
        }
        return keyValueMap;
    }
}

