/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.tools.FileHandler;

public class JPLocalUserPrefix
extends AbstractJPDirectory {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--local-user-prefix"};

    public JPLocalUserPrefix() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
    }

    @Override
    protected File getPropertyDefaultValue() {
        String localUserPath = System.getProperty("user.home");
        if (localUserPath == null) {
            File executionFolder = new File(".");
            this.logger.warn("Could not load user prefix! Use execution folder[" + executionFolder.getAbsolutePath() + "] instead.");
            return executionFolder;
        }
        return new File(localUserPath);
    }

    @Override
    public String getDescription() {
        return "Overwrites the local user prefix.";
    }
}

