/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.exception.JPBadArgumentException;

public class JPLocale
extends AbstractJavaProperty<Locale> {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--locale"};
    public static final String[] ARGUMENT_IDENTIFIERS = new String[]{Locale.class.getSimpleName().toUpperCase()};

    public JPLocale() {
        super(COMMAND_IDENTIFIERS);
    }

    @Override
    protected String[] generateArgumentIdentifiers() {
        return ARGUMENT_IDENTIFIERS;
    }

    @Override
    protected Locale getPropertyDefaultValue() {
        return Locale.getDefault();
    }

    @Override
    protected Locale parse(List<String> arguments) throws JPBadArgumentException {
        String oneArgumentResult = this.getOneArgumentResult();
        try {
            Locale locale = this.parseLocale(oneArgumentResult);
            if (!this.isValid(locale)) {
                throw new JPBadArgumentException("Given Language is unknown!");
            }
            return locale;
        }
        catch (NullPointerException ex) {
            throw new JPBadArgumentException("Could not load language!", ex);
        }
    }

    @Override
    public String getDescription() {
        return "Specifies the language to use for this application.";
    }

    private Locale parseLocale(String locale) {
        String[] elements = locale.split("_");
        switch (elements.length) {
            case 1: {
                return new Locale(elements[0]);
            }
            case 2: {
                return new Locale(elements[0], elements[1]);
            }
            case 3: {
                return new Locale(elements[0], elements[1], elements[2]);
            }
        }
        throw new IllegalArgumentException("Invalid locale: " + locale);
    }

    private boolean isValid(Locale locale) {
        try {
            return locale.getISO3Language() != null && locale.getISO3Country() != null;
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }
}

