/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.AbstractJPEnum;
import org.slf4j.LoggerFactory;

public class JPLogLevel
extends AbstractJPEnum<LogLevel> {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--log-level"};

    public JPLogLevel() {
        super(COMMAND_IDENTIFIERS);
    }

    @Override
    protected LogLevel getPropertyDefaultValue() throws JPNotAvailableException {
        try {
            return LogLevel.valueOf(this.getRootLogger().getLevel().toString());
        }
        catch (Exception ex) {
            this.logger.warn("Could detect default log level: {}", (Object)ex.getMessage());
            return LogLevel.INFO;
        }
    }

    @Override
    public String getDescription() {
        return "Changes the log level to the given one. Valid values are [].";
    }

    private Logger getRootLogger() throws JPServiceException {
        try {
            return (Logger)LoggerFactory.getLogger((String)"ROOT");
        }
        catch (Exception ex) {
            throw new JPServiceException("RootLogger is not available!", ex);
        }
        catch (NoClassDefFoundError ex) {
            throw new JPServiceException("Logback logger framework seems not to be supported by this platform.", ex);
        }
    }

    @Override
    protected void loadAction() {
        super.loadAction();
        try {
            this.getRootLogger().setLevel(Level.valueOf((String)((LogLevel)((Object)this.getValue())).name()));
        }
        catch (JPServiceException ex) {
            this.logger.warn("Could not apply log level: {}", (Object)ex.getMessage());
        }
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

